/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.cmd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.activiti5.engine.ActivitiIllegalArgumentException;
import org.activiti5.engine.ActivitiObjectNotFoundException;
import org.activiti5.engine.impl.interceptor.Command;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.persistence.entity.ResourceEntity;
import org.activiti5.engine.repository.Deployment;

public class GetDeploymentResourceCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected String resourceName;

    public GetDeploymentResourceCmd(String deploymentId, String resourceName) {
        this.deploymentId = deploymentId;
        this.resourceName = resourceName;
    }

    @Override
    public InputStream execute(CommandContext commandContext) {
        if (this.deploymentId == null) {
            throw new ActivitiIllegalArgumentException("deploymentId is null");
        }
        if (this.resourceName == null) {
            throw new ActivitiIllegalArgumentException("resourceName is null");
        }
        ResourceEntity resource = commandContext.getResourceEntityManager().findResourceByDeploymentIdAndResourceName(this.deploymentId, this.resourceName);
        if (resource == null) {
            if (commandContext.getDeploymentEntityManager().findDeploymentById(this.deploymentId) == null) {
                throw new ActivitiObjectNotFoundException("deployment does not exist: " + this.deploymentId, Deployment.class);
            }
            throw new ActivitiObjectNotFoundException("no resource found with name '" + this.resourceName + "' in deployment '" + this.deploymentId + "'", InputStream.class);
        }
        return new ByteArrayInputStream(resource.getBytes());
    }
}

