/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.form.StartFormData;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti5.engine.ActivitiException;
import org.activiti5.engine.ActivitiObjectNotFoundException;
import org.activiti5.engine.impl.form.FormEngine;
import org.activiti5.engine.impl.form.StartFormHandler;
import org.activiti5.engine.impl.interceptor.Command;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.persistence.entity.ProcessDefinitionEntity;

public class GetRenderedStartFormCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected String formEngineName;

    public GetRenderedStartFormCmd(String processDefinitionId, String formEngineName) {
        this.processDefinitionId = processDefinitionId;
        this.formEngineName = formEngineName;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        ProcessDefinition processDefinition = commandContext.getProcessEngineConfiguration().getDeploymentManager().findDeployedProcessDefinitionById(this.processDefinitionId);
        if (processDefinition == null) {
            throw new ActivitiObjectNotFoundException("Process Definition '" + this.processDefinitionId + "' not found", ProcessDefinition.class);
        }
        StartFormHandler startFormHandler = ((ProcessDefinitionEntity)processDefinition).getStartFormHandler();
        if (startFormHandler == null) {
            return null;
        }
        FormEngine formEngine = commandContext.getProcessEngineConfiguration().getFormEngines().get(this.formEngineName);
        if (formEngine == null) {
            throw new ActivitiException("No formEngine '" + this.formEngineName + "' defined process engine configuration");
        }
        StartFormData startForm = startFormHandler.createStartFormData(processDefinition);
        return formEngine.renderStartForm(startForm);
    }
}

