/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.jobexecutor;

import org.activiti.engine.impl.asyncexecutor.AsyncExecutor;
import org.activiti.engine.impl.cfg.TransactionPropagation;
import org.activiti.engine.runtime.Job;
import org.activiti5.engine.impl.interceptor.Command;
import org.activiti5.engine.impl.interceptor.CommandConfig;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.interceptor.CommandContextCloseListener;
import org.activiti5.engine.impl.interceptor.CommandExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncJobAddedNotification
implements CommandContextCloseListener {
    private static Logger log = LoggerFactory.getLogger(AsyncJobAddedNotification.class);
    protected Job job;
    protected AsyncExecutor asyncExecutor;

    public AsyncJobAddedNotification(Job job, AsyncExecutor asyncExecutor) {
        this.job = job;
        this.asyncExecutor = asyncExecutor;
    }

    @Override
    public void closed(CommandContext commandContext) {
        CommandExecutor commandExecutor = commandContext.getProcessEngineConfiguration().getCommandExecutor();
        CommandConfig commandConfig = new CommandConfig(false, TransactionPropagation.REQUIRES_NEW);
        commandExecutor.execute(commandConfig, new Command<Void>(){

            @Override
            public Void execute(CommandContext commandContext) {
                log.debug("notifying job executor of new job");
                AsyncJobAddedNotification.this.asyncExecutor.executeAsyncJob(AsyncJobAddedNotification.this.job);
                return null;
            }
        });
    }

    @Override
    public void closing(CommandContext commandContext) {
    }
}

