/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.jobexecutor;

import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.runtime.Job;
import org.activiti5.engine.ActivitiException;
import org.activiti5.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.jobexecutor.JobHandler;
import org.activiti5.engine.impl.jobexecutor.TimerEventHandler;
import org.activiti5.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti5.engine.impl.pvm.process.ActivityImpl;
import org.activiti5.engine.logging.LogMDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerCatchIntermediateEventJobHandler
extends TimerEventHandler
implements JobHandler {
    private static Logger log = LoggerFactory.getLogger(TimerCatchIntermediateEventJobHandler.class);
    public static final String TYPE = "timer-intermediate-transition";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(Job job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        String nestedActivityId = TimerEventHandler.getActivityIdFromConfiguration(configuration);
        ActivityImpl intermediateEventActivity = execution.getProcessDefinition().findActivity(nestedActivityId);
        if (intermediateEventActivity == null) {
            throw new ActivitiException("Error while firing timer: intermediate event activity " + nestedActivityId + " not found");
        }
        try {
            if (commandContext.getEventDispatcher().isEnabled()) {
                commandContext.getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TIMER_FIRED, job));
            }
            if (!execution.getActivity().getId().equals(intermediateEventActivity.getId())) {
                execution.setActivity(intermediateEventActivity);
            }
            execution.signal(null, null);
        }
        catch (RuntimeException e) {
            LogMDC.putMDCExecution(execution);
            log.error("exception during timer execution", (Throwable)e);
            LogMDC.clear();
            throw e;
        }
        catch (Exception e) {
            LogMDC.putMDCExecution(execution);
            log.error("exception during timer execution", (Throwable)e);
            LogMDC.clear();
            throw new ActivitiException("exception during timer execution: " + e.getMessage(), e);
        }
    }
}

