/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.persistence.entity;

import org.activiti5.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti5.engine.impl.persistence.entity.ExecutionEntity;

public class CompensateEventSubscriptionEntity
extends EventSubscriptionEntity {
    private static final long serialVersionUID = 1L;

    private CompensateEventSubscriptionEntity() {
    }

    private CompensateEventSubscriptionEntity(ExecutionEntity executionEntity) {
        super(executionEntity);
        this.eventType = "compensate";
    }

    public static CompensateEventSubscriptionEntity createAndInsert(ExecutionEntity executionEntity) {
        CompensateEventSubscriptionEntity eventSubscription = new CompensateEventSubscriptionEntity(executionEntity);
        if (executionEntity.getTenantId() != null) {
            eventSubscription.setTenantId(executionEntity.getTenantId());
        }
        eventSubscription.insert();
        return eventSubscription;
    }

    @Override
    protected void processEventSync(Object payload) {
        this.delete();
        super.processEventSync(payload);
    }

    public CompensateEventSubscriptionEntity moveUnder(ExecutionEntity newExecution) {
        this.delete();
        CompensateEventSubscriptionEntity newSubscription = CompensateEventSubscriptionEntity.createAndInsert(newExecution);
        newSubscription.setActivity(this.getActivity());
        newSubscription.setConfiguration(this.configuration);
        newSubscription.setCreated(this.created);
        return newSubscription;
    }
}

