/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.variable;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.persistence.EntityManager;
import org.activiti5.engine.ActivitiException;
import org.activiti5.engine.ActivitiIllegalArgumentException;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.util.ReflectUtil;
import org.activiti5.engine.impl.variable.EntityManagerSession;
import org.activiti5.engine.impl.variable.EntityMetaData;
import org.activiti5.engine.impl.variable.JPAEntityScanner;

public class JPAEntityMappings {
    private Map<String, EntityMetaData> classMetaDatamap = new HashMap<String, EntityMetaData>();
    private JPAEntityScanner enitityScanner = new JPAEntityScanner();

    public boolean isJPAEntity(Object value) {
        if (value != null) {
            return this.getEntityMetaData(value.getClass()).isJPAEntity();
        }
        return false;
    }

    public EntityMetaData getEntityMetaData(Class<?> clazz) {
        EntityMetaData metaData = this.classMetaDatamap.get(clazz.getName());
        if (metaData == null) {
            metaData = this.scanClass(clazz);
            this.classMetaDatamap.put(clazz.getName(), metaData);
        }
        return metaData;
    }

    private EntityMetaData scanClass(Class<?> clazz) {
        return this.enitityScanner.scanClass(clazz);
    }

    public String getJPAClassString(Object value) {
        if (value == null) {
            throw new ActivitiIllegalArgumentException("null value cannot be saved");
        }
        EntityMetaData metaData = this.getEntityMetaData(value.getClass());
        if (!metaData.isJPAEntity()) {
            throw new ActivitiIllegalArgumentException("Object is not a JPA Entity: class='" + value.getClass() + "', " + value);
        }
        return metaData.getEntityClass().getName();
    }

    public String getJPAIdString(Object value) {
        EntityMetaData metaData = this.getEntityMetaData(value.getClass());
        if (!metaData.isJPAEntity()) {
            throw new ActivitiIllegalArgumentException("Object is not a JPA Entity: class='" + value.getClass() + "', " + value);
        }
        Object idValue = this.getIdValue(value, metaData);
        return this.getIdString(idValue);
    }

    public Object getIdValue(Object value, EntityMetaData metaData) {
        try {
            if (metaData.getIdMethod() != null) {
                return metaData.getIdMethod().invoke(value, new Object[0]);
            }
            if (metaData.getIdField() != null) {
                return metaData.getIdField().get(value);
            }
        }
        catch (IllegalArgumentException iae) {
            throw new ActivitiException("Illegal argument exception when getting value from id method/field on JPAEntity", iae);
        }
        catch (IllegalAccessException iae) {
            throw new ActivitiException("Cannot access id method/field for JPA Entity", iae);
        }
        catch (InvocationTargetException ite) {
            throw new ActivitiException("Exception occured while getting value from id field/method on JPAEntity: " + ite.getCause().getMessage(), ite.getCause());
        }
        throw new ActivitiException("Cannot get id from JPA Entity, no id method/field set");
    }

    public Object getJPAEntity(String className, String idString) {
        Class<?> entityClass = null;
        entityClass = ReflectUtil.loadClass(className);
        EntityMetaData metaData = this.getEntityMetaData(entityClass);
        if (metaData == null) {
            throw new ActivitiIllegalArgumentException("Class is not a JPA-entity: " + className);
        }
        Object primaryKey = this.createId(metaData, idString);
        return this.findEntity(entityClass, primaryKey);
    }

    private Object findEntity(Class<?> entityClass, Object primaryKey) {
        EntityManager em = Context.getCommandContext().getSession(EntityManagerSession.class).getEntityManager();
        Object entity = em.find(entityClass, primaryKey);
        if (entity == null) {
            throw new ActivitiException("Entity does not exist: " + entityClass.getName() + " - " + primaryKey);
        }
        return entity;
    }

    public Object createId(EntityMetaData metaData, String string) {
        Class<?> type = metaData.getIdType();
        if (type == Long.class || type == Long.TYPE) {
            return Long.parseLong(string);
        }
        if (type == String.class) {
            return string;
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return Byte.parseByte(string);
        }
        if (type == Short.class || type == Short.TYPE) {
            return Short.parseShort(string);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Integer.parseInt(string);
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(string));
        }
        if (type == Double.class || type == Double.TYPE) {
            return Double.parseDouble(string);
        }
        if (type == Character.class || type == Character.TYPE) {
            return new Character(string.charAt(0));
        }
        if (type == java.util.Date.class) {
            return new java.util.Date(Long.parseLong(string));
        }
        if (type == Date.class) {
            return new Date(Long.parseLong(string));
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(string);
        }
        if (type == BigInteger.class) {
            return new BigInteger(string);
        }
        if (type == UUID.class) {
            return UUID.fromString(string);
        }
        throw new ActivitiIllegalArgumentException("Unsupported Primary key type for JPA-Entity: " + type.getName());
    }

    public String getIdString(Object value) {
        if (value == null) {
            throw new ActivitiIllegalArgumentException("Value of primary key for JPA-Entity cannot be null");
        }
        if (value instanceof java.util.Date) {
            return "" + ((java.util.Date)value).getTime();
        }
        if (value instanceof Date) {
            return "" + ((Date)value).getTime();
        }
        if (value instanceof Long || value instanceof String || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Float || value instanceof Double || value instanceof Character || value instanceof BigDecimal || value instanceof BigInteger || value instanceof UUID) {
            return value.toString();
        }
        throw new ActivitiIllegalArgumentException("Unsupported Primary key type for JPA-Entity: " + value.getClass().getName());
    }
}

