/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.emitter;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.PolicyUtil;
import org.apache.axis2.util.Utils;
import org.apache.axis2.wsdl.SOAPHeaderMessage;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.axis2.wsdl.codegen.emitter.AxisServiceBasedMultiLanguageEmitter;
import org.apache.axis2.wsdl.codegen.writer.CBuildScriptWriter;
import org.apache.axis2.wsdl.codegen.writer.CServiceXMLWriter;
import org.apache.axis2.wsdl.codegen.writer.CSkelHeaderWriter;
import org.apache.axis2.wsdl.codegen.writer.CSkelSourceWriter;
import org.apache.axis2.wsdl.codegen.writer.CStubHeaderWriter;
import org.apache.axis2.wsdl.codegen.writer.CStubSourceWriter;
import org.apache.axis2.wsdl.codegen.writer.CSvcSkeletonWriter;
import org.apache.axis2.wsdl.databinding.CUtils;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CEmitter
extends AxisServiceBasedMultiLanguageEmitter {
    protected static final String C_STUB_PREFIX = "axis2_stub_";
    protected static final String C_SKEL_PREFIX = "axis2_skel_";
    protected static final String C_SVC_SKEL_PREFIX = "axis2_svc_skel_";
    protected static final String C_STUB_SUFFIX = "";
    protected static final String C_SKEL_SUFFIX = "";
    protected static final String C_SVC_SKEL_SUFFIX = "";
    protected static final String JAVA_DEFAULT_TYPE = "org.apache.axiom.om.OMElement";
    protected static final String C_DEFAULT_TYPE = "axiom_node_t*";
    protected static final String C_OUR_TYPE_PREFIX = "axis2_";
    protected static final String C_OUR_TYPE_SUFFIX = "_t*";

    public void emitStub() throws CodeGenerationException {
        try {
            this.writeCStub();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void emitSkeleton() throws CodeGenerationException {
        try {
            this.writeCSkel();
            this.writeCServiceSkeleton();
            this.emitBuildScript();
            this.writeServiceXml();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void emitBuildScript() throws CodeGenerationException {
        try {
            this.writeBuildScript();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void writeCStub() throws Exception {
        Document interfaceImplModel = this.createDOMDocumentForInterfaceImplementation();
        CStubHeaderWriter writerHStub = new CStubHeaderWriter(this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getSourceLocation()), this.codeGenConfiguration.getOutputLanguage());
        this.writeFile(interfaceImplModel, writerHStub);
        CStubSourceWriter writerCStub = new CStubSourceWriter(this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getSourceLocation()), this.codeGenConfiguration.getOutputLanguage());
        this.writeFile(interfaceImplModel, writerCStub);
    }

    protected void writeCSkel() throws Exception {
        Document skeletonModel = this.createDOMDocumentForSkeleton(this.codeGenConfiguration.isServerSideInterface());
        CSkelHeaderWriter skeletonWriter = new CSkelHeaderWriter(this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getSourceLocation()), this.codeGenConfiguration.getOutputLanguage());
        this.writeFile(skeletonModel, skeletonWriter);
        CSkelSourceWriter skeletonWriterStub = new CSkelSourceWriter(this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getSourceLocation()), this.codeGenConfiguration.getOutputLanguage());
        this.writeFile(skeletonModel, skeletonWriterStub);
    }

    protected void writeCServiceSkeleton() throws Exception {
        Document skeletonModel = this.createDOMDocumentForServiceSkeletonXML();
        CSvcSkeletonWriter writer = new CSvcSkeletonWriter(this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getSourceLocation()), this.codeGenConfiguration.getOutputLanguage());
        this.writeFile(skeletonModel, writer);
    }

    protected void writeBuildScript() throws Exception {
        if (this.codeGenConfiguration.isGenerateDeployementDescriptor()) {
            Document buildXMLModel = this.createDOMDocumentForBuildScript(this.codeGenConfiguration);
            CBuildScriptWriter buildXmlWriter = new CBuildScriptWriter(this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getSourceLocation()), this.codeGenConfiguration.getOutputLanguage());
            this.writeFile(buildXMLModel, buildXmlWriter);
        }
    }

    protected void writeServiceXml() throws Exception {
        if (this.codeGenConfiguration.isGenerateDeployementDescriptor()) {
            Document serviceXMLModel = this.createDOMDocumentForServiceXML();
            CServiceXMLWriter serviceXmlWriter = new CServiceXMLWriter(this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getResourceLocation()), this.codeGenConfiguration.getOutputLanguage());
            this.writeFile(serviceXMLModel, serviceXmlWriter);
        }
    }

    protected Document createDOMDocumentForInterfaceImplementation() throws Exception {
        String serviceName = this.axisService.getName();
        String serviceTns = this.axisService.getTargetNamespace();
        String serviceCName = this.makeCClassName(this.axisService.getName());
        String stubName = C_STUB_PREFIX + serviceCName + "";
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("class");
        this.addAttribute(doc, "name", stubName, rootElement);
        this.addAttribute(doc, "prefix", stubName, rootElement);
        this.addAttribute(doc, "qname", serviceName + "|" + serviceTns, rootElement);
        this.addAttribute(doc, "servicename", serviceCName, rootElement);
        this.addAttribute(doc, "package", "", rootElement);
        this.addAttribute(doc, "namespace", serviceTns, rootElement);
        this.addAttribute(doc, "interfaceName", serviceCName, rootElement);
        if (this.codeGenConfiguration.isPackClasses()) {
            this.addAttribute(doc, "wrapped", "yes", rootElement);
        }
        this.addSoapVersion(doc, rootElement);
        this.addEndpoint(doc, rootElement);
        this.fillSyncAttributes(doc, rootElement);
        if (this.mapper.isObjectMappingPresent()) {
            this.addAttribute(doc, "skip-write", "yes", rootElement);
            this.processModelObjects(this.mapper.getAllMappedObjects(), rootElement, doc);
        }
        this.loadOperations(doc, rootElement, null);
        rootElement.appendChild(this.createDOMElementforDatabinders(doc, false));
        Object stubMethods = this.codeGenConfiguration.getProperty("stubMethods");
        if (stubMethods != null) {
            rootElement.appendChild(doc.importNode((Element)stubMethods, true));
        }
        rootElement.appendChild(this.getUniqueListofFaults(doc));
        doc.appendChild(rootElement);
        return doc;
    }

    protected Document createDOMDocumentForSkeleton(boolean isSkeletonInterface) {
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("interface");
        String serviceCName = this.makeCClassName(this.axisService.getName());
        String skelName = C_SKEL_PREFIX + serviceCName + "";
        this.addAttribute(doc, "name", skelName, rootElement);
        this.addAttribute(doc, "package", "", rootElement);
        String serviceName = this.axisService.getName();
        String serviceTns = this.axisService.getTargetNamespace();
        this.addAttribute(doc, "prefix", skelName, rootElement);
        this.addAttribute(doc, "qname", serviceName + "|" + serviceTns, rootElement);
        this.fillSyncAttributes(doc, rootElement);
        this.loadOperations(doc, rootElement, null);
        rootElement.appendChild(this.getUniqueListofFaults(doc));
        doc.appendChild(rootElement);
        return doc;
    }

    protected Document createDOMDocumentForServiceSkeletonXML() {
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("interface");
        String localPart = this.makeCClassName(this.axisService.getName());
        String svcSkelName = C_SVC_SKEL_PREFIX + localPart + "";
        String skelName = C_SKEL_PREFIX + localPart + "";
        this.addAttribute(doc, "name", svcSkelName, rootElement);
        this.addAttribute(doc, "prefix", svcSkelName, rootElement);
        String serviceName = this.axisService.getName();
        String serviceTns = this.axisService.getTargetNamespace();
        this.addAttribute(doc, "qname", serviceName + "|" + serviceTns, rootElement);
        this.addAttribute(doc, "svcname", skelName, rootElement);
        this.addAttribute(doc, "svcop_prefix", skelName, rootElement);
        this.addAttribute(doc, "package", "", rootElement);
        this.fillSyncAttributes(doc, rootElement);
        this.loadOperations(doc, rootElement, null);
        this.addSoapVersion(doc, rootElement);
        rootElement.appendChild(this.getUniqueListofFaults(doc));
        doc.appendChild(rootElement);
        return doc;
    }

    protected Document createDOMDocumentForBuildScript(CodeGenConfiguration codegen) {
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("interface");
        String serviceCName = this.makeCClassName(this.axisService.getName());
        this.addAttribute(doc, "servicename", serviceCName, rootElement);
        if (codegen.isSetoutputSourceLocation()) {
            String outputLocation = codegen.getOutputLocation().getPath();
            String targetsourceLocation = codegen.getSourceLocation();
            this.addAttribute(doc, "option", "1", rootElement);
            this.addAttribute(doc, "outputlocation", outputLocation, rootElement);
            this.addAttribute(doc, "targetsourcelocation", targetsourceLocation, rootElement);
        } else {
            this.addAttribute(doc, "option", "0", rootElement);
        }
        this.fillSyncAttributes(doc, rootElement);
        this.loadOperations(doc, rootElement, null);
        this.addSoapVersion(doc, rootElement);
        rootElement.appendChild(this.getUniqueListofFaults(doc));
        doc.appendChild(rootElement);
        return doc;
    }

    protected String makeCClassName(String word) {
        if (CUtils.isCKeyword(word)) {
            return CUtils.makeNonCKeyword(word);
        }
        String outWord = word.replace('.', '_');
        return outWord.replace('-', '_');
    }

    protected boolean loadOperations(Document doc, Element rootElement, String mep) {
        String portTypeName = this.makeCClassName(this.axisService.getName());
        Iterator bindingOperations = this.axisBinding.getChildren();
        boolean opsFound = false;
        AxisOperation axisOperation = null;
        AxisBindingOperation axisBindingOperation = null;
        while (bindingOperations.hasNext()) {
            Element methodElement;
            ArrayList soapHeaderOutputParameterList;
            ArrayList soapHeaderInputParameterList;
            axisBindingOperation = (AxisBindingOperation)bindingOperations.next();
            axisOperation = axisBindingOperation.getAxisOperation();
            String messageExchangePattern = axisOperation.getMessageExchangePattern();
            if (this.infoHolder.get(messageExchangePattern) == null) {
                this.infoHolder.put(messageExchangePattern, Boolean.TRUE);
            }
            if (mep == null) {
                opsFound = true;
                soapHeaderInputParameterList = new ArrayList();
                soapHeaderOutputParameterList = new ArrayList();
                methodElement = doc.createElement("method");
                String localPart = axisOperation.getName().getLocalPart();
                String opCName = this.makeCClassName(localPart);
                String opNS = axisOperation.getName().getNamespaceURI();
                this.addAttribute(doc, "name", opCName, methodElement);
                this.addAttribute(doc, "localpart", localPart, methodElement);
                this.addAttribute(doc, "qname", localPart + "|" + opNS, methodElement);
                this.addAttribute(doc, "namespace", opNS, methodElement);
                String style = axisOperation.getStyle();
                this.addAttribute(doc, "style", style, methodElement);
                this.addAttribute(doc, "dbsupportname", portTypeName + localPart + "DatabindingSupporter", methodElement);
                this.addAttribute(doc, "mep", Utils.getAxisSpecifMEPConstant(axisOperation.getMessageExchangePattern()) + "", methodElement);
                this.addAttribute(doc, "mepURI", axisOperation.getMessageExchangePattern(), methodElement);
                this.addSOAPAction(doc, methodElement, axisBindingOperation.getName());
                this.addHeaderOperations(soapHeaderInputParameterList, axisBindingOperation, true);
                this.addHeaderOperations(soapHeaderOutputParameterList, axisBindingOperation, false);
                PolicyInclude policyInclude = axisOperation.getPolicyInclude();
                Policy policy = policyInclude.getPolicy();
                if (policy != null) {
                    try {
                        this.addAttribute(doc, "policy", PolicyUtil.policyComponentToString((PolicyComponent)policy), methodElement);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("can't serialize the policy to a String ", ex);
                    }
                }
                methodElement.appendChild(this.getInputElement(doc, axisBindingOperation, soapHeaderInputParameterList));
                methodElement.appendChild(this.getOutputElement(doc, axisBindingOperation, soapHeaderOutputParameterList));
                methodElement.appendChild(this.getFaultElement(doc, axisOperation));
                rootElement.appendChild(methodElement);
                continue;
            }
            if (!mep.equals(axisOperation.getMessageExchangePattern())) continue;
            opsFound = true;
            soapHeaderInputParameterList = new ArrayList();
            soapHeaderOutputParameterList = new ArrayList();
            ArrayList soapHeaderFaultParameterList = new ArrayList();
            methodElement = doc.createElement("method");
            String localPart = axisOperation.getName().getLocalPart();
            String opCName = this.makeCClassName(localPart);
            String opNS = axisOperation.getName().getNamespaceURI();
            this.addAttribute(doc, "name", opCName, methodElement);
            this.addAttribute(doc, "localpart", localPart, methodElement);
            this.addAttribute(doc, "qname", localPart + "|" + opNS, methodElement);
            this.addAttribute(doc, "namespace", axisOperation.getName().getNamespaceURI(), methodElement);
            this.addAttribute(doc, "style", axisOperation.getStyle(), methodElement);
            this.addAttribute(doc, "dbsupportname", portTypeName + localPart + "DatabindingSupporter", methodElement);
            this.addAttribute(doc, "mep", Utils.getAxisSpecifMEPConstant(axisOperation.getMessageExchangePattern()) + "", methodElement);
            this.addAttribute(doc, "mepURI", axisOperation.getMessageExchangePattern(), methodElement);
            this.addSOAPAction(doc, methodElement, axisBindingOperation.getName());
            this.addHeaderOperations(soapHeaderInputParameterList, axisBindingOperation, true);
            this.addHeaderOperations(soapHeaderOutputParameterList, axisBindingOperation, false);
            Policy policy = axisOperation.getPolicyInclude().getPolicy();
            if (policy != null) {
                try {
                    this.addAttribute(doc, "policy", PolicyUtil.policyComponentToString((PolicyComponent)policy), methodElement);
                }
                catch (Exception ex) {
                    throw new RuntimeException("can't serialize the policy to a String", ex);
                }
            }
            methodElement.appendChild(this.getInputElement(doc, axisBindingOperation, soapHeaderInputParameterList));
            methodElement.appendChild(this.getOutputElement(doc, axisBindingOperation, soapHeaderOutputParameterList));
            methodElement.appendChild(this.getFaultElement(doc, axisOperation));
            rootElement.appendChild(methodElement);
        }
        return opsFound;
    }

    protected Element generateParamComponent(Document doc, String paramName, String paramType, QName opName, String partName, boolean isPrimitive) {
        String typeMappingStr;
        Element paramElement = doc.createElement("param");
        this.addAttribute(doc, "name", paramName, paramElement);
        String string = typeMappingStr = paramType == null ? "" : paramType;
        if (JAVA_DEFAULT_TYPE.equals(typeMappingStr)) {
            typeMappingStr = C_DEFAULT_TYPE;
        }
        this.addAttribute(doc, "type", typeMappingStr, paramElement);
        this.addAttribute(doc, "caps-type", typeMappingStr.toUpperCase(), paramElement);
        this.addShortType(paramElement, paramType);
        if (this.mapper.getDefaultMappingName().equals(paramType)) {
            this.addAttribute(doc, "default", "yes", paramElement);
        }
        this.addAttribute(doc, "value", this.getParamInitializer(paramType), paramElement);
        this.addAttribute(doc, "location", "body", paramElement);
        if (opName != null) {
            this.addAttribute(doc, "opname", opName.getLocalPart(), paramElement);
        }
        if (partName != null) {
            this.addAttribute(doc, "partname", JavaUtils.capitalizeFirstChar(partName), paramElement);
        }
        if (isPrimitive) {
            this.addAttribute(doc, "primitive", "yes", paramElement);
        }
        boolean isOurs = true;
        if (typeMappingStr.length() != 0 && !typeMappingStr.equals("void") && !typeMappingStr.equals(C_DEFAULT_TYPE)) {
            this.addAttribute(doc, "ours", "yes", paramElement);
            isOurs = true;
        } else {
            isOurs = false;
        }
        if (isOurs) {
            typeMappingStr = C_OUR_TYPE_PREFIX + typeMappingStr + C_OUR_TYPE_SUFFIX;
        }
        this.addAttribute(doc, "axis2-type", typeMappingStr, paramElement);
        this.addAttribute(doc, "axis2-caps-type", typeMappingStr.toUpperCase(), paramElement);
        return paramElement;
    }

    protected void addCSpecifcAttributes(Document doc, AxisOperation operation, Element param, String messageType) {
        String type;
        AxisMessage message = messageType.equals("In") ? operation.getMessage("In") : operation.getMessage("Out");
        QName typeMapping = message.getElementQName();
        String paramType = this.mapper.getTypeMappingName(message.getElementQName());
        if (doc == null || paramType == null || param == null) {
            return;
        }
        String typeMappingStr = message != null ? ((type = this.mapper.getTypeMappingName(message.getElementQName())) == null ? "" : type) : "";
        this.addAttribute(doc, "caps-type", paramType.toUpperCase(), param);
        if (!(paramType.equals("") || paramType.equals("void") || paramType.equals(JAVA_DEFAULT_TYPE) || typeMappingStr.equals(C_DEFAULT_TYPE))) {
            this.addAttribute(doc, "ours", "yes", param);
        }
    }

    protected Element[] getInputParamElement(Document doc, AxisOperation operation) {
        Element[] param = super.getInputParamElement(doc, operation);
        for (int i = 0; i < param.length; ++i) {
            this.addCSpecifcAttributes(doc, operation, param[i], "In");
        }
        return param;
    }

    protected Element getOutputParamElement(Document doc, AxisOperation operation) {
        Element param = super.getOutputParamElement(doc, operation);
        this.addCSpecifcAttributes(doc, operation, param, "Out");
        return param;
    }

    protected File getOutputDirectory(File outputDir, String dir2) {
        if (dir2 != null && !"".equals(dir2) && outputDir.getName().equals(".")) {
            outputDir = new File(outputDir, dir2);
        }
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        return outputDir;
    }

    protected List getParameterElementList(Document doc, List parameters, String location) {
        ArrayList<Element> parameterElementList = new ArrayList<Element>();
        if (parameters != null && !parameters.isEmpty()) {
            int count = parameters.size();
            for (int i = 0; i < count; ++i) {
                Element param = doc.createElement("param");
                SOAPHeaderMessage header = (SOAPHeaderMessage)parameters.get(i);
                QName name = header.getElement();
                this.addAttribute(doc, "name", this.mapper.getParameterName(name), param);
                String typeMapping = this.mapper.getTypeMappingName(name);
                String typeMappingStr = typeMapping == null ? "" : typeMapping;
                this.addAttribute(doc, "type", typeMappingStr, param);
                this.addAttribute(doc, "location", location, param);
                if (header.isMustUnderstand()) {
                    this.addAttribute(doc, "mustUnderstand", "true", param);
                }
                if (name != null) {
                    Element qNameElement = doc.createElement("qname");
                    this.addAttribute(doc, "nsuri", name.getNamespaceURI(), qNameElement);
                    this.addAttribute(doc, "localname", name.getLocalPart(), qNameElement);
                    param.appendChild(qNameElement);
                }
                parameterElementList.add(param);
                boolean isOurs = true;
                if (typeMappingStr.length() != 0 && !typeMappingStr.equals("void") && !typeMappingStr.equals(C_DEFAULT_TYPE)) {
                    this.addAttribute(doc, "ours", "yes", param);
                    isOurs = true;
                } else {
                    isOurs = false;
                }
                if (isOurs) {
                    typeMappingStr = C_OUR_TYPE_PREFIX + typeMappingStr + C_OUR_TYPE_SUFFIX;
                }
                this.addAttribute(doc, "axis2-type", typeMappingStr, param);
            }
        }
        return parameterElementList;
    }

    protected Element getOutputElement(Document doc, AxisBindingOperation bindingOperation, List headerParameterQNameList) {
        AxisOperation operation = bindingOperation.getAxisOperation();
        Element outputElt = doc.createElement("output");
        String mep = operation.getMessageExchangePattern();
        if (WSDLUtil.isOutputPresentForMEP(mep)) {
            Element param = this.getOutputParamElement(doc, operation);
            if (param != null) {
                outputElt.appendChild(param);
            }
            List outputElementList = this.getParameterElementList(doc, headerParameterQNameList, "soap_header");
            outputElementList.addAll(this.getParameterElementListForHttpHeader(doc, (ArrayList)this.getBindingPropertyFromMessage("whttp:header", operation.getName(), "out"), "http_header"));
            for (int i = 0; i < outputElementList.size(); ++i) {
                outputElt.appendChild((Element)outputElementList.get(i));
            }
            Policy policy = this.getBindingPolicyFromMessage(bindingOperation, "out");
            if (policy != null) {
                try {
                    this.addAttribute(doc, "policy", PolicyUtil.getSafeString(PolicyUtil.policyComponentToString((PolicyComponent)policy)), outputElt);
                }
                catch (Exception ex) {
                    throw new RuntimeException("can't serialize the policy ..");
                }
            }
        }
        return outputElt;
    }

    protected Element getInputElement(Document doc, AxisBindingOperation bindingOperation, List headerParameterQNameList) {
        AxisOperation operation = bindingOperation.getAxisOperation();
        Element inputElt = doc.createElement("input");
        String mep = operation.getMessageExchangePattern();
        if (WSDLUtil.isInputPresentForMEP(mep)) {
            Element[] param = this.getInputParamElement(doc, operation);
            for (int i = 0; i < param.length; ++i) {
                inputElt.appendChild(param[i]);
            }
            List parameterElementList = this.getParameterElementList(doc, headerParameterQNameList, "soap_header");
            parameterElementList.addAll(this.getParameterElementListForHttpHeader(doc, (ArrayList)this.getBindingPropertyFromMessage("whttp:header", operation.getName(), "in"), "http_header"));
            parameterElementList.addAll(this.getParameterElementListForSOAPModules(doc, (ArrayList)this.getBindingPropertyFromMessage("wsoap:module", operation.getName(), "in")));
            for (int i = 0; i < parameterElementList.size(); ++i) {
                inputElt.appendChild((Element)parameterElementList.get(i));
            }
            Policy policy = this.getBindingPolicyFromMessage(bindingOperation, "in");
            if (policy != null) {
                try {
                    this.addAttribute(doc, "policy", PolicyUtil.getSafeString(PolicyUtil.policyComponentToString((PolicyComponent)policy)), inputElt);
                }
                catch (Exception ex) {
                    throw new RuntimeException("can't serialize the policy ..");
                }
            }
        }
        return inputElt;
    }
}

