/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.activation.DataSource;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.attachments.CachedFileDataSource;
import org.apache.axiom.attachments.lifecycle.LifecycleManager;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.util.DetachableInputStream;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPModelBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.MessageProcessorSelector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransportUtils {
    private static final Log log = LogFactory.getLog(TransportUtils.class);

    public static SOAPEnvelope createSOAPMessage(MessageContext msgContext) throws AxisFault {
        return TransportUtils.createSOAPMessage(msgContext, false);
    }

    public static SOAPEnvelope createSOAPMessage(MessageContext msgContext, boolean detach) throws AxisFault {
        try {
            DetachableInputStream dis;
            InputStream inStream = (InputStream)msgContext.getProperty("TRANSPORT_IN");
            msgContext.setProperty("TRANSPORT_IN", null);
            if (inStream == null) {
                throw new AxisFault(Messages.getMessage("inputstreamNull"));
            }
            String contentType = (String)msgContext.getProperty("ContentType");
            String charSetEnc = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
            if (charSetEnc == null && contentType != null) {
                charSetEnc = BuilderUtil.getCharSetEncoding(contentType);
            } else if (charSetEnc == null) {
                charSetEnc = "UTF-8";
            }
            msgContext.setProperty("CHARACTER_SET_ENCODING", charSetEnc);
            SOAPEnvelope env = TransportUtils.createSOAPMessage(msgContext, inStream, contentType);
            if (detach && (dis = (DetachableInputStream)msgContext.getProperty("org.apache.axiom.om.util.DetachableInputStream")) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Detaching input stream after SOAPEnvelope construction");
                }
                dis.detach();
            }
            return env;
        }
        catch (Exception e) {
            throw AxisFault.makeFault(e);
        }
    }

    public static SOAPEnvelope createSOAPMessage(MessageContext msgContext, InputStream inStream, String contentType) throws AxisFault, OMException, XMLStreamException, FactoryConfigurationError {
        OMElement documentElement = TransportUtils.createDocumentElement(contentType, msgContext, inStream);
        return TransportUtils.createSOAPEnvelope(documentElement);
    }

    public static SOAPEnvelope createSOAPMessage(MessageContext msgContext, InputStream inStream, String contentType, Builder builder) throws AxisFault, OMException, XMLStreamException, FactoryConfigurationError {
        OMElement documentElement = TransportUtils.createDocumentElement(contentType, builder, msgContext, inStream);
        return TransportUtils.createSOAPEnvelope(documentElement);
    }

    public static SOAPEnvelope createSOAPEnvelope(OMElement documentElement) {
        SOAPEnvelope envelope;
        if (documentElement instanceof SOAPEnvelope) {
            envelope = (SOAPEnvelope)documentElement;
        } else {
            SOAPFactory soapFactory = OMAbstractFactory.getSOAP11Factory();
            envelope = soapFactory.getDefaultEnvelope();
            if (documentElement != null) {
                envelope.getBody().addChild((OMNode)documentElement);
            }
        }
        return envelope;
    }

    public static OMElement createDocumentElement(String contentType, MessageContext msgContext, InputStream inStream) throws AxisFault, XMLStreamException {
        Builder builder;
        OMElement documentElement = null;
        String type = null;
        if (contentType != null && (builder = MessageProcessorSelector.getMessageBuilder(type = TransportUtils.getContentType(contentType, msgContext), msgContext)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("createSOAPEnvelope using Builder (" + builder.getClass() + ") selected from type (" + type + ")"));
            }
            documentElement = builder.processDocument(inStream, contentType, msgContext);
        }
        if (documentElement == null) {
            documentElement = TransportUtils.createDefaultDocumentElement(msgContext, inStream, type);
        }
        return documentElement;
    }

    private static OMElement createDefaultDocumentElement(MessageContext msgContext, InputStream inStream, String type) {
        OMElement documentElement;
        if (msgContext.isDoingREST()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Could not find a Builder for type (" + type + ").  Using REST."));
            }
            OMXMLParserWrapper builder = BuilderUtil.createPOXBuilder(inStream, null);
            documentElement = builder.getDocumentElement();
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Could not find a Builder for type (" + type + ").  Using SOAP."));
            }
            String charSetEnc = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
            SOAPModelBuilder builder = BuilderUtil.createSOAPModelBuilder(inStream, charSetEnc);
            documentElement = builder.getDocumentElement();
        }
        return documentElement;
    }

    public static OMElement createDocumentElement(String contentType, Builder builder, MessageContext msgContext, InputStream inStream) throws AxisFault, XMLStreamException {
        OMElement documentElement = null;
        String type = null;
        if (contentType != null) {
            type = TransportUtils.getContentType(contentType, msgContext);
            if (builder != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("createSOAPEnvelope using Builder (" + builder.getClass() + ") selected from type (" + type + ")"));
                }
                documentElement = builder.processDocument(inStream, contentType, msgContext);
            }
        }
        if (documentElement == null) {
            documentElement = TransportUtils.createDefaultDocumentElement(msgContext, inStream, type);
        }
        return documentElement;
    }

    public static String getContentType(String contentType, MessageContext msgContext) {
        int index = contentType.indexOf(59);
        String type = index > 0 ? contentType.substring(0, index) : contentType;
        if (msgContext.isDoingREST() && "text/xml".equals(type)) {
            if (msgContext.isServerSide()) {
                if (msgContext.getSoapAction() == null) {
                    // empty if block
                }
            } else if (!msgContext.isPropertyTrue("soapResponseMEP")) {
                type = "application/xml";
            }
        }
        return type;
    }

    public static String getCharSetEncoding(String contentType) {
        int index;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Input contentType (" + contentType + ")"));
        }
        if ((index = contentType.indexOf(HTTPConstants.CHAR_SET_ENCODING)) == -1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"CharSetEncoding defaulted (UTF-8)");
            }
            return "UTF-8";
        }
        int indexOfEq = contentType.indexOf("=", index);
        int indexOfSemiColon = contentType.indexOf(";", indexOfEq);
        String value = indexOfSemiColon > 0 ? contentType.substring(indexOfEq + 1, indexOfSemiColon) : contentType.substring(indexOfEq + 1, contentType.length()).trim();
        if (value.indexOf(34) != -1) {
            value = value.replaceAll("\"", "");
        }
        value = value.trim();
        if (log.isDebugEnabled()) {
            log.debug((Object)("CharSetEncoding from content-type (" + value + ")"));
        }
        return value;
    }

    public static void writeMessage(MessageContext msgContext, OutputStream out) throws AxisFault {
        SOAPEnvelope envelope;
        SOAPEnvelope outputMessage = envelope = msgContext.getEnvelope();
        if (envelope != null && msgContext.isDoingREST()) {
            outputMessage = envelope.getBody().getFirstElement();
        }
        if (outputMessage != null) {
            try {
                OMOutputFormat format = new OMOutputFormat();
                String charSetEnc = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
                format.setDoOptimize(false);
                format.setDoingSWA(false);
                format.setCharSetEncoding(charSetEnc);
                outputMessage.serializeAndConsume(out, format);
                out.flush();
            }
            catch (Exception e) {
                throw AxisFault.makeFault(e);
            }
        } else {
            throw new AxisFault(Messages.getMessage("outMessageNull"));
        }
    }

    private static String getSOAPNamespaceFromContentType(String contentType, String defaultSOAPNamespace) {
        String returnNS = defaultSOAPNamespace;
        if (contentType != null) {
            if (JavaUtils.indexOfIgnoreCase(contentType, "application/soap+xml") > -1) {
                returnNS = "http://www.w3.org/2003/05/soap-envelope";
            } else if (JavaUtils.indexOfIgnoreCase(contentType, "text/xml") > -1) {
                returnNS = "http://schemas.xmlsoap.org/soap/envelope/";
            }
        }
        if (returnNS == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No content-type or \"type=\" parameter was found in the content-type header and no default was specified, thus defaulting to SOAP 1.1.");
            }
            returnNS = "http://schemas.xmlsoap.org/soap/envelope/";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("content-type: " + contentType));
            log.debug((Object)("defaultSOAPNamespace: " + defaultSOAPNamespace));
            log.debug((Object)("Returned namespace: " + returnNS));
        }
        return returnNS;
    }

    public static void processContentTypeForAction(String contentType, MessageContext msgContext) {
        int index = contentType.indexOf("action");
        if (index > -1) {
            String transientString = contentType.substring(index, contentType.length());
            int equal = transientString.indexOf("=");
            int firstSemiColon = transientString.indexOf(";");
            String soapAction = firstSemiColon > -1 ? transientString.substring(equal + 1, firstSemiColon) : transientString.substring(equal + 1, transientString.length());
            if (soapAction != null && soapAction.startsWith("\"") && soapAction.endsWith("\"")) {
                soapAction = soapAction.substring(1, soapAction.length() - 1);
            }
            msgContext.setSoapAction(soapAction);
        }
    }

    public static boolean isResponseWritten(MessageContext messageContext) {
        RequestResponseTransport reqResTransport = TransportUtils.getRequestResponseTransport(messageContext);
        if (reqResTransport != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Found RequestResponseTransport returning isResponseWritten()");
            }
            return reqResTransport.isResponseWritten();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Did not find RequestResponseTransport returning false from getResponseWritten()");
        }
        return false;
    }

    public static void setResponseWritten(MessageContext messageContext, boolean responseWritten) {
        RequestResponseTransport reqResTransport = TransportUtils.getRequestResponseTransport(messageContext);
        if (reqResTransport != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Found RequestResponseTransport setting response written");
            }
            reqResTransport.setResponseWritten(responseWritten);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Did not find RequestResponseTransport cannot set response written");
        }
    }

    private static RequestResponseTransport getRequestResponseTransport(MessageContext messageContext) {
        try {
            RequestResponseTransport transportControl = (RequestResponseTransport)messageContext.getProperty("RequestResponseTransportControl");
            if (transportControl != null) {
                return transportControl;
            }
            if (messageContext.getOperationContext() != null && messageContext.getOperationContext().getMessageContext("In") != null) {
                return (RequestResponseTransport)messageContext.getOperationContext().getMessageContext("In").getProperty("RequestResponseTransportControl");
            }
            return null;
        }
        catch (AxisFault af) {
            String msg = Messages.getMessage("getMessageContextError", af.toString());
            log.debug((Object)msg);
            return null;
        }
    }

    public static void deleteAttachments(MessageContext msgContext) {
        List keys;
        Attachments attachments;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering deleteAttachments()");
        }
        if ((attachments = msgContext.getAttachmentMap()) != null && (keys = attachments.getContentIDList()) != null && keys.size() > 0) {
            String key = null;
            File file = null;
            LifecycleManager lcm = (LifecycleManager)msgContext.getRootContext().getAxisConfiguration().getParameterValue("attachmentsLifecycleManager");
            DataSource dataSource = null;
            for (int i = 0; i < keys.size(); ++i) {
                try {
                    key = (String)keys.get(i);
                    dataSource = attachments.getDataHandler(key).getDataSource();
                    if (!(dataSource instanceof CachedFileDataSource)) continue;
                    file = ((CachedFileDataSource)dataSource).getFile();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Delete cache attachment file: " + file.getName()));
                    }
                    if (lcm != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"deleting file using lifecyclemanager");
                        }
                        lcm.delete(file);
                        continue;
                    }
                    file.delete();
                    continue;
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Delete cache attachment file failed" + e.getMessage()));
                    }
                    if (file == null) continue;
                    if (lcm != null) {
                        try {
                            lcm.deleteOnExit(file);
                        }
                        catch (Exception ex) {
                            file.deleteOnExit();
                        }
                        continue;
                    }
                    file.deleteOnExit();
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exiting deleteAttachments()");
        }
    }

    public static void detachInputStream(MessageContext msgContext) throws AxisFault {
        try {
            if (msgContext != null && msgContext.getProperty("org.apache.axiom.om.util.DetachableInputStream") != null) {
                DetachableInputStream dis = (DetachableInputStream)msgContext.getProperty("org.apache.axiom.om.util.DetachableInputStream");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Detaching DetachableInputStream: " + dis));
                }
                dis.detach();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Detach not performed for MessageContext: " + msgContext));
            }
        }
        catch (Throwable t) {
            throw AxisFault.makeFault(t);
        }
    }

    public static boolean doWriteMTOM(MessageContext msgContext) {
        boolean enableMTOM;
        Object property;
        Object enableMTOMObject = null;
        Parameter parameter = msgContext.getParameter("enableMTOM");
        if (parameter != null) {
            enableMTOMObject = parameter.getValue();
        }
        if ((property = msgContext.getProperty("enableMTOM")) != null) {
            enableMTOMObject = property;
        }
        if (!(enableMTOM = JavaUtils.isTrueExplicitly(enableMTOMObject)) && msgContext.isDoingMTOM() && enableMTOMObject instanceof String && ((String)enableMTOMObject).equalsIgnoreCase("optional")) {
            if (msgContext.isServerSide()) {
                if (msgContext.isDoingMTOM()) {
                    enableMTOM = true;
                }
            } else {
                enableMTOM = true;
            }
        }
        return enableMTOM;
    }

    public static boolean doWriteSwA(MessageContext msgContext) {
        boolean enableSwA;
        Object property;
        Object enableSwAObject = null;
        Parameter parameter = msgContext.getParameter("enableSwA");
        if (parameter != null) {
            enableSwAObject = parameter.getValue();
        }
        if ((property = msgContext.getProperty("enableSwA")) != null) {
            enableSwAObject = property;
        }
        if (!(enableSwA = JavaUtils.isTrueExplicitly(enableSwAObject)) && msgContext.isDoingSwA() && enableSwAObject instanceof String && ((String)enableSwAObject).equalsIgnoreCase("optional")) {
            enableSwA = true;
        }
        return enableSwA;
    }

    public static boolean isDoingREST(MessageContext msgContext) {
        boolean enableREST = false;
        if (msgContext.isDoingREST()) {
            return true;
        }
        Object enableRESTProperty = msgContext.getProperty("enableREST");
        if (enableRESTProperty != null) {
            enableREST = JavaUtils.isTrueExplicitly(enableRESTProperty);
        }
        msgContext.setDoingREST(enableREST);
        return enableREST;
    }

    public static String getCharSetEncoding(MessageContext msgContext) {
        String charSetEnc = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
        if (charSetEnc == null) {
            OperationContext opctx = msgContext.getOperationContext();
            if (opctx != null) {
                charSetEnc = (String)opctx.getProperty("CHARACTER_SET_ENCODING");
            }
            if (charSetEnc == null) {
                charSetEnc = "UTF-8";
            }
        }
        return charSetEnc;
    }
}

