/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.beans.factory.annotation;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.dubbo.config.AbstractInterfaceConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.spring.util.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.util.Assert;

public abstract class AnnotatedInterfaceConfigBeanBuilder<C extends AbstractInterfaceConfig> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final AnnotationAttributes attributes;
    protected final ApplicationContext applicationContext;
    protected final ClassLoader classLoader;
    protected Object configBean;
    protected Class<?> interfaceClass;

    protected AnnotatedInterfaceConfigBeanBuilder(AnnotationAttributes attributes, ApplicationContext applicationContext) {
        Assert.notNull((Object)attributes, (String)"The Annotation attributes must not be null!");
        Assert.notNull((Object)applicationContext, (String)"The ApplicationContext must not be null!");
        this.attributes = attributes;
        this.applicationContext = applicationContext;
        this.classLoader = applicationContext.getClassLoader() != null ? applicationContext.getClassLoader() : Thread.currentThread().getContextClassLoader();
    }

    public final C build() throws Exception {
        this.checkDependencies();
        C configBean = this.doBuild();
        this.configureBean(configBean);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("The configBean[type:" + configBean.getClass().getSimpleName() + "] has been built."));
        }
        return configBean;
    }

    private void checkDependencies() {
    }

    protected abstract C doBuild();

    protected void configureBean(C configBean) throws Exception {
        this.preConfigureBean(this.attributes, configBean);
        this.configureRegistryConfigs(configBean);
        this.configureMonitorConfig(configBean);
        this.configureApplicationConfig(configBean);
        this.configureModuleConfig(configBean);
        this.postConfigureBean(this.attributes, configBean);
    }

    protected abstract void preConfigureBean(AnnotationAttributes var1, C var2) throws Exception;

    private void configureRegistryConfigs(C configBean) {
        String[] registryConfigBeanIds = this.resolveRegistryConfigBeanNames(this.attributes);
        List<RegistryConfig> registryConfigs = BeanFactoryUtils.getBeans((ListableBeanFactory)this.applicationContext, registryConfigBeanIds, RegistryConfig.class);
        ((AbstractInterfaceConfig)configBean).setRegistries(registryConfigs);
    }

    private void configureMonitorConfig(C configBean) {
        String monitorBeanName = this.resolveMonitorConfigBeanName(this.attributes);
        MonitorConfig monitorConfig = BeanFactoryUtils.getOptionalBean((ListableBeanFactory)this.applicationContext, monitorBeanName, MonitorConfig.class);
        ((AbstractInterfaceConfig)configBean).setMonitor(monitorConfig);
    }

    private void configureApplicationConfig(C configBean) {
        String applicationConfigBeanName = this.resolveApplicationConfigBeanName(this.attributes);
        ApplicationConfig applicationConfig = BeanFactoryUtils.getOptionalBean((ListableBeanFactory)this.applicationContext, applicationConfigBeanName, ApplicationConfig.class);
        ((AbstractInterfaceConfig)configBean).setApplication(applicationConfig);
    }

    private void configureModuleConfig(C configBean) {
        String moduleConfigBeanName = this.resolveModuleConfigBeanName(this.attributes);
        ModuleConfig moduleConfig = BeanFactoryUtils.getOptionalBean((ListableBeanFactory)this.applicationContext, moduleConfigBeanName, ModuleConfig.class);
        ((AbstractInterfaceConfig)configBean).setModule(moduleConfig);
    }

    protected abstract String resolveModuleConfigBeanName(AnnotationAttributes var1);

    protected abstract String resolveApplicationConfigBeanName(AnnotationAttributes var1);

    protected abstract String[] resolveRegistryConfigBeanNames(AnnotationAttributes var1);

    protected abstract String resolveMonitorConfigBeanName(AnnotationAttributes var1);

    protected abstract void postConfigureBean(AnnotationAttributes var1, C var2) throws Exception;

    public <T extends AnnotatedInterfaceConfigBeanBuilder<C>> T configBean(Object configBean) {
        this.configBean = configBean;
        return (T)this;
    }

    public <T extends AnnotatedInterfaceConfigBeanBuilder<C>> T interfaceClass(Class<?> interfaceClass) {
        this.interfaceClass = interfaceClass;
        return (T)this;
    }
}

