/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.store.redis;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.metadata.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.support.AbstractMetadataReport;
import org.apache.dubbo.rpc.RpcException;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisMetadataReport
extends AbstractMetadataReport {
    private static final Logger logger = LoggerFactory.getLogger(RedisMetadataReport.class);
    JedisPool pool;
    Set<HostAndPort> jedisClusterNodes;
    private int timeout;
    private String password;

    public RedisMetadataReport(URL url) {
        super(url);
        this.timeout = url.getParameter("timeout", 1000);
        if (url.getParameter("cluster", false)) {
            this.jedisClusterNodes = new HashSet<HostAndPort>();
            List<URL> urls = url.getBackupUrls();
            for (URL tmpUrl : urls) {
                this.jedisClusterNodes.add(new HostAndPort(tmpUrl.getHost(), tmpUrl.getPort()));
            }
        } else {
            this.pool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), url.getHost(), url.getPort(), this.timeout, url.getPassword());
        }
    }

    @Override
    protected void doStoreProviderMetadata(MetadataIdentifier providerMetadataIdentifier, String serviceDefinitions) {
        this.storeMetadata(providerMetadataIdentifier, serviceDefinitions);
    }

    @Override
    protected void doStoreConsumerMetadata(MetadataIdentifier consumerMetadataIdentifier, String value) {
        this.storeMetadata(consumerMetadataIdentifier, value);
    }

    private void storeMetadata(MetadataIdentifier metadataIdentifier, String v) {
        if (this.pool != null) {
            this.storeMetadataStandalone(metadataIdentifier, v);
        } else {
            this.storeMetadataInCluster(metadataIdentifier, v);
        }
    }

    private void storeMetadataInCluster(MetadataIdentifier metadataIdentifier, String v) {
        try (JedisCluster jedisCluster = new JedisCluster(this.jedisClusterNodes, this.timeout, this.timeout, 2, this.password, new GenericObjectPoolConfig());){
            jedisCluster.set(metadataIdentifier.getIdentifierKey() + ".metaData", v);
        }
        catch (Throwable e) {
            logger.error("Failed to put " + metadataIdentifier + " to redis cluster " + v + ", cause: " + e.getMessage(), e);
            throw new RpcException("Failed to put " + metadataIdentifier + " to redis cluster " + v + ", cause: " + e.getMessage(), e);
        }
    }

    private void storeMetadataStandalone(MetadataIdentifier metadataIdentifier, String v) {
        try (Jedis jedis = this.pool.getResource();){
            jedis.set(metadataIdentifier.getUniqueKey(MetadataIdentifier.KeyTypeEnum.UNIQUE_KEY), v);
        }
        catch (Throwable e) {
            logger.error("Failed to put " + metadataIdentifier + " to redis " + v + ", cause: " + e.getMessage(), e);
            throw new RpcException("Failed to put " + metadataIdentifier + " to redis " + v + ", cause: " + e.getMessage(), e);
        }
    }
}

