/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.ListenableFilter;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcStatus;

@Activate(group={"consumer"}, value={"actives"})
public class ActiveLimitFilter
extends ListenableFilter {
    private static final String ACTIVELIMIT_FILTER_START_TIME = "activelimit_filter_start_time";

    public ActiveLimitFilter() {
        this.listener = new ActiveLimitListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        URL url = invoker.getUrl();
        String methodName = invocation.getMethodName();
        int max = invoker.getUrl().getMethodParameter(methodName, "actives", 0);
        RpcStatus rpcStatus = RpcStatus.getStatus(invoker.getUrl(), invocation.getMethodName());
        if (!RpcStatus.beginCount(url, methodName, max)) {
            long timeout = invoker.getUrl().getMethodParameter(invocation.getMethodName(), "timeout", 0);
            long start = System.currentTimeMillis();
            long remain = timeout;
            RpcStatus rpcStatus2 = rpcStatus;
            synchronized (rpcStatus2) {
                while (!RpcStatus.beginCount(url, methodName, max)) {
                    long elapsed;
                    try {
                        rpcStatus.wait(remain);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if ((remain = timeout - (elapsed = System.currentTimeMillis() - start)) > 0L) continue;
                    throw new RpcException(7, "Waiting concurrent invoke timeout in client-side for service:  " + invoker.getInterface().getName() + ", method: " + invocation.getMethodName() + ", elapsed: " + elapsed + ", timeout: " + timeout + ". concurrent invokes: " + rpcStatus.getActive() + ". max concurrent invoke limit: " + max);
                }
            }
        }
        invocation.setAttachment(ACTIVELIMIT_FILTER_START_TIME, String.valueOf(System.currentTimeMillis()));
        return invoker.invoke(invocation);
    }

    static class ActiveLimitListener
    implements Filter.Listener {
        ActiveLimitListener() {
        }

        @Override
        public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
            String methodName = invocation.getMethodName();
            URL url = invoker.getUrl();
            int max = invoker.getUrl().getMethodParameter(methodName, "actives", 0);
            RpcStatus.endCount(url, methodName, this.getElapsed(invocation), true);
            this.notifyFinish(RpcStatus.getStatus(url, methodName), max);
        }

        @Override
        public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
            RpcException rpcException;
            String methodName = invocation.getMethodName();
            URL url = invoker.getUrl();
            int max = invoker.getUrl().getMethodParameter(methodName, "actives", 0);
            if (t instanceof RpcException && (rpcException = (RpcException)t).isLimitExceed()) {
                return;
            }
            RpcStatus.endCount(url, methodName, this.getElapsed(invocation), false);
            this.notifyFinish(RpcStatus.getStatus(url, methodName), max);
        }

        private long getElapsed(Invocation invocation) {
            String beginTime = invocation.getAttachment(ActiveLimitFilter.ACTIVELIMIT_FILTER_START_TIME);
            return StringUtils.isNotEmpty(beginTime) ? System.currentTimeMillis() - Long.parseLong(beginTime) : 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyFinish(RpcStatus rpcStatus, int max) {
            if (max > 0) {
                RpcStatus rpcStatus2 = rpcStatus;
                synchronized (rpcStatus2) {
                    rpcStatus.notifyAll();
                }
            }
        }
    }
}

