/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.config.CompositeConfiguration;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.EnvironmentConfiguration;
import org.apache.dubbo.common.config.InmemoryConfiguration;
import org.apache.dubbo.common.config.PrefixedConfiguration;
import org.apache.dubbo.common.config.PropertiesConfiguration;
import org.apache.dubbo.common.config.SystemConfiguration;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.context.ApplicationExt;
import org.apache.dubbo.common.context.LifecycleAdapter;
import org.apache.dubbo.common.extension.DisableInject;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.context.ConfigConfigurationAdapter;
import org.apache.dubbo.rpc.model.ScopeModel;

public class Environment
extends LifecycleAdapter
implements ApplicationExt {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(Environment.class);
    public static final String NAME = "environment";
    private PropertiesConfiguration propertiesConfiguration;
    private SystemConfiguration systemConfiguration;
    private EnvironmentConfiguration environmentConfiguration;
    private InmemoryConfiguration externalConfiguration;
    private InmemoryConfiguration appExternalConfiguration;
    private InmemoryConfiguration appConfiguration;
    protected CompositeConfiguration globalConfiguration;
    protected List<Map<String, String>> globalConfigurationMaps;
    private CompositeConfiguration defaultDynamicGlobalConfiguration;
    private DynamicConfiguration defaultDynamicConfiguration;
    private String localMigrationRule;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private ScopeModel scopeModel;

    public Environment(ScopeModel scopeModel) {
        this.scopeModel = scopeModel;
    }

    @Override
    public void initialize() throws IllegalStateException {
        if (this.initialized.compareAndSet(false, true)) {
            this.propertiesConfiguration = new PropertiesConfiguration(this.scopeModel);
            this.systemConfiguration = new SystemConfiguration();
            this.environmentConfiguration = new EnvironmentConfiguration();
            this.externalConfiguration = new InmemoryConfiguration("ExternalConfig");
            this.appExternalConfiguration = new InmemoryConfiguration("AppExternalConfig");
            this.appConfiguration = new InmemoryConfiguration("AppConfig");
            this.loadMigrationRule();
        }
    }

    @Deprecated
    private void loadMigrationRule() {
        if (Boolean.parseBoolean(System.getProperty("dubbo.migration-file.enable", "false"))) {
            String path = System.getProperty("dubbo.migration.file");
            if (StringUtils.isEmpty(path) && StringUtils.isEmpty(path = System.getenv("dubbo.migration.file"))) {
                path = "dubbo-migration.yaml";
            }
            this.localMigrationRule = ConfigUtils.loadMigrationRule(this.scopeModel.getClassLoaders(), path);
        } else {
            this.localMigrationRule = null;
        }
    }

    @Deprecated
    @DisableInject
    public void setLocalMigrationRule(String localMigrationRule) {
        this.localMigrationRule = localMigrationRule;
    }

    @DisableInject
    public void setExternalConfigMap(Map<String, String> externalConfiguration) {
        if (externalConfiguration != null) {
            this.externalConfiguration.setProperties(externalConfiguration);
        }
    }

    @DisableInject
    public void setAppExternalConfigMap(Map<String, String> appExternalConfiguration) {
        if (appExternalConfiguration != null) {
            this.appExternalConfiguration.setProperties(appExternalConfiguration);
        }
    }

    @DisableInject
    public void setAppConfigMap(Map<String, String> appConfiguration) {
        if (appConfiguration != null) {
            this.appConfiguration.setProperties(appConfiguration);
        }
    }

    public Map<String, String> getExternalConfigMap() {
        return this.externalConfiguration.getProperties();
    }

    public Map<String, String> getAppExternalConfigMap() {
        return this.appExternalConfiguration.getProperties();
    }

    public Map<String, String> getAppConfigMap() {
        return this.appConfiguration.getProperties();
    }

    public void updateExternalConfigMap(Map<String, String> externalMap) {
        this.externalConfiguration.addProperties(externalMap);
    }

    public void updateAppExternalConfigMap(Map<String, String> externalMap) {
        this.appExternalConfiguration.addProperties(externalMap);
    }

    public void updateAppConfigMap(Map<String, String> map) {
        this.appConfiguration.addProperties(map);
    }

    public Configuration getPrefixedConfiguration(AbstractConfig config, String prefix) {
        ConfigConfigurationAdapter instanceConfiguration = new ConfigConfigurationAdapter(config, prefix);
        CompositeConfiguration compositeConfiguration = new CompositeConfiguration();
        compositeConfiguration.addConfiguration(this.systemConfiguration);
        compositeConfiguration.addConfiguration(this.environmentConfiguration);
        compositeConfiguration.addConfiguration(this.appExternalConfiguration);
        compositeConfiguration.addConfiguration(this.externalConfiguration);
        compositeConfiguration.addConfiguration(this.appConfiguration);
        compositeConfiguration.addConfiguration(instanceConfiguration);
        compositeConfiguration.addConfiguration(this.propertiesConfiguration);
        return new PrefixedConfiguration(compositeConfiguration, prefix);
    }

    public CompositeConfiguration getConfiguration() {
        if (this.globalConfiguration == null) {
            CompositeConfiguration configuration = new CompositeConfiguration();
            configuration.addConfiguration(this.systemConfiguration);
            configuration.addConfiguration(this.environmentConfiguration);
            configuration.addConfiguration(this.appExternalConfiguration);
            configuration.addConfiguration(this.externalConfiguration);
            configuration.addConfiguration(this.appConfiguration);
            configuration.addConfiguration(this.propertiesConfiguration);
            this.globalConfiguration = configuration;
        }
        return this.globalConfiguration;
    }

    public List<Map<String, String>> getConfigurationMaps(AbstractConfig config, String prefix) {
        ArrayList<Map<String, String>> maps = new ArrayList<Map<String, String>>();
        maps.add(this.systemConfiguration.getProperties());
        maps.add(this.environmentConfiguration.getProperties());
        maps.add(this.appExternalConfiguration.getProperties());
        maps.add(this.externalConfiguration.getProperties());
        maps.add(this.appConfiguration.getProperties());
        if (config != null) {
            ConfigConfigurationAdapter configurationAdapter = new ConfigConfigurationAdapter(config, prefix);
            maps.add(configurationAdapter.getProperties());
        }
        maps.add(this.propertiesConfiguration.getProperties());
        return maps;
    }

    public List<Map<String, String>> getConfigurationMaps() {
        if (this.globalConfigurationMaps == null) {
            this.globalConfigurationMaps = this.getConfigurationMaps(null, null);
        }
        return this.globalConfigurationMaps;
    }

    @Override
    public void destroy() throws IllegalStateException {
        this.initialized.set(false);
        this.systemConfiguration = null;
        this.propertiesConfiguration = null;
        this.environmentConfiguration = null;
        this.externalConfiguration = null;
        this.appExternalConfiguration = null;
        this.appConfiguration = null;
        this.globalConfiguration = null;
        this.globalConfigurationMaps = null;
        this.defaultDynamicGlobalConfiguration = null;
        if (this.defaultDynamicConfiguration != null) {
            try {
                this.defaultDynamicConfiguration.close();
            }
            catch (Exception e) {
                logger.warn("0-12", "", "", "close dynamic configuration failed: " + e.getMessage(), e);
            }
            this.defaultDynamicConfiguration = null;
        }
    }

    public void reset() {
        this.destroy();
        this.initialize();
    }

    public String resolvePlaceholders(String str) {
        return ConfigUtils.replaceProperty(str, this.getConfiguration());
    }

    public PropertiesConfiguration getPropertiesConfiguration() {
        return this.propertiesConfiguration;
    }

    public SystemConfiguration getSystemConfiguration() {
        return this.systemConfiguration;
    }

    public EnvironmentConfiguration getEnvironmentConfiguration() {
        return this.environmentConfiguration;
    }

    public InmemoryConfiguration getExternalConfiguration() {
        return this.externalConfiguration;
    }

    public InmemoryConfiguration getAppExternalConfiguration() {
        return this.appExternalConfiguration;
    }

    public InmemoryConfiguration getAppConfiguration() {
        return this.appConfiguration;
    }

    public String getLocalMigrationRule() {
        return this.localMigrationRule;
    }

    public synchronized void refreshClassLoaders() {
        this.propertiesConfiguration.refresh();
        this.loadMigrationRule();
        this.globalConfiguration = null;
        this.globalConfigurationMaps = null;
        this.defaultDynamicGlobalConfiguration = null;
    }

    public Configuration getDynamicGlobalConfiguration() {
        if (this.defaultDynamicGlobalConfiguration == null) {
            if (this.defaultDynamicConfiguration == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn("0-12", "", "", "dynamicConfiguration is null , return globalConfiguration.");
                }
                return this.getConfiguration();
            }
            this.defaultDynamicGlobalConfiguration = new CompositeConfiguration();
            this.defaultDynamicGlobalConfiguration.addConfiguration(this.defaultDynamicConfiguration);
            this.defaultDynamicGlobalConfiguration.addConfiguration(this.getConfiguration());
        }
        return this.defaultDynamicGlobalConfiguration;
    }

    public Optional<DynamicConfiguration> getDynamicConfiguration() {
        return Optional.ofNullable(this.defaultDynamicConfiguration);
    }

    @DisableInject
    public void setDynamicConfiguration(DynamicConfiguration defaultDynamicConfiguration) {
        this.defaultDynamicConfiguration = defaultDynamicConfiguration;
    }
}

