/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.json.impl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.json.impl.AbstractJSONImpl;
import org.apache.dubbo.common.utils.CollectionUtils;

public class GsonImpl
extends AbstractJSONImpl {
    private volatile Object gsonCache = null;

    @Override
    public boolean isSupport() {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("gson", "test");
            if (!CollectionUtils.mapEquals(map, (Map)this.toJavaObject(this.toJson(map), (Type)((Object)Map.class)))) {
                return false;
            }
            LinkedList<String> list = new LinkedList<String>();
            list.add("gson");
            return CollectionUtils.equals(list, this.toJavaList(this.toJson(list), String.class));
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public <T> T toJavaObject(String json, Type type) {
        return (T)this.getGson().fromJson(json, type);
    }

    @Override
    public <T> List<T> toJavaList(String json, Class<T> clazz) {
        return (List)this.getGson().fromJson(json, TypeToken.getParameterized(List.class, (Type[])new Type[]{clazz}).getType());
    }

    @Override
    public String toJson(Object obj) {
        return this.getGson().toJson(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Gson getGson() {
        if (this.gsonCache == null || !(this.gsonCache instanceof Gson)) {
            GsonImpl gsonImpl = this;
            synchronized (gsonImpl) {
                if (this.gsonCache == null || !(this.gsonCache instanceof Gson)) {
                    this.gsonCache = new Gson();
                }
            }
        }
        return (Gson)this.gsonCache;
    }
}

