/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.identifier;

import org.apache.dubbo.common.URL;

public class MetadataIdentifier {
    public static final String SEPARATOR = ":";
    static final String DEFAULT_PATH_TAG = "metadata";
    private String serviceInterface;
    private String version;
    private String group;
    private String side;
    private String application;

    public MetadataIdentifier() {
    }

    public MetadataIdentifier(String serviceInterface, String version, String group, String side, String application) {
        this.serviceInterface = serviceInterface;
        this.version = version;
        this.group = group;
        this.side = side;
        this.application = application;
    }

    public MetadataIdentifier(URL url) {
        this.serviceInterface = url.getServiceInterface();
        this.version = url.getParameter("version");
        this.group = url.getParameter("group");
        this.side = url.getParameter("side");
        this.setApplication(url.getParameter("application"));
    }

    public String getUniqueKey(KeyTypeEnum keyType) {
        if (keyType == KeyTypeEnum.PATH) {
            return this.getFilePathKey();
        }
        return this.getIdentifierKey();
    }

    public String getIdentifierKey() {
        return this.serviceInterface + SEPARATOR + (this.version == null ? "" : this.version + SEPARATOR) + (this.group == null ? "" : this.group + SEPARATOR) + this.side + SEPARATOR + this.application;
    }

    private String getFilePathKey() {
        return this.getFilePathKey(DEFAULT_PATH_TAG);
    }

    private String getFilePathKey(String pathTag) {
        return pathTag + "/" + this.toServicePath() + "/" + (this.version == null ? "" : this.version + "/") + (this.group == null ? "" : this.group + "/") + this.side + "/" + this.getApplication();
    }

    private String toServicePath() {
        if ("*".equals(this.serviceInterface)) {
            return "";
        }
        return URL.encode((String)this.serviceInterface);
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(String serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getSide() {
        return this.side;
    }

    public void setSide(String side) {
        this.side = side;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public static enum KeyTypeEnum {
        PATH,
        UNIQUE_KEY;

    }
}

