/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metrics.exception.MetricsNeverHappenException;
import org.apache.dubbo.metrics.model.MethodMetric;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.key.MetricsKeyWrapper;
import org.apache.dubbo.metrics.model.sample.CounterMetricSample;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.metrics.report.AbstractMetricsExport;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class MethodStatComposite
extends AbstractMetricsExport {
    private final Map<MetricsKeyWrapper, Map<MethodMetric, AtomicLong>> methodNumStats = new ConcurrentHashMap<MetricsKeyWrapper, Map<MethodMetric, AtomicLong>>();

    public MethodStatComposite(ApplicationModel applicationModel) {
        super(applicationModel);
    }

    public void initWrapper(List<MetricsKeyWrapper> metricsKeyWrappers) {
        if (CollectionUtils.isEmpty(metricsKeyWrappers)) {
            return;
        }
        metricsKeyWrappers.forEach(appKey -> {
            Map cfr_ignored_0 = this.methodNumStats.put((MetricsKeyWrapper)appKey, new ConcurrentHashMap());
        });
    }

    public void initMethodKey(MetricsKeyWrapper wrapper, Invocation invocation) {
        if (!this.methodNumStats.containsKey(wrapper)) {
            return;
        }
        this.methodNumStats.get(wrapper).computeIfAbsent(new MethodMetric(this.getApplicationModel(), invocation), k -> new AtomicLong(0L));
    }

    public void incrementMethodKey(MetricsKeyWrapper wrapper, MethodMetric methodMetric, int size) {
        if (!this.methodNumStats.containsKey(wrapper)) {
            return;
        }
        AtomicLong stat = this.methodNumStats.get(wrapper).get(methodMetric);
        if (stat == null) {
            this.methodNumStats.get(wrapper).putIfAbsent(methodMetric, new AtomicLong(0L));
            stat = this.methodNumStats.get(wrapper).get(methodMetric);
        }
        stat.getAndAdd(size);
    }

    @Override
    public List<MetricSample> export(MetricsCategory category) {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        for (MetricsKeyWrapper wrapper : this.methodNumStats.keySet()) {
            Map<MethodMetric, AtomicLong> stringAtomicLongMap = this.methodNumStats.get(wrapper);
            for (MethodMetric methodMetric : stringAtomicLongMap.keySet()) {
                if (wrapper.getSampleType() == MetricSample.Type.COUNTER) {
                    list.add(new CounterMetricSample<Number>(wrapper, methodMetric.getTags(), category, stringAtomicLongMap.get(methodMetric)));
                    continue;
                }
                if (wrapper.getSampleType() == MetricSample.Type.GAUGE) {
                    list.add(new GaugeMetricSample<Map>(wrapper, methodMetric.getTags(), category, stringAtomicLongMap, value -> ((AtomicLong)value.get(methodMetric)).get()));
                    continue;
                }
                throw new MetricsNeverHappenException("Unsupported metricSample type: " + (Object)((Object)wrapper.getSampleType()));
            }
        }
        return list;
    }
}

