/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.event;

import org.apache.dubbo.metrics.event.TimeCounterEvent;
import org.apache.dubbo.metrics.model.MethodMetric;
import org.apache.dubbo.metrics.model.MetricsSupport;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.key.MetricsLevel;
import org.apache.dubbo.metrics.model.key.TypeWrapper;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class MetricsInitEvent
extends TimeCounterEvent {
    private static final TypeWrapper METRIC_EVENT = new TypeWrapper(MetricsLevel.SERVICE, MetricsKey.METRIC_REQUESTS);

    public MetricsInitEvent(ApplicationModel source, TypeWrapper typeWrapper) {
        super(source, typeWrapper);
    }

    public static MetricsInitEvent toMetricsInitEvent(ApplicationModel applicationModel, Invocation invocation) {
        MethodMetric methodMetric = new MethodMetric(applicationModel, invocation);
        MetricsInitEvent initEvent = new MetricsInitEvent(applicationModel, METRIC_EVENT);
        initEvent.putAttachment("metric_filter_invocation", invocation);
        initEvent.putAttachment("metric_filter_method_metrics", methodMetric);
        initEvent.putAttachment("serviceKey", MetricsSupport.getInterfaceName(invocation));
        initEvent.putAttachment("metric_filter_side", MetricsSupport.getSide(invocation));
        return initEvent;
    }
}

