/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.support.AccessLogData;

@Activate(group={"provider"}, value={"accesslog"})
public class AccessLogFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(AccessLogFilter.class);
    private static final String ACCESS_LOG_KEY = "dubbo.accesslog";
    private static final int LOG_MAX_BUFFER = 5000;
    private static final long LOG_OUTPUT_INTERVAL = 5000L;
    private static final String FILE_DATE_FORMAT = "yyyyMMdd";
    private static final DateFormat FILE_NAME_FORMATTER = new SimpleDateFormat("yyyyMMdd");
    private static final Map<String, Set<AccessLogData>> logEntries = new ConcurrentHashMap<String, Set<AccessLogData>>();
    private static final ScheduledExecutorService logScheduled = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("Dubbo-Access-Log", true));

    public AccessLogFilter() {
        logScheduled.scheduleWithFixedDelay(this::writeLogToFile, 5000L, 5000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation inv) throws RpcException {
        try {
            String accessLogKey = invoker.getUrl().getParameter("accesslog");
            if (ConfigUtils.isNotEmpty((String)accessLogKey)) {
                AccessLogData logData = this.buildAccessLogData(invoker, inv);
                this.log(accessLogKey, logData);
            }
        }
        catch (Throwable t) {
            logger.warn("Exception in AccessLogFilter of service(" + invoker + " -> " + inv + ")", t);
        }
        return invoker.invoke(inv);
    }

    private void log(String accessLog, AccessLogData accessLogData) {
        Set logSet = logEntries.computeIfAbsent(accessLog, k -> new ConcurrentHashSet());
        if (logSet.size() < 5000) {
            logSet.add(accessLogData);
        } else {
            logger.warn("AccessLog buffer is full skipping buffer ");
        }
    }

    private void writeLogToFile() {
        if (!logEntries.isEmpty()) {
            for (Map.Entry<String, Set<AccessLogData>> entry : logEntries.entrySet()) {
                try {
                    String accessLog = entry.getKey();
                    Set<AccessLogData> logSet = entry.getValue();
                    if (ConfigUtils.isDefault((String)accessLog)) {
                        this.processWithServiceLogger(logSet);
                        continue;
                    }
                    File file = new File(accessLog);
                    this.createIfLogDirAbsent(file);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Append log to " + accessLog);
                    }
                    this.renameFile(file);
                    this.processWithAccessKeyLogger(logSet, file);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void processWithAccessKeyLogger(Set<AccessLogData> logSet, File file) throws IOException {
        try (FileWriter writer = new FileWriter(file, true);){
            Iterator<AccessLogData> iterator = logSet.iterator();
            while (iterator.hasNext()) {
                writer.write(iterator.next().getLogMessage());
                writer.write("\r\n");
                iterator.remove();
            }
            writer.flush();
        }
    }

    private AccessLogData buildAccessLogData(Invoker<?> invoker, Invocation inv) {
        RpcContext context = RpcContext.getContext();
        AccessLogData logData = AccessLogData.newLogData();
        logData.setServiceName(invoker.getInterface().getName());
        logData.setMethodName(inv.getMethodName());
        logData.setVersion(invoker.getUrl().getParameter("version"));
        logData.setGroup(invoker.getUrl().getParameter("group"));
        logData.setInvocationTime(new Date());
        logData.setTypes(inv.getParameterTypes());
        logData.setArguments(inv.getArguments());
        return logData;
    }

    private void processWithServiceLogger(Set<AccessLogData> logSet) {
        Iterator<AccessLogData> iterator = logSet.iterator();
        while (iterator.hasNext()) {
            AccessLogData logData = iterator.next();
            LoggerFactory.getLogger((String)("dubbo.accesslog." + logData.getServiceName())).info(logData.getLogMessage());
            iterator.remove();
        }
    }

    private void createIfLogDirAbsent(File file) {
        File dir = file.getParentFile();
        if (null != dir && !dir.exists()) {
            dir.mkdirs();
        }
    }

    private void renameFile(File file) {
        String last;
        String now;
        if (file.exists() && !(now = FILE_NAME_FORMATTER.format(new Date())).equals(last = FILE_NAME_FORMATTER.format(new Date(file.lastModified())))) {
            File archive = new File(file.getAbsolutePath() + "." + last);
            file.renameTo(archive);
        }
    }
}

