/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.log.AbortedTxn;
import kafka.log.BatchMetadata;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogSegmentTest$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManager$;
import kafka.log.TimeIndex;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.log.TransactionIndex;
import kafka.server.FetchDataInfo;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t\ra\u0001B\u0001\u0003\u0001\u001d\u0011a\u0002T8h'\u0016<W.\u001a8u)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tW#\u0001\f\u0011\u0005]yR\"\u0001\r\u000b\u0005eQ\u0012AB2p[6|gN\u0003\u0002\u00067)\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0013\t\u0001\u0003D\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\r\t\u0002\u0001\u0015!\u0003\u0017\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0003b\u0002\u0013\u0001\u0005\u0004%\t!J\u0001\tg\u0016<W.\u001a8ugV\ta\u0005E\u0002(Y9j\u0011\u0001\u000b\u0006\u0003S)\nq!\\;uC\ndWM\u0003\u0002,\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u00055B#aC!se\u0006L()\u001e4gKJ\u0004\"AE\u0018\n\u0005A\u0012!A\u0003'pON+w-\\3oi\"1!\u0007\u0001Q\u0001\n\u0019\n\u0011b]3h[\u0016tGo\u001d\u0011\t\u0013Q\u0002\u0001\u0019!a\u0001\n\u0003)\u0014A\u00027pO\u0012K'/F\u00017!\t9D(D\u00019\u0015\tI$(\u0001\u0002j_*\t1(\u0001\u0003kCZ\f\u0017BA\u001f9\u0005\u00111\u0015\u000e\\3\t\u0013}\u0002\u0001\u0019!a\u0001\n\u0003\u0001\u0015A\u00037pO\u0012K'o\u0018\u0013fcR\u0011\u0011\t\u0012\t\u0003\u0013\tK!a\u0011\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b\u000bz\n\t\u00111\u00017\u0003\rAH%\r\u0005\u0007\u000f\u0002\u0001\u000b\u0015\u0002\u001c\u0002\u000f1|w\rR5sA!)\u0011\n\u0001C\u0001\u0015\u0006i1M]3bi\u0016\u001cVmZ7f]R$RAL&Q+^CQ\u0001\u0014%A\u00025\u000baa\u001c4gg\u0016$\bCA\u0005O\u0013\ty%B\u0001\u0003M_:<\u0007bB)I!\u0003\u0005\rAU\u0001\u0013S:$W\r_%oi\u0016\u0014h/\u00197CsR,7\u000f\u0005\u0002\n'&\u0011AK\u0003\u0002\u0004\u0013:$\bb\u0002,I!\u0003\u0005\rAU\u0001\r[\u0006D8+Z4nK:$Xj\u001d\u0005\b1\"\u0003\n\u00111\u0001Z\u0003\u0011!\u0018.\\3\u0011\u0005ikV\"A.\u000b\u0005qC\u0012!B;uS2\u001c\u0018B\u00010\\\u0005\u0011!\u0016.\\3\t\u000b\u0001\u0004A\u0011A1\u0002\u000fI,7m\u001c:egR\u0019!\r[5\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015D\u0012A\u0002:fG>\u0014H-\u0003\u0002hI\niQ*Z7pef\u0014VmY8sINDQ\u0001T0A\u00025CQ\u0001Y0A\u0002)\u00042!C6n\u0013\ta'B\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002\"A\\9\u000f\u0005%y\u0017B\u00019\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011!o\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005AT\u0001\"B;\u0001\t\u00031\u0018!B:fiV\u0004H#A!)\u0005QD\bCA=}\u001b\u0005Q(BA>\u001e\u0003\u0015QWO\\5u\u0013\ti(P\u0001\u0004CK\u001a|'/\u001a\u0005\u0006\u007f\u0002!\tA^\u0001\ti\u0016\f'\u000fZ8x]\"\u001aa0a\u0001\u0011\u0007e\f)!C\u0002\u0002\bi\u0014Q!\u00114uKJDa!a\u0003\u0001\t\u00031\u0018A\u0006;fgR\u0014V-\u00193P]\u0016k\u0007\u000f^=TK\u001elWM\u001c;)\t\u0005%\u0011q\u0002\t\u0004s\u0006E\u0011bAA\nu\n!A+Z:u\u0011\u0019\t9\u0002\u0001C\u0001m\u0006IB/Z:u%\u0016\fGMQ3g_J,g)\u001b:ti>3gm]3uQ\u0011\t)\"a\u0004\t\r\u0005u\u0001\u0001\"\u0001w\u00035!Xm\u001d;NCb|eMZ:fi\"\"\u00111DA\b\u0011\u0019\t\u0019\u0003\u0001C\u0001m\u0006\tB/Z:u%\u0016\fG-\u00114uKJd\u0015m\u001d;)\t\u0005\u0005\u0012q\u0002\u0005\u0007\u0003S\u0001A\u0011\u0001<\u0002\u001fQ,7\u000f\u001e*fC\u00124%o\\7HCBDC!a\n\u0002\u0010!1\u0011q\u0006\u0001\u0005\u0002Y\fA\u0002^3tiR\u0013XO\\2bi\u0016DC!!\f\u0002\u0010!1\u0011Q\u0007\u0001\u0005\u0002Y\f\u0001\u0004^3tiR\u0013XO\\2bi\u0016,U\u000e\u001d;z'\u0016<W.\u001a8uQ\u0011\t\u0019$a\u0004\t\r\u0005m\u0002\u0001\"\u0001w\u0003Y\"Xm\u001d;SK2|\u0017\r\u001a'be\u001e,7\u000f\u001e+j[\u0016\u001cH/Y7q\u0003:$g*\u001a=u\u001f\u001a47/\u001a;BMR,'\u000f\u0016:v]\u000e\fG/[8oQ\u0011\tI$a\u0004\t\r\u0005\u0005\u0003\u0001\"\u0001w\u0003A!Xm\u001d;UeVt7-\u0019;f\rVdG\u000e\u000b\u0003\u0002@\u0005=\u0001BBA$\u0001\u0011\u0005a/A\ruKN$h)\u001b8e\u001f\u001a47/\u001a;CsRKW.Z:uC6\u0004\b\u0006BA#\u0003\u001fAa!!\u0014\u0001\t\u00031\u0018!\u0007;fgRtU\r\u001f;PM\u001a\u001cX\r^\"bY\u000e,H.\u0019;j_:DC!a\u0013\u0002\u0010!1\u00111\u000b\u0001\u0005\u0002Y\fa\u0003^3ti\u000eC\u0017M\\4f\r&dWmU;gM&DXm\u001d\u0015\u0005\u0003#\ny\u0001\u0003\u0004\u0002Z\u0001!\tA^\u0001\u001ei\u0016\u001cHOU3d_Z,'/\u001f$jq\u0016\u001c8i\u001c:skB$\u0018J\u001c3fq\"\"\u0011qKA\b\u0011\u0019\ty\u0006\u0001C\u0001m\u0006YB/Z:u%\u0016\u001cwN^3s)J\fgn]1di&|g.\u00138eKbDC!!\u0018\u0002\u0010!9\u0011Q\r\u0001\u0005\n\u0005\u001d\u0014!D3oIRChNU3d_J$7\u000fF\bc\u0003S\n\u0019(a\u001e\u0002\u0002\u0006\r\u0015qQAF\u0011!\tY'a\u0019A\u0002\u00055\u0014!E2p]R\u0014x\u000e\u001c*fG>\u0014H\rV=qKB\u00191-a\u001c\n\u0007\u0005EDMA\tD_:$(o\u001c7SK\u000e|'\u000f\u001a+za\u0016Dq!!\u001e\u0002d\u0001\u0007Q*\u0001\u0006qe>$WoY3s\u0013\u0012D\u0001\"!\u001f\u0002d\u0001\u0007\u00111P\u0001\u000eaJ|G-^2fe\u0016\u0003xn\u00195\u0011\u0007%\ti(C\u0002\u0002\u0000)\u0011Qa\u00155peRDa\u0001TA2\u0001\u0004i\u0005\"CAC\u0003G\u0002\n\u00111\u0001S\u0003Q\u0001\u0018M\u001d;ji&|g\u000eT3bI\u0016\u0014X\t]8dQ\"I\u0011\u0011RA2!\u0003\u0005\rAU\u0001\u0011G>|'\u000fZ5oCR|'/\u00129pG\"D\u0011\"!$\u0002dA\u0005\t\u0019A'\u0002\u0013QLW.Z:uC6\u0004\bBBAI\u0001\u0011\u0005a/A\u0011uKN$(+Z2pm\u0016\u0014\u0018PR5yKN\u001cuN\u001d:vaR$\u0016.\\3J]\u0012,\u0007\u0010\u000b\u0003\u0002\u0010\u0006=\u0001BBAL\u0001\u0011\u0005a/\u0001\u0010uKN$(+Z2pm\u0016\u0014\u0018pV5uQ\u000e{'O];qi6+7o]1hK\"\"\u0011QSA\b\u0011\u0019I\u0005\u0001\"\u0003\u0002\u001eRIa&a(\u0002$\u00065\u0016\u0011\u0017\u0005\b\u0003C\u000bY\n1\u0001N\u0003)\u0011\u0017m]3PM\u001a\u001cX\r\u001e\u0005\t\u0003K\u000bY\n1\u0001\u0002(\u0006\tb-\u001b7f\u00032\u0014X-\u00193z\u000bbL7\u000f^:\u0011\u0007%\tI+C\u0002\u0002,*\u0011qAQ8pY\u0016\fg\u000eC\u0004\u00020\u0006m\u0005\u0019\u0001*\u0002\u0019%t\u0017\u000e\u001e$jY\u0016\u001c\u0016N_3\t\u0011\u0005M\u00161\u0014a\u0001\u0003O\u000b1\u0002\u001d:fC2dwnY1uK\"1\u0011q\u0017\u0001\u0005\u0002Y\fq\u0005^3ti\u000e\u0013X-\u0019;f/&$\b.\u00138ji\u001aKG.Z*ju\u0016\f\u0005\u000f]3oI6+7o]1hK\"\"\u0011QWA\b\u0011\u0019\ti\f\u0001C\u0001m\u00069C/Z:u\u0007J,\u0017\r^3XSRD\u0017J\\5u\r&dWmU5{K\u000ecW-\u0019:TQV$Hm\\<oQ\u0011\tY,a\u0004\t\r\u0005\r\u0007\u0001\"\u0001w\u00039\u001a\bn\\;mIR\u0013XO\\2bi\u0016,e/\u001a8JM>3gm]3u!>Lg\u000e^:U_\u0006;\u0015\r]%o)\",Gj\\4)\t\u0005\u0005\u0017q\u0002\u0005\u0007\u0003\u0013\u0004A\u0011\u0001<\u0002%Q,7\u000f^!qa\u0016tGM\u0012:p[\u001aKG.\u001a\u0015\u0005\u0003\u000f\fy\u0001C\u0005\u0002P\u0002\t\n\u0011\"\u0001\u0002R\u000692M]3bi\u0016\u001cVmZ7f]R$C-\u001a4bk2$HEM\u000b\u0003\u0003'T3AUAkW\t\t9\u000e\u0005\u0003\u0002Z\u0006\rXBAAn\u0015\u0011\ti.a8\u0002\u0013Ut7\r[3dW\u0016$'bAAq\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00181\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CAu\u0001E\u0005I\u0011AAi\u0003]\u0019'/Z1uKN+w-\\3oi\u0012\"WMZ1vYR$3\u0007C\u0005\u0002n\u0002\t\n\u0011\"\u0001\u0002p\u000692M]3bi\u0016\u001cVmZ7f]R$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003cT3!WAk\u0011%\t)\u0010AI\u0001\n\u0013\t\t.A\ff]\u0012$\u0006P\u001c*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%k!I\u0011\u0011 \u0001\u0012\u0002\u0013%\u0011\u0011[\u0001\u0018K:$G\u000b\u001f8SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIYB\u0011\"!@\u0001#\u0003%I!a@\u0002/\u0015tG\r\u0016=o%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012:TC\u0001B\u0001U\ri\u0015Q\u001b")
public class LogSegmentTest {
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final ArrayBuffer<LogSegment> segments = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private File logDir;

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public ArrayBuffer<LogSegment> segments() {
        return this.segments;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogSegment createSegment(long offset, int indexIntervalBytes, int maxSegmentMs, Time time) {
        FileRecords ms = FileRecords.open((File)Log$.MODULE$.logFile(this.logDir(), offset, Log$.MODULE$.logFile$default$3()));
        OffsetIndex idx = new OffsetIndex(Log$.MODULE$.offsetIndexFile(this.logDir(), offset, Log$.MODULE$.offsetIndexFile$default$3()), offset, 1000, OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        TimeIndex timeIdx = new TimeIndex(Log$.MODULE$.timeIndexFile(this.logDir(), offset, Log$.MODULE$.timeIndexFile$default$3()), offset, 1500, TimeIndex$.MODULE$.$lessinit$greater$default$4());
        TransactionIndex txnIndex = new TransactionIndex(offset, Log$.MODULE$.transactionIndexFile(this.logDir(), offset, Log$.MODULE$.transactionIndexFile$default$3()));
        LogSegment seg = new LogSegment(ms, idx, timeIdx, txnIndex, offset, indexIntervalBytes, 0L, (long)maxSegmentMs, Integer.MAX_VALUE, time);
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public MemoryRecords records(long offset, Seq<String> records2) {
        return MemoryRecords.withRecords((byte)1, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)records2.map((Function1)new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final long offset$1;

            public final SimpleRecord apply(String s) {
                return new SimpleRecord(this.offset$1 * 10L, s.getBytes());
            }
            {
                this.offset$1 = offset$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
    }

    @Before
    public void setup() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
    }

    @After
    public void teardown() {
        this.segments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(LogSegment x$1) {
                x$1.close();
            }
        });
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testReadOnEmptySegment() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        long x$4 = 40L;
        int x$5 = 300;
        None$ x$6 = None$.MODULE$;
        long x$7 = seg.read$default$4();
        boolean x$8 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$4, (Option)x$6, x$5, x$7, x$8);
        Assert.assertNull((String)"Read beyond the last offset in the segment should be null", (Object)read);
    }

    @Test
    public void testReadBeforeFirstOffset() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "little", "bee"}));
        seg.append(53L, -1L, -1L, ms);
        long x$9 = 41L;
        int x$10 = 300;
        None$ x$11 = None$.MODULE$;
        long x$12 = seg.read$default$4();
        boolean x$13 = seg.read$default$5();
        Records read = seg.read(x$9, (Option)x$11, x$10, x$12, x$13).records();
        TestUtils$.MODULE$.checkEquals(ms.records().iterator(), read.records().iterator());
    }

    @Test
    public void testMaxOffset() {
        int baseOffset = 50;
        LogSegment seg = this.createSegment((long)baseOffset, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        MemoryRecords ms = this.records(baseOffset, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "beautiful"}));
        seg.append(52L, -1L, -1L, ms);
        this.validate$1(50L, seg, ms);
        this.validate$1(51L, seg, ms);
        this.validate$1(52L, seg, ms);
    }

    @Test
    public void testReadAfterLast() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        long x$19 = 52L;
        int x$20 = 200;
        None$ x$21 = None$.MODULE$;
        long x$22 = seg.read$default$4();
        boolean x$23 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$19, (Option)x$21, x$20, x$22, x$23);
        Assert.assertNull((String)"Read beyond the last offset in the segment should give null", (Object)read);
    }

    @Test
    public void testReadFromGap() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        long x$24 = 55L;
        int x$25 = 200;
        None$ x$26 = None$.MODULE$;
        long x$27 = seg.read$default$4();
        boolean x$28 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$24, (Option)x$26, x$25, x$27, x$28);
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
    }

    @Test
    public void testTruncate() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 30).foreach$mVc$sp((Function1)new Serializable(this, seg, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final LogSegment seg$2;
            private final IntRef offset$3;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                MemoryRecords ms1 = this.$outer.records(this.offset$3.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
                this.seg$2.append((long)this.offset$3.elem, -1L, -1L, ms1);
                MemoryRecords ms2 = this.$outer.records(this.offset$3.elem + 1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
                this.seg$2.append((long)(this.offset$3.elem + 1), -1L, -1L, ms2);
                FetchDataInfo read = this.seg$2.read((long)this.offset$3.elem, (Option)None$.MODULE$, 10000, this.seg$2.read$default$4(), this.seg$2.read$default$5());
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Record[]{(Record)ms1.records().iterator().next(), (Record)ms2.records().iterator().next()})), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(read.records().records()).asScala()).toList());
                this.seg$2.truncateTo((long)(this.offset$3.elem + 1));
                FetchDataInfo read2 = this.seg$2.read((long)this.offset$3.elem, (Option)None$.MODULE$, 10000, this.seg$2.read$default$4(), this.seg$2.read$default$5());
                Assert.assertEquals((long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(read2.records().records()).asScala()).size());
                TestUtils$.MODULE$.checkEquals(ms1.records().iterator(), read2.records().records().iterator());
                ++this.offset$3.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.seg$2 = seg$2;
                this.offset$3 = offset$3;
            }
        });
    }

    @Test
    public void testTruncateEmptySegment() {
        int maxSegmentMs = 300000;
        MockTime time = new MockTime();
        long x$29 = 0L;
        int x$30 = maxSegmentMs;
        MockTime x$31 = time;
        int x$32 = this.createSegment$default$2();
        LogSegment seg = this.createSegment(x$29, x$32, x$30, (Time)x$31);
        seg.close();
        long x$33 = 0L;
        int x$34 = maxSegmentMs;
        MockTime x$35 = time;
        int x$36 = this.createSegment$default$2();
        LogSegment reopened = this.createSegment(x$33, x$36, x$34, (Time)x$35);
        Assert.assertEquals((long)0L, (long)seg.timeIndex().sizeInBytes());
        Assert.assertEquals((long)0L, (long)seg.offsetIndex().sizeInBytes());
        time.sleep(500L);
        reopened.truncateTo(57L);
        Assert.assertEquals((long)0L, (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        Assert.assertFalse((boolean)reopened.timeIndex().isFull());
        Assert.assertFalse((boolean)reopened.offsetIndex().isFull());
        Assert.assertFalse((boolean)reopened.shouldRoll(1024, -1L, 100L, time.milliseconds()));
        time.sleep((long)(maxSegmentMs + 1));
        Assert.assertEquals((long)(maxSegmentMs + 1), (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        Assert.assertFalse((boolean)reopened.shouldRoll(1024, -1L, 100L, time.milliseconds()));
        Assert.assertTrue((boolean)reopened.shouldRoll(1024, -1L, (long)Integer.MAX_VALUE + 200L, time.milliseconds()));
    }

    @Test
    public void testReloadLargestTimestampAndNextOffsetAfterTruncation() {
        int numMessages = 30;
        LogSegment seg = this.createSegment(40L, 2 * this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})).sizeInBytes() - 1, this.createSegment$default$3(), this.createSegment$default$4());
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, seg, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final LogSegment seg$3;
            private final IntRef offset$4;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                this.seg$3.append((long)this.offset$4.elem, (long)this.offset$4.elem, (long)this.offset$4.elem, this.$outer.records(this.offset$4.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})));
                ++this.offset$4.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.seg$3 = seg$3;
                this.offset$4 = offset$4;
            }
        });
        Assert.assertEquals((long)offset.elem, (long)seg.readNextOffset());
        int expectedNumEntries = numMessages / 2 - 1;
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should have ", " time indexes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedNumEntries)})), (long)expectedNumEntries, (long)seg.timeIndex().entries());
        seg.truncateTo(41L);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should have 0 time indexes"})).s((Seq)Nil$.MODULE$), (long)0L, (long)seg.timeIndex().entries());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Largest timestamp should be 400"})).s((Seq)Nil$.MODULE$), (long)400L, (long)seg.largestTimestamp());
        Assert.assertEquals((long)41L, (long)seg.readNextOffset());
    }

    @Test
    public void testTruncateFull() {
        MockTime time = new MockTime();
        long x$37 = 40L;
        MockTime x$38 = time;
        int x$39 = this.createSegment$default$2();
        int x$40 = this.createSegment$default$3();
        LogSegment seg = this.createSegment(x$37, x$39, x$40, (Time)x$38);
        seg.append(41L, -1L, -1L, this.records(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
        time.sleep(500L);
        Assert.assertEquals((long)500L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        seg.truncateTo(0L);
        Assert.assertEquals((long)0L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        Assert.assertFalse((boolean)seg.timeIndex().isFull());
        Assert.assertFalse((boolean)seg.offsetIndex().isFull());
        Assert.assertNull((String)"Segment should be empty.", (Object)seg.read(0L, (Option)None$.MODULE$, 1024, seg.read$default$4(), seg.read$default$5()));
        seg.append(41L, -1L, -1L, this.records(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
    }

    @Test
    public void testFindOffsetByTimestamp() {
        int messageSize = this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"msg00"})).s((Seq)Nil$.MODULE$)})).sizeInBytes();
        LogSegment seg = this.createSegment(40L, messageSize * 2 - 1, this.createSegment$default$3(), this.createSegment$default$4());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(40), 50).foreach$mVc$sp((Function1)new Serializable(this, seg){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final LogSegment seg$4;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.seg$4.append((long)i, (long)(i * 10), (long)i, this.$outer.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"msg", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.seg$4 = seg$4;
            }
        });
        Assert.assertEquals((long)490L, (long)seg.largestTimestamp());
        Assert.assertEquals((long)42L, (long)((TimestampOffset)seg.findOffsetByTimestamp(420L, seg.findOffsetByTimestamp$default$2()).get()).offset());
        Assert.assertEquals((long)43L, (long)((TimestampOffset)seg.findOffsetByTimestamp(421L, seg.findOffsetByTimestamp$default$2()).get()).offset());
        Assert.assertEquals((long)43L, (long)((TimestampOffset)seg.findOffsetByTimestamp(430L, seg.findOffsetByTimestamp$default$2()).get()).offset());
        Assert.assertEquals((long)44L, (long)((TimestampOffset)seg.findOffsetByTimestamp(431L, seg.findOffsetByTimestamp$default$2()).get()).offset());
        Assert.assertEquals((Object)None$.MODULE$, (Object)seg.findOffsetByTimestamp(491L, seg.findOffsetByTimestamp$default$2()));
        Assert.assertEquals((long)41L, (long)((TimestampOffset)seg.findOffsetByTimestamp(401L, seg.findOffsetByTimestamp$default$2()).get()).offset());
        Assert.assertEquals((long)40L, (long)((TimestampOffset)seg.findOffsetByTimestamp(399L, seg.findOffsetByTimestamp$default$2()).get()).offset());
    }

    @Test
    public void testNextOffsetCalculation() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        Assert.assertEquals((long)40L, (long)seg.readNextOffset());
        seg.append(52L, -1L, -1L, this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Assert.assertEquals((long)53L, (long)seg.readNextOffset());
    }

    @Test
    public void testChangeFileSuffixes() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        File logFile = seg.log().file();
        File indexFile = seg.offsetIndex().file();
        seg.changeFileSuffixes("", ".deleted");
        Assert.assertEquals((Object)new StringBuilder().append((Object)logFile.getAbsolutePath()).append((Object)".deleted").toString(), (Object)seg.log().file().getAbsolutePath());
        Assert.assertEquals((Object)new StringBuilder().append((Object)indexFile.getAbsolutePath()).append((Object)".deleted").toString(), (Object)seg.offsetIndex().file().getAbsolutePath());
        Assert.assertTrue((boolean)seg.log().file().exists());
        Assert.assertTrue((boolean)seg.offsetIndex().file().exists());
    }

    @Test
    public void testRecoveryFixesCorruptIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this, seg){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final LogSegment seg$5;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.seg$5.append((long)i, -1L, -1L, this.$outer.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.seg$5 = seg$5;
            }
        });
        File indexFile = seg.offsetIndex().file();
        TestUtils$.MODULE$.writeNonsenseToFile(indexFile, 5L, (int)indexFile.length());
        seg.recover(new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3()), seg.recover$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this, seg){
            public static final long serialVersionUID = 0L;
            private final LogSegment seg$5;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)i, (long)((Record)this.seg$5.read((long)i, (Option)new Some((Object)BoxesRunTime.boxToLong((long)(i + 1))), 1024, this.seg$5.read$default$4(), this.seg$5.read$default$5()).records().records().iterator().next()).offset());
            }
            {
                this.seg$5 = seg$5;
            }
        });
    }

    @Test
    public void testRecoverTransactionIndex() {
        LogSegment segment = this.createSegment(100L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        short producerEpoch = (short)0;
        int partitionLeaderEpoch = 15;
        int sequence = 100;
        long pid1 = 5L;
        long pid2 = 10L;
        segment.append(101L, -1L, 100L, MemoryRecords.withTransactionalRecords((long)100L, (CompressionType)CompressionType.NONE, (long)pid1, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(103L, -1L, 102L, MemoryRecords.withTransactionalRecords((long)102L, (CompressionType)CompressionType.NONE, (long)pid2, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(105L, -1L, 104L, MemoryRecords.withRecords((long)104L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(partitionLeaderEpoch), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(106L, -1L, 106L, this.endTxnRecords(ControlRecordType.ABORT, pid2, producerEpoch, 106L, this.endTxnRecords$default$5(), this.endTxnRecords$default$6(), this.endTxnRecords$default$7()));
        segment.append(107L, -1L, 107L, this.endTxnRecords(ControlRecordType.COMMIT, pid1, producerEpoch, 107L, this.endTxnRecords$default$5(), this.endTxnRecords$default$6(), this.endTxnRecords$default$7()));
        ProducerStateManager stateManager = new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3());
        segment.recover(stateManager, segment.recover$default$2());
        Assert.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        List abortedTxns = segment.txnIndex().allAbortedTxns();
        Assert.assertEquals((long)1L, (long)abortedTxns.size());
        AbortedTxn abortedTxn = (AbortedTxn)abortedTxns.head();
        Assert.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assert.assertEquals((long)102L, (long)abortedTxn.firstOffset());
        Assert.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assert.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
        stateManager = new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3());
        stateManager.loadProducerEntry(new ProducerStateEntry(pid2, (Queue)Queue$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BatchMetadata[]{new BatchMetadata(10, 10L, 5, -1L)})), producerEpoch, 0, (Option)new Some((Object)BoxesRunTime.boxToLong((long)75L))));
        segment.recover(stateManager, segment.recover$default$2());
        Assert.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        abortedTxns = segment.txnIndex().allAbortedTxns();
        Assert.assertEquals((long)1L, (long)abortedTxns.size());
        abortedTxn = (AbortedTxn)abortedTxns.head();
        Assert.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assert.assertEquals((long)75L, (long)abortedTxn.firstOffset());
        Assert.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assert.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
    }

    private MemoryRecords endTxnRecords(ControlRecordType controlRecordType, long producerId, short producerEpoch, long offset, int partitionLeaderEpoch, int coordinatorEpoch, long timestamp) {
        EndTransactionMarker marker = new EndTransactionMarker(controlRecordType, coordinatorEpoch);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)partitionLeaderEpoch, (long)producerId, (short)producerEpoch, (EndTransactionMarker)marker);
    }

    private int endTxnRecords$default$5() {
        return 0;
    }

    private int endTxnRecords$default$6() {
        return 0;
    }

    private long endTxnRecords$default$7() {
        return -1L;
    }

    @Test
    public void testRecoveryFixesCorruptTimeIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this, seg){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final LogSegment seg$6;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.seg$6.append((long)i, (long)(i * 10), (long)i, this.$outer.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.seg$6 = seg$6;
            }
        });
        File timeIndexFile = seg.timeIndex().file();
        TestUtils$.MODULE$.writeNonsenseToFile(timeIndexFile, 5L, (int)timeIndexFile.length());
        seg.recover(new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3()), seg.recover$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this, seg){
            public static final long serialVersionUID = 0L;
            private final LogSegment seg$6;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)i, (long)((TimestampOffset)this.seg$6.findOffsetByTimestamp((long)(i * 10), this.seg$6.findOffsetByTimestamp$default$2()).get()).offset());
                if (i < 99) {
                    Assert.assertEquals((long)(i + 1), (long)((TimestampOffset)this.seg$6.findOffsetByTimestamp((long)(i * 10 + 1), this.seg$6.findOffsetByTimestamp$default$2()).get()).offset());
                }
            }
            {
                this.seg$6 = seg$6;
            }
        });
    }

    @Test
    public void testRecoveryWithCorruptMessage() {
        int messagesAppended = 20;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, messagesAppended){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final int messagesAppended$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                LogSegment seg = this.$outer.createSegment(0L, this.$outer.createSegment$default$2(), this.$outer.createSegment$default$3(), this.$outer.createSegment$default$4());
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.messagesAppended$1).foreach$mVc$sp((Function1)new Serializable(this, seg){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testRecoveryWithCorruptMessage$1 $outer;
                    private final LogSegment seg$7;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.seg$7.append((long)i, -1L, -1L, this.$outer.kafka$log$LogSegmentTest$$anonfun$$$outer().records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.seg$7 = seg$7;
                    }
                });
                int offsetToBeginCorruption = TestUtils$.MODULE$.random().nextInt(this.messagesAppended$1);
                FileRecords.LogOffsetPosition recordPosition = seg.log().searchForOffsetWithSize((long)offsetToBeginCorruption, 0);
                int position = recordPosition.position + TestUtils$.MODULE$.random().nextInt(15);
                TestUtils$.MODULE$.writeNonsenseToFile(seg.log().file(), position, (int)(seg.log().file().length() - (long)position));
                seg.recover(new ProducerStateManager(this.$outer.topicPartition(), this.$outer.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3()), seg.recover$default$2());
                Assert.assertEquals((String)"Should have truncated off bad messages.", (Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), offsetToBeginCorruption).toList(), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(seg.log().batches()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(FileLogInputStream.FileChannelRecordBatch x$3) {
                        return x$3.lastOffset();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toList());
                seg.deleteIfExists();
            }

            public /* synthetic */ LogSegmentTest kafka$log$LogSegmentTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.messagesAppended$1 = messagesAppended$1;
            }
        });
    }

    private LogSegment createSegment(long baseOffset, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogConfig logConfig = new LogConfig((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.IndexIntervalBytesProp()), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentIndexBytesProp()), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentJitterMsProp()), (Object)BoxesRunTime.boxToInteger((int)0))}))).asJava(), LogConfig$.MODULE$.apply$default$2());
        LogSegment seg = LogSegment$.MODULE$.open(tempDir, baseOffset, logConfig, Time.SYSTEM, fileAlreadyExists, initFileSize, preallocate, LogSegment$.MODULE$.open$default$8());
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public int createSegment$default$2() {
        return 10;
    }

    public int createSegment$default$3() {
        return Integer.MAX_VALUE;
    }

    public Time createSegment$default$4() {
        return Time.SYSTEM;
    }

    @Test
    public void testCreateWithInitFileSizeAppendMessage() {
        LogSegment seg = this.createSegment(40L, false, 0x20000000, true);
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        long x$41 = 55L;
        int x$42 = 200;
        None$ x$43 = None$.MODULE$;
        long x$44 = seg.read$default$4();
        boolean x$45 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$41, (Option)x$43, x$42, x$44, x$45);
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
    }

    @Test
    public void testCreateWithInitFileSizeClearShutdown() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogConfig logConfig = new LogConfig((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.IndexIntervalBytesProp()), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentIndexBytesProp()), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentJitterMsProp()), (Object)BoxesRunTime.boxToInteger((int)0))}))).asJava(), LogConfig$.MODULE$.apply$default$2());
        LogSegment seg = LogSegment$.MODULE$.open(tempDir, 40L, logConfig, Time.SYSTEM, false, 0x20000000, true, LogSegment$.MODULE$.open$default$8());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        long x$46 = 55L;
        int x$47 = 200;
        None$ x$48 = None$.MODULE$;
        long x$49 = seg.read$default$4();
        boolean x$50 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$46, (Option)x$48, x$47, x$49, x$50);
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
        int oldSize = seg.log().sizeInBytes();
        long oldPosition = seg.log().channel().position();
        long oldFileSize = seg.log().file().length();
        Assert.assertEquals((long)0x20000000L, (long)oldFileSize);
        seg.close();
        Assert.assertEquals((long)oldSize, (long)seg.log().file().length());
        LogSegment segReopen = LogSegment$.MODULE$.open(tempDir, 40L, logConfig, Time.SYSTEM, true, 0x20000000, true, LogSegment$.MODULE$.open$default$8());
        this.segments().$plus$eq((Object)segReopen);
        long x$51 = 55L;
        int x$52 = 200;
        None$ x$53 = None$.MODULE$;
        long x$54 = segReopen.read$default$4();
        boolean x$55 = segReopen.read$default$5();
        FetchDataInfo readAgain = segReopen.read(x$51, (Option)x$53, x$52, x$54, x$55);
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), readAgain.records().records().iterator());
        int size2 = segReopen.log().sizeInBytes();
        long position = segReopen.log().channel().position();
        long fileSize = segReopen.log().file().length();
        Assert.assertEquals((long)oldPosition, (long)position);
        Assert.assertEquals((long)oldSize, (long)size2);
        Assert.assertEquals((long)size2, (long)fileSize);
    }

    @Test
    public void shouldTruncateEvenIfOffsetPointsToAGapInTheLog() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        int offset = 40;
        MemoryRecords ms1 = this.records$1(offset, "first message");
        seg.append((long)offset, -1L, -1L, ms1);
        MemoryRecords ms2 = this.records$1(offset + 3, "message after gap");
        seg.append((long)(offset + 3), -1L, -1L, ms2);
        seg.truncateTo((long)(offset + 1));
        FetchDataInfo log2 = seg.read((long)offset, (Option)None$.MODULE$, 10000, seg.read$default$4(), seg.read$default$5());
        Assert.assertEquals((long)offset, (long)((RecordBatch)log2.records().batches().iterator().next()).baseOffset());
        Assert.assertEquals((long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(log2.records().batches()).asScala()).size());
    }

    @Test
    public void testAppendFromFile() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        FileRecords fileRecords = FileRecords.open((File)Log$.MODULE$.logFile(tempDir, 0L, Log$.MODULE$.logFile$default$3()));
        fileRecords.append(this.records$2(0L, 1024));
        fileRecords.append(this.records$2(500L, 0x100001));
        int sizeBeforeOverflow = fileRecords.sizeInBytes();
        fileRecords.append(this.records$2(0x80000004L, 1024));
        int sizeAfterOverflow = fileRecords.sizeInBytes();
        LogSegment segment = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        int bytesAppended = segment.appendFromFile(fileRecords, 0);
        Assert.assertEquals((long)sizeBeforeOverflow, (long)bytesAppended);
        Assert.assertEquals((long)sizeBeforeOverflow, (long)segment.size());
        LogSegment overflowSegment = this.createSegment(Integer.MAX_VALUE, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        int overflowBytesAppended = overflowSegment.appendFromFile(fileRecords, sizeBeforeOverflow);
        Assert.assertEquals((long)(sizeAfterOverflow - sizeBeforeOverflow), (long)overflowBytesAppended);
        Assert.assertEquals((long)overflowBytesAppended, (long)overflowSegment.size());
        Utils.delete((File)tempDir);
    }

    private final void validate$1(long offset, LogSegment seg$1, MemoryRecords ms$1) {
        long x$14 = offset;
        int x$15 = 1024;
        Some x$16 = new Some((Object)BoxesRunTime.boxToLong((long)(offset + 1L)));
        long x$17 = seg$1.read$default$4();
        boolean x$18 = seg$1.read$default$5();
        Assert.assertEquals((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ms$1.records()).asScala()).filter((Function1)new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final long offset$2;

            public final boolean apply(Record x$2) {
                return x$2.offset() == this.offset$2;
            }
            {
                this.offset$2 = offset$2;
            }
        })).toList(), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(seg$1.read(x$14, (Option)x$16, x$15, x$17, x$18).records().records()).asScala()).toList());
    }

    private final MemoryRecords records$1(long offset, String record) {
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(offset * 1000L, record.getBytes())});
    }

    private final MemoryRecords records$2(long offset, int size2) {
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new byte[size2])});
    }
}

