/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import kafka.common.LogCleaningAbortedException;
import kafka.common.TopicAndPartition;
import kafka.log.Cleaner$;
import kafka.log.Cleaner$$anonfun$kafka$log$Cleaner$;
import kafka.log.CleanerStats;
import kafka.log.FileMessageSet;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleaner;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetIndex;
import kafka.log.OffsetMap;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Throttler;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005%g!C\u0001\u0003\t\u0003\u0005\t\u0011\u0001\u0002\u0007\u0005\u001d\u0019E.Z1oKJT!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b'\u0011\u0001qaD\u000b\u0011\u0005!iQ\"A\u0005\u000b\u0005)Y\u0011\u0001\u00027b]\u001eT\u0011\u0001D\u0001\u0005U\u00064\u0018-\u0003\u0002\u000f\u0013\t1qJ\u00196fGR\u0004\"\u0001E\n\u000e\u0003EQ!A\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Q\t\"a\u0002'pO\u001eLgn\u001a\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005\u001d\u0001\t\u0015\r\u0011\"\u0001\u001f\u0003\tIGm\u0001\u0001\u0016\u0003}\u0001\"A\u0006\u0011\n\u0005\u0005:\"aA%oi\"A1\u0005\u0001B\u0001B\u0003%q$A\u0002jI\u0002B\u0001\"\n\u0001\u0003\u0006\u0004%\tAJ\u0001\n_\u001a47/\u001a;NCB,\u0012a\n\t\u0003Q%j\u0011AA\u0005\u0003U\t\u0011\u0011b\u00144gg\u0016$X*\u00199\t\u00111\u0002!\u0011!Q\u0001\n\u001d\n!b\u001c4gg\u0016$X*\u00199!\u0011!q\u0003A!A!\u0002\u0013y\u0012\u0001D5p\u0005V4g-\u001a:TSj,\u0007\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\u001f5\f\u00070S8Ck\u001a4WM]*ju\u0016D\u0001B\r\u0001\u0003\u0002\u0003\u0006IaM\u0001\u0014IV\u0004()\u001e4gKJdu.\u00193GC\u000e$xN\u001d\t\u0003-QJ!!N\f\u0003\r\u0011{WO\u00197f\u0011!9\u0004A!A!\u0002\u0013A\u0014!\u0003;ie>$H\u000f\\3s!\t\u0001\u0012(\u0003\u0002;#\tIA\u000b\u001b:piRdWM\u001d\u0005\ty\u0001\u0011\t\u0011)A\u0005{\u0005!A/[7f!\t\u0001b(\u0003\u0002@#\t!A+[7f\u0011!\t\u0005A!A!\u0002\u0013\u0011\u0015!C2iK\u000e\\Gi\u001c8f!\u001112)R&\n\u0005\u0011;\"!\u0003$v]\u000e$\u0018n\u001c82!\t1\u0015*D\u0001H\u0015\tAE!\u0001\u0004d_6lwN\\\u0005\u0003\u0015\u001e\u0013\u0011\u0003V8qS\u000e\fe\u000e\u001a)beRLG/[8o!\t1B*\u0003\u0002N/\t!QK\\5u\u0011\u0015y\u0005\u0001\"\u0001Q\u0003\u0019a\u0014N\\5u}QI\u0011KU*U+Z;\u0006,\u0017\t\u0003Q\u0001AQ\u0001\b(A\u0002}AQ!\n(A\u0002\u001dBQA\f(A\u0002}AQ\u0001\r(A\u0002}AQA\r(A\u0002MBQa\u000e(A\u0002aBQ\u0001\u0010(A\u0002uBQ!\u0011(A\u0002\tCqa\u0017\u0001C\u0002\u0013\u0005C,\u0001\u0006m_\u001e<WM\u001d(b[\u0016,\u0012!\u0018\t\u0003\u0011yK!aX\u0005\u0003\rM#(/\u001b8h\u0011\u0019\t\u0007\u0001)A\u0005;\u0006YAn\\4hKJt\u0015-\\3!\u0011\u001d\u0019\u0007A1A\u0005\u0002\u0011\fqb\u001d;biN,f\u000eZ3sYfLgnZ\u000b\u0002KB!aC\u001a5i\u0013\t9wC\u0001\u0004UkBdWM\r\t\u0003Q%L!A\u001b\u0002\u0003\u0019\rcW-\u00198feN#\u0018\r^:\t\r1\u0004\u0001\u0015!\u0003f\u0003A\u0019H/\u0019;t+:$WM\u001d7zS:<\u0007\u0005C\u0003o\u0001\u0011\u0005q.A\u0003ti\u0006$8/F\u0001i\u0011\u001d\t\b\u00011A\u0005\nI\f!B]3bI\n+hMZ3s+\u0005\u0019\bC\u0001;x\u001b\u0005)(B\u0001<\f\u0003\rq\u0017n\\\u0005\u0003qV\u0014!BQ=uK\n+hMZ3s\u0011\u001dQ\b\u00011A\u0005\nm\faB]3bI\n+hMZ3s?\u0012*\u0017\u000f\u0006\u0002Ly\"9Q0_A\u0001\u0002\u0004\u0019\u0018a\u0001=%c!1q\u0010\u0001Q!\nM\f1B]3bI\n+hMZ3sA!A\u00111\u0001\u0001A\u0002\u0013%!/A\u0006xe&$XMQ;gM\u0016\u0014\b\"CA\u0004\u0001\u0001\u0007I\u0011BA\u0005\u0003=9(/\u001b;f\u0005V4g-\u001a:`I\u0015\fHcA&\u0002\f!AQ0!\u0002\u0002\u0002\u0003\u00071\u000fC\u0004\u0002\u0010\u0001\u0001\u000b\u0015B:\u0002\u0019]\u0014\u0018\u000e^3Ck\u001a4WM\u001d\u0011\t\u0011\u0005M\u0001\u0001\"\u0001\u0003\u0003+\tQa\u00197fC:$B!a\u0006\u0002\u001eA\u0019a#!\u0007\n\u0007\u0005mqC\u0001\u0003M_:<\u0007\u0002CA\u0010\u0003#\u0001\r!!\t\u0002\u0013\rdW-\u00198bE2,\u0007c\u0001\u0015\u0002$%\u0019\u0011Q\u0005\u0002\u0003\u00151{w\rV8DY\u0016\fg\u000e\u0003\u0005\u0002*\u0001!\tAAA\u0016\u00035\u0019G.Z1o'\u0016<W.\u001a8ugRI1*!\f\u00026\u0005-\u0013q\n\u0005\b\u0007\u0005\u001d\u0002\u0019AA\u0018!\rA\u0013\u0011G\u0005\u0004\u0003g\u0011!a\u0001'pO\"A\u0011qGA\u0014\u0001\u0004\tI$\u0001\u0005tK\u001elWM\u001c;t!\u0019\tY$!\u0011\u0002F5\u0011\u0011Q\b\u0006\u0004\u0003\u007f9\u0012AC2pY2,7\r^5p]&!\u00111IA\u001f\u0005\r\u0019V-\u001d\t\u0004Q\u0005\u001d\u0013bAA%\u0005\tQAj\\4TK\u001elWM\u001c;\t\u000f\u00055\u0013q\u0005a\u0001O\u0005\u0019Q.\u00199\t\u0011\u0005E\u0013q\u0005a\u0001\u0003/\tq\u0002Z3mKR,\u0007j\u001c:ju>tWj\u001d\u0005\t\u0003+\u0002A\u0011\u0001\u0002\u0002X\u0005I1\r\\3b]&sGo\u001c\u000b\f\u0017\u0006e\u0013QLA1\u0003K\n9\u0007C\u0004\u0002\\\u0005M\u0003\u0019A#\u0002#Q|\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0002`\u0005M\u0003\u0019AA#\u0003\u0019\u0019x.\u001e:dK\"A\u00111MA*\u0001\u0004\t)%\u0001\u0003eKN$\bbBA'\u0003'\u0002\ra\n\u0005\t\u0003S\n\u0019\u00061\u0001\u0002l\u0005i!/\u001a;bS:$U\r\\3uKN\u00042AFA7\u0013\r\tyg\u0006\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019\b\u0001C\u0001\u0003k\n1b\u001a:po\n+hMZ3sgR\t1\nC\u0004\u0002z\u0001!\t!!\u001e\u0002\u001dI,7\u000f^8sK\n+hMZ3sg\"A\u0011Q\u0010\u0001\u0005\u0002\t\ty(A\nhe>,\boU3h[\u0016tGo\u001d\"z'&TX\r\u0006\u0005\u0002\u0002\u0006e\u0015\u0011UAS!\u0019\t\u0019)a%\u0002:9!\u0011QQAH\u001d\u0011\t9)!$\u000e\u0005\u0005%%bAAF;\u00051AH]8pizJ\u0011\u0001G\u0005\u0004\u0003#;\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003+\u000b9J\u0001\u0003MSN$(bAAI/!A\u0011qGA>\u0001\u0004\tY\n\u0005\u0004\u0002<\u0005u\u0015QI\u0005\u0005\u0003?\u000biD\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u001d\t\u0019+a\u001fA\u0002}\tq!\\1y'&TX\rC\u0004\u0002(\u0006m\u0004\u0019A\u0010\u0002\u00195\f\u00070\u00138eKb\u001c\u0016N_3\t\u0011\u0005-\u0006\u0001\"\u0001\u0003\u0003[\u000baBY;jY\u0012|eMZ:fi6\u000b\u0007\u000f\u0006\u0006\u0002\u0018\u0005=\u0016\u0011WA[\u0003sCqaAAU\u0001\u0004\ty\u0003\u0003\u0005\u00024\u0006%\u0006\u0019AA\f\u0003\u0015\u0019H/\u0019:u\u0011!\t9,!+A\u0002\u0005]\u0011aA3oI\"9\u0011QJAU\u0001\u00049\u0003bBA_\u0001\u0011%\u0011qX\u0001\u0019EVLG\u000eZ(gMN,G/T1q\r>\u00148+Z4nK:$H\u0003CA\f\u0003\u0003\f\u0019-a2\t\u000f\u0005m\u00131\u0018a\u0001\u000b\"A\u0011QYA^\u0001\u0004\t)%A\u0004tK\u001elWM\u001c;\t\u000f\u00055\u00131\u0018a\u0001O\u0001")
public class Cleaner
implements Logging,
ScalaObject {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    public final double kafka$log$Cleaner$$dupBufferLoadFactor;
    private final Throttler throttler;
    private final Time time;
    public final Function1 kafka$log$Cleaner$$checkDone;
    private final String loggerName;
    private final Tuple2<CleanerStats, CleanerStats> statsUnderlying;
    private ByteBuffer kafka$log$Cleaner$$readBuffer;
    private ByteBuffer kafka$log$Cleaner$$writeBuffer;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Cleaner cleaner = this;
        synchronized (cleaner) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void swallowTrace(Function0 action) {
        Logging$class.swallowTrace(this, action);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void swallowDebug(Function0 action) {
        Logging$class.swallowDebug(this, action);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void swallowInfo(Function0 action) {
        Logging$class.swallowInfo(this, action);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void swallowWarn(Function0 action) {
        Logging$class.swallowWarn(this, action);
    }

    public void swallow(Function0 action) {
        Logging$class.swallow(this, action);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void swallowError(Function0 action) {
        Logging$class.swallowError(this, action);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    public Tuple2<CleanerStats, CleanerStats> statsUnderlying() {
        return this.statsUnderlying;
    }

    public CleanerStats stats() {
        return (CleanerStats)this.statsUnderlying()._1();
    }

    public final ByteBuffer kafka$log$Cleaner$$readBuffer() {
        return this.kafka$log$Cleaner$$readBuffer;
    }

    private void kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer byteBuffer) {
        this.kafka$log$Cleaner$$readBuffer = byteBuffer;
    }

    public final ByteBuffer kafka$log$Cleaner$$writeBuffer() {
        return this.kafka$log$Cleaner$$writeBuffer;
    }

    private void kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer byteBuffer) {
        this.kafka$log$Cleaner$$writeBuffer = byteBuffer;
    }

    public long clean(LogToClean cleanable$1) {
        Option option;
        block4: {
            long l;
            long endOffset;
            Log log$2;
            block3: {
                block2: {
                    this.stats().clear();
                    this.info((Function0<String>)new $anonfun$clean$1(this, cleanable$1));
                    log$2 = cleanable$1.log();
                    this.info((Function0<String>)new $anonfun$clean$2(this, cleanable$1));
                    long upperBoundOffset = log$2.activeSegment().baseOffset();
                    endOffset = this.buildOffsetMap(log$2, cleanable$1.firstDirtyOffset(), upperBoundOffset, this.offsetMap()) + 1L;
                    this.stats().indexDone();
                    option = log$2.logSegments(0L, cleanable$1.firstDirtyOffset()).lastOption();
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                    l = 0L;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                l = ((LogSegment)((Some)option).x()).lastModified() - log$2.config().deleteRetentionMs();
            }
            long deleteHorizonMs$1 = l;
            this.info((Function0<String>)new $anonfun$clean$3(this, log$2, deleteHorizonMs$1));
            this.groupSegmentsBySize(log$2.logSegments(0L, endOffset), log$2.config().segmentSize(), log$2.config().maxIndexSize()).foreach((Function1)new $anonfun$clean$4(this, log$2, deleteHorizonMs$1));
            this.stats().bufferUtilization_$eq(this.offsetMap().utilization());
            this.stats().allDone();
            return endOffset;
        }
        throw new MatchError((Object)option);
    }

    public void cleanSegments(Log log$4, Seq<LogSegment> segments$1, OffsetMap map$2, long deleteHorizonMs$2) {
        File logFile = new File(new StringBuilder().append((Object)((LogSegment)segments$1.head()).log().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        logFile.delete();
        File indexFile = new File(new StringBuilder().append((Object)((LogSegment)segments$1.head()).index().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        indexFile.delete();
        FileMessageSet messages = new FileMessageSet(logFile);
        OffsetIndex index = new OffsetIndex(indexFile, ((LogSegment)segments$1.head()).baseOffset(), ((LogSegment)segments$1.head()).index().maxIndexSize());
        LogSegment cleaned$1 = new LogSegment(messages, index, ((LogSegment)segments$1.head()).baseOffset(), ((LogSegment)segments$1.head()).indexIntervalBytes(), this.time);
        try {
            segments$1.foreach((Function1)new $anonfun$cleanSegments$1(this, log$4, map$2, deleteHorizonMs$2, cleaned$1));
            index.trimToValidSize();
            cleaned$1.flush();
            long modified = ((LogSegment)segments$1.last()).lastModified();
            cleaned$1.lastModified_$eq(modified);
            this.info((Function0<String>)new $anonfun$cleanSegments$2(this, log$4, segments$1, cleaned$1));
            log$4.replaceSegments(cleaned$1, segments$1);
            return;
        }
        catch (LogCleaningAbortedException logCleaningAbortedException) {
            cleaned$1.delete();
            throw logCleaningAbortedException;
        }
    }

    public void cleanInto(TopicAndPartition topicAndPartition, LogSegment source$1, LogSegment dest, OffsetMap map$3, boolean retainDeletes$2) {
        IntRef position$1 = new IntRef(0);
        while (position$1.elem < source$1.log().sizeInBytes()) {
            this.kafka$log$Cleaner$$checkDone.apply((Object)topicAndPartition);
            this.kafka$log$Cleaner$$readBuffer().clear();
            this.kafka$log$Cleaner$$writeBuffer().clear();
            ByteBufferMessageSet messages = new ByteBufferMessageSet(source$1.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position$1.elem));
            this.throttler.maybeThrottle(messages.sizeInBytes());
            IntRef messagesRead$1 = new IntRef(0);
            messages.foreach((Function1)new $anonfun$cleanInto$1(this, source$1, map$3, retainDeletes$2, position$1, messagesRead$1));
            if (this.kafka$log$Cleaner$$writeBuffer().position() > 0) {
                this.kafka$log$Cleaner$$writeBuffer().flip();
                ByteBufferMessageSet retained = new ByteBufferMessageSet(this.kafka$log$Cleaner$$writeBuffer());
                dest.append(((MessageAndOffset)retained.head()).offset(), retained);
                this.throttler.maybeThrottle(this.kafka$log$Cleaner$$writeBuffer().limit());
            }
            if (this.kafka$log$Cleaner$$readBuffer().limit() <= 0 || messagesRead$1.elem != 0) continue;
            this.growBuffers();
        }
        this.restoreBuffers();
    }

    public void growBuffers() {
        if (this.kafka$log$Cleaner$$readBuffer().capacity() >= this.maxIoBufferSize || this.kafka$log$Cleaner$$writeBuffer().capacity() >= this.maxIoBufferSize) {
            throw new IllegalStateException(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxIoBufferSize)})));
        }
        int newSize$1 = package$.MODULE$.min(this.kafka$log$Cleaner$$readBuffer().capacity() * 2, this.maxIoBufferSize);
        this.info((Function0<String>)new $anonfun$growBuffers$1(this, newSize$1));
        this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(newSize$1));
        this.kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer.allocate(newSize$1));
    }

    public void restoreBuffers() {
        if (this.kafka$log$Cleaner$$readBuffer().capacity() > this.ioBufferSize) {
            this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
        if (this.kafka$log$Cleaner$$writeBuffer().capacity() > this.ioBufferSize) {
            this.kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize) {
        Nil$ grouped = Nil$.MODULE$;
        List segs = segments.toList();
        while (!segs.isEmpty()) {
            List group = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)segs.head()}));
            long logSize = ((LogSegment)segs.head()).size();
            int indexSize = ((LogSegment)segs.head()).index().sizeInBytes();
            segs = (List)segs.tail();
            while (!segs.isEmpty() && logSize + ((LogSegment)segs.head()).size() < (long)maxSize && indexSize + ((LogSegment)segs.head()).index().sizeInBytes() < maxIndexSize) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon((Object)logSegment);
                logSize += ((LogSegment)segs.head()).size();
                indexSize += ((LogSegment)segs.head()).index().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped = grouped.$colon$colon((Object)group.reverse());
        }
        return grouped.reverse();
    }

    public long buildOffsetMap(Log log$3, long start$1, long end$1, OffsetMap map$1) {
        map$1.clear();
        Seq dirty$1 = log$3.logSegments(start$1, end$1).toSeq();
        this.info((Function0<String>)new $anonfun$buildOffsetMap$1(this, log$3, start$1, end$1, dirty$1));
        LongRef offset$1 = new LongRef(((LogSegment)dirty$1.head()).baseOffset());
        Predef$.MODULE$.require(offset$1.elem == start$1, (Function0)new $anonfun$buildOffsetMap$2(this, log$3, start$1, offset$1));
        long minStopOffset$1 = (long)((double)start$1 + (double)map$1.slots() * this.kafka$log$Cleaner$$dupBufferLoadFactor);
        dirty$1.foreach((Function1)new $anonfun$buildOffsetMap$3(this, log$3, map$1, offset$1, minStopOffset$1));
        this.info((Function0<String>)new $anonfun$buildOffsetMap$4(this, log$3));
        return offset$1.elem;
    }

    public final long kafka$log$Cleaner$$buildOffsetMapForSegment(TopicAndPartition topicAndPartition, LogSegment segment, OffsetMap map$4) {
        IntRef position$2 = new IntRef(0);
        LongRef offset$2 = new LongRef(segment.baseOffset());
        while (position$2.elem < segment.log().sizeInBytes()) {
            this.kafka$log$Cleaner$$checkDone.apply((Object)topicAndPartition);
            this.kafka$log$Cleaner$$readBuffer().clear();
            ByteBufferMessageSet messages = new ByteBufferMessageSet(segment.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position$2.elem));
            this.throttler.maybeThrottle(messages.sizeInBytes());
            int startPosition = position$2.elem;
            messages.foreach((Function1)new $anonfun$kafka$log$Cleaner$$buildOffsetMapForSegment$1(this, map$4, position$2, offset$2));
            if (position$2.elem != startPosition) continue;
            this.growBuffers();
        }
        this.restoreBuffers();
        return offset$2.elem;
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicAndPartition, Object> checkDone) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.kafka$log$Cleaner$$dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.time = time;
        this.kafka$log$Cleaner$$checkDone = checkDone;
        Logging$class.$init$(this);
        this.loggerName = LogCleaner.class.getName();
        this.logIdent_$eq(new StringBuilder().append((Object)"Cleaner ").append((Object)BoxesRunTime.boxToInteger((int)id)).append((Object)": ").toString());
        this.statsUnderlying = new Tuple2((Object)new CleanerStats(time), (Object)new CleanerStats(time));
        this.kafka$log$Cleaner$$readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.kafka$log$Cleaner$$writeBuffer = ByteBuffer.allocate(ioBufferSize);
    }
}

