/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.api.TopicMetadataResponse;
import kafka.client.ClientUtils$;
import kafka.cluster.Broker;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig$;
import kafka.consumer.Whitelist;
import kafka.tools.ReplicaBuffer;
import kafka.tools.ReplicaVerificationTool$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.mutable.StringBuilder;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ReplicaVerificationTool$
implements Logging,
ScalaObject {
    public static final ReplicaVerificationTool$ MODULE$;
    private final String clientId;
    private final String dateFormatString;
    private final SimpleDateFormat dateFormat;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ReplicaVerificationTool$();
    }

    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ReplicaVerificationTool$ replicaVerificationTool$ = this;
        synchronized (replicaVerificationTool$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void swallowTrace(Function0 action) {
        Logging$class.swallowTrace(this, action);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void swallowDebug(Function0 action) {
        Logging$class.swallowDebug(this, action);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void swallowInfo(Function0 action) {
        Logging$class.swallowInfo(this, action);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void swallowWarn(Function0 action) {
        Logging$class.swallowWarn(this, action);
    }

    public void swallow(Function0 action) {
        Logging$class.swallow(this, action);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void swallowError(Function0 action) {
        Logging$class.swallowError(this, action);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public String clientId() {
        return this.clientId;
    }

    public String dateFormatString() {
        return this.dateFormatString;
    }

    public SimpleDateFormat dateFormat() {
        return this.dateFormat;
    }

    public String getCurrentTimeString() {
        return this.dateFormat().format(new Date(SystemTime$.MODULE$.milliseconds()));
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec fetchSizeOpt = parser.accepts("fetch-size", "The fetch size of each request.").withRequiredArg().describedAs("bytes").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(ConsumerConfig$.MODULE$.FetchSize()), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec maxWaitMsOpt = parser.accepts("max-wait-ms", "The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec topicWhiteListOpt = parser.accepts("topic-white-list", "White list of topics to verify replica consistency. Defaults to all topics.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class).defaultsTo((Object)".*", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec initialOffsetTimeOpt = parser.accepts("time", "Timestamp for getting the initial offsets.").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(-1L), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec reportIntervalOpt = parser.accepts("report-interval-ms", "The reporting interval.").withRequiredArg().describedAs("ms").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(30000L), (Object[])new Long[0]);
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerListOpt}));
        String regex = (String)options.valueOf((OptionSpec)topicWhiteListOpt);
        Whitelist topicWhiteListFiler$1 = new Whitelist(regex);
        Pattern exceptionResult1 = null;
        try {
            exceptionResult1 = Pattern.compile(regex);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new RuntimeException(new StringBuilder().append((Object)regex).append((Object)" is an invalid regex.").toString());
        }
        int fetchSize$1 = (Integer)options.valueOf((OptionSpec)fetchSizeOpt);
        int maxWaitMs$1 = (Integer)options.valueOf((OptionSpec)maxWaitMsOpt);
        long initialOffsetTime = (Long)options.valueOf((OptionSpec)initialOffsetTimeOpt);
        long reportInterval = (Long)options.valueOf((OptionSpec)reportIntervalOpt);
        this.info((Function0<String>)new anonfun.main.1());
        Seq<Broker> metadataTargetBrokers = ClientUtils$.MODULE$.parseBrokerList((String)options.valueOf((OptionSpec)brokerListOpt));
        TopicMetadataResponse topicsMetadataResponse = ClientUtils$.MODULE$.fetchTopicMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))), metadataTargetBrokers, this.clientId(), maxWaitMs$1, ClientUtils$.MODULE$.fetchTopicMetadata$default$5());
        Map<Integer, Broker> brokerMap$1 = topicsMetadataResponse.extractBrokers(topicsMetadataResponse.topicsMetadata());
        Seq filteredTopicMetadata = (Seq)topicsMetadataResponse.topicsMetadata().filter((Function1)new anonfun.1(topicWhiteListFiler$1));
        Seq topicPartitionReplicaList$1 = (Seq)filteredTopicMetadata.flatMap((Function1)new anonfun.2(), Seq$.MODULE$.canBuildFrom());
        this.debug((Function0<String>)new anonfun.main.2(topicPartitionReplicaList$1));
        Map topicAndPartitionsPerBroker$1 = (Map)topicPartitionReplicaList$1.groupBy((Function1)new anonfun.3()).map((Function1)new anonfun.4(), Map$.MODULE$.canBuildFrom());
        this.debug((Function0<String>)new anonfun.main.3(topicAndPartitionsPerBroker$1));
        Map expectedReplicasPerTopicAndPartition$1 = (Map)topicPartitionReplicaList$1.groupBy((Function1)new anonfun.5()).map((Function1)new anonfun.6(), Map$.MODULE$.canBuildFrom());
        this.debug((Function0<String>)new anonfun.main.4(expectedReplicasPerTopicAndPartition$1));
        Map leadersPerBroker$1 = ((TraversableLike)filteredTopicMetadata.flatMap((Function1)new anonfun.7(), Seq$.MODULE$.canBuildFrom())).groupBy((Function1)new anonfun.8()).mapValues((Function1)new anonfun.9());
        this.debug((Function0<String>)new anonfun.main.5(leadersPerBroker$1));
        ReplicaBuffer replicaBuffer$1 = new ReplicaBuffer((Map<TopicAndPartition, Integer>)expectedReplicasPerTopicAndPartition$1, (Map<Integer, Seq<TopicAndPartition>>)leadersPerBroker$1, topicAndPartitionsPerBroker$1.size(), brokerMap$1, initialOffsetTime, reportInterval);
        int verificationBrokerId$1 = ((Tuple2)topicAndPartitionsPerBroker$1.head())._1$mcI$sp();
        Iterable fetcherThreads$1 = (Iterable)topicAndPartitionsPerBroker$1.map((Function1)new anonfun.10(fetchSize$1, maxWaitMs$1, brokerMap$1, replicaBuffer$1, verificationBrokerId$1), Iterable$.MODULE$.canBuildFrom());
        Runtime.getRuntime().addShutdownHook(new anon.1(fetcherThreads$1));
        fetcherThreads$1.foreach((Function1)new anonfun.main.6());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)this.getCurrentTimeString()).append((Object)": verification process is started.").toString());
    }

    private ReplicaVerificationTool$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.clientId = "replicaVerificationTool";
        this.dateFormatString = "yyyy-MM-dd HH:mm:ss,SSS";
        this.dateFormat = new SimpleDateFormat(this.dateFormatString());
    }
}

