/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.deltalengthbytearray;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.parquet.Log;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.CapacityByteArrayOutputStream;
import org.apache.parquet.bytes.LittleEndianDataOutputStream;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.column.values.delta.DeltaBinaryPackingValuesWriterForInteger;
import org.apache.parquet.io.ParquetEncodingException;
import org.apache.parquet.io.api.Binary;

public class DeltaLengthByteArrayValuesWriter
extends ValuesWriter {
    private static final Log LOG = Log.getLog(DeltaLengthByteArrayValuesWriter.class);
    private ValuesWriter lengthWriter;
    private CapacityByteArrayOutputStream arrayOut;
    private LittleEndianDataOutputStream out;

    public DeltaLengthByteArrayValuesWriter(int initialSize, int pageSize, ByteBufferAllocator allocator) {
        this.arrayOut = new CapacityByteArrayOutputStream(initialSize, pageSize, allocator);
        this.out = new LittleEndianDataOutputStream((OutputStream)this.arrayOut);
        this.lengthWriter = new DeltaBinaryPackingValuesWriterForInteger(128, 4, initialSize, pageSize, allocator);
    }

    @Override
    public void writeBytes(Binary v) {
        try {
            this.lengthWriter.writeInteger(v.length());
            v.writeTo((OutputStream)this.out);
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write bytes", e);
        }
    }

    @Override
    public long getBufferedSize() {
        return this.lengthWriter.getBufferedSize() + this.arrayOut.size();
    }

    @Override
    public BytesInput getBytes() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write page", e);
        }
        if (Log.DEBUG) {
            LOG.debug((Object)("writing a buffer of size " + this.arrayOut.size()));
        }
        return BytesInput.concat((BytesInput[])new BytesInput[]{this.lengthWriter.getBytes(), BytesInput.from((CapacityByteArrayOutputStream)this.arrayOut)});
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.DELTA_LENGTH_BYTE_ARRAY;
    }

    @Override
    public void reset() {
        this.lengthWriter.reset();
        this.arrayOut.reset();
    }

    @Override
    public void close() {
        this.lengthWriter.close();
        this.arrayOut.close();
    }

    @Override
    public long getAllocatedSize() {
        return this.lengthWriter.getAllocatedSize() + (long)this.arrayOut.getCapacity();
    }

    @Override
    public String memUsageString(String prefix) {
        return this.arrayOut.memUsageString(this.lengthWriter.memUsageString(prefix) + " DELTA_LENGTH_BYTE_ARRAY");
    }
}

