/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import org.apache.qpid.QpidException;
import org.apache.qpid.client.message.AMQMessageDelegate;
import org.apache.qpid.client.message.AMQMessageDelegateFactory;
import org.apache.qpid.client.message.JMSStreamMessage;
import org.apache.qpid.client.util.JMSExceptionHelper;
import org.apache.qpid.jms.ListMessage;
import org.apache.qpid.transport.codec.BBDecoder;
import org.apache.qpid.transport.codec.BBEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPEncodedListMessage
extends JMSStreamMessage
implements ListMessage,
MapMessage {
    private static final Logger _logger = LoggerFactory.getLogger(AMQPEncodedListMessage.class);
    public static final String MIME_TYPE = "amqp/list";
    private List<Object> _list = new ArrayList<Object>();
    private int currentIndex;
    private static final String MESSAGE_EOF_EXCEPTION = "End of Stream (ListMessage) at index: ";

    public AMQPEncodedListMessage(AMQMessageDelegateFactory delegateFactory) throws JMSException {
        super(delegateFactory);
        this.currentIndex = 0;
    }

    AMQPEncodedListMessage(AMQMessageDelegate delegate, ByteBuffer data) throws QpidException {
        super(delegate, data);
        if (data != null) {
            try {
                this.populateListFromData(data);
            }
            catch (JMSException je) {
                throw new QpidException("Error populating ListMessage from ByteBuffer", (Throwable)je);
            }
        }
        this.currentIndex = 0;
    }

    @Override
    public String toBodyString() throws JMSException {
        return this._list == null ? "" : this._list.toString();
    }

    @Override
    protected String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public boolean add(Object a) throws JMSException {
        this.checkWritable();
        this.checkAllowedValue(a);
        try {
            return this._list.add(a);
        }
        catch (Exception e) {
            throw JMSExceptionHelper.chainJMSException((JMSException)new MessageFormatException("Error adding to ListMessage"), e);
        }
    }

    @Override
    public void add(int index, Object element) throws JMSException {
        this.checkWritable();
        this.checkAllowedValue(element);
        try {
            this._list.add(index, element);
        }
        catch (Exception e) {
            throw JMSExceptionHelper.chainJMSException((JMSException)new MessageFormatException("Error adding to ListMessage at " + index), e);
        }
    }

    @Override
    public boolean contains(Object o) throws JMSException {
        try {
            return this._list.contains(o);
        }
        catch (Exception e) {
            throw JMSExceptionHelper.chainJMSException(new JMSException("Error when looking up object"), e);
        }
    }

    @Override
    public Object get(int index) throws JMSException {
        try {
            return this._list.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw JMSExceptionHelper.chainJMSException((JMSException)new MessageFormatException("Error getting ListMessage element at " + index), e);
        }
    }

    @Override
    public int indexOf(Object o) {
        return this._list.indexOf(o);
    }

    public Iterator iterator() {
        return this._list.iterator();
    }

    @Override
    public Object remove(int index) throws JMSException {
        this.checkWritable();
        try {
            return this._list.remove(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw JMSExceptionHelper.chainJMSException((JMSException)new MessageFormatException("Error removing ListMessage element at " + index), e);
        }
    }

    @Override
    public boolean remove(Object o) throws JMSException {
        this.checkWritable();
        return this._list.remove(o);
    }

    @Override
    public Object set(int index, Object element) throws JMSException {
        this.checkWritable();
        this.checkAllowedValue(element);
        try {
            return this._list.set(index, element);
        }
        catch (Exception e) {
            throw JMSExceptionHelper.chainJMSException((JMSException)new MessageFormatException("Error setting ListMessage element at " + index), e);
        }
    }

    @Override
    public int size() {
        return this._list.size();
    }

    @Override
    public Object[] toArray() {
        return this._list.toArray();
    }

    private boolean isValidIndex(int index) {
        return index >= 0 && index < this.size();
    }

    private int getValidIndex(String indexStr) throws JMSException {
        if (indexStr == null || indexStr.equals("")) {
            throw new IllegalArgumentException("Property name cannot be null, or the empty String.");
        }
        int index = 0;
        try {
            index = Integer.parseInt(indexStr);
        }
        catch (NumberFormatException e) {
            throw JMSExceptionHelper.chainJMSException(new JMSException("Invalid index string"), e);
        }
        if (this.isValidIndex(index)) {
            return index;
        }
        throw new MessageFormatException("Property " + indexStr + " should be a valid index into the list of size " + this.size());
    }

    private void setGenericForMap(String propName, Object o) throws JMSException {
        this.checkWritable();
        int index = 0;
        try {
            index = Integer.parseInt(propName);
        }
        catch (NumberFormatException e) {
            throw JMSExceptionHelper.chainJMSException(new JMSException("The property name should be a valid index"), e);
        }
        if (this.isValidIndex(index)) {
            this.remove(index);
        }
        this.add(index, o);
    }

    public boolean getBoolean(String propName) throws JMSException {
        return this.getBooleanImpl(this.getValidIndex(propName));
    }

    public byte getByte(String propName) throws JMSException {
        return this.getByteImpl(this.getValidIndex(propName));
    }

    public short getShort(String propName) throws JMSException {
        return this.getShortImpl(this.getValidIndex(propName));
    }

    public int getInt(String propName) throws JMSException {
        return this.getIntImpl(this.getValidIndex(propName));
    }

    public long getLong(String propName) throws JMSException {
        return this.getLongImpl(this.getValidIndex(propName));
    }

    public char getChar(String propName) throws JMSException {
        return this.getCharImpl(this.getValidIndex(propName));
    }

    public float getFloat(String propName) throws JMSException {
        return this.getFloatImpl(this.getValidIndex(propName));
    }

    public double getDouble(String propName) throws JMSException {
        return this.getDoubleImpl(this.getValidIndex(propName));
    }

    public String getString(String propName) throws JMSException {
        return this.getStringImpl(this.getValidIndex(propName));
    }

    public byte[] getBytes(String propName) throws JMSException {
        return this.getBytesImpl(this.getValidIndex(propName));
    }

    public Object getObject(String propName) throws JMSException {
        return this.get(this.getValidIndex(propName));
    }

    public Enumeration getMapNames() throws JMSException {
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < this.size()) {
            names.add(Integer.toString(i++));
        }
        return Collections.enumeration(names);
    }

    public void setBoolean(String propName, boolean b) throws JMSException {
        this.setGenericForMap(propName, b);
    }

    public void setByte(String propName, byte b) throws JMSException {
        this.setGenericForMap(propName, b);
    }

    public void setShort(String propName, short i) throws JMSException {
        this.setGenericForMap(propName, i);
    }

    public void setChar(String propName, char c) throws JMSException {
        this.setGenericForMap(propName, Character.valueOf(c));
    }

    public void setInt(String propName, int i) throws JMSException {
        this.setGenericForMap(propName, i);
    }

    public void setLong(String propName, long l) throws JMSException {
        this.setGenericForMap(propName, l);
    }

    public void setFloat(String propName, float v) throws JMSException {
        this.setGenericForMap(propName, Float.valueOf(v));
    }

    public void setDouble(String propName, double v) throws JMSException {
        this.setGenericForMap(propName, v);
    }

    public void setString(String propName, String string1) throws JMSException {
        this.setGenericForMap(propName, string1);
    }

    public void setBytes(String propName, byte[] bytes) throws JMSException {
        this.setGenericForMap(propName, bytes);
    }

    public void setBytes(String propName, byte[] bytes, int offset, int length) throws JMSException {
        if (offset == 0 && length == bytes.length) {
            this.setBytes(propName, bytes);
        } else {
            byte[] newBytes = new byte[length];
            System.arraycopy(bytes, offset, newBytes, 0, length);
            this.setBytes(propName, newBytes);
        }
    }

    public void setObject(String propName, Object value) throws JMSException {
        this.checkAllowedValue(value);
        this.setGenericForMap(propName, value);
    }

    public boolean itemExists(String propName) throws JMSException {
        return this.isValidIndex(Integer.parseInt(propName));
    }

    private void setGenericForStream(Object o) throws JMSException {
        this.checkWritable();
        this.add(o);
        ++this.currentIndex;
    }

    @Override
    public boolean readBoolean() throws JMSException {
        this.checkReadable();
        if (this.isValidIndex(this.currentIndex)) {
            return this.getBooleanImpl(this.currentIndex++);
        }
        throw new MessageEOFException(MESSAGE_EOF_EXCEPTION + this.currentIndex);
    }

    @Override
    public byte readByte() throws JMSException {
        this.checkReadable();
        if (this.isValidIndex(this.currentIndex)) {
            return this.getByteImpl(this.currentIndex++);
        }
        throw new MessageEOFException(MESSAGE_EOF_EXCEPTION + this.currentIndex);
    }

    @Override
    public int readBytes(byte[] value) throws JMSException {
        this.checkReadable();
        if (this.isValidIndex(this.currentIndex)) {
            ByteBuffer res = ByteBuffer.wrap(this.getBytesImpl(this.currentIndex++));
            res.get(value);
            return value.length;
        }
        throw new MessageEOFException(MESSAGE_EOF_EXCEPTION + this.currentIndex);
    }

    @Override
    public char readChar() throws JMSException {
        this.checkReadable();
        if (this.isValidIndex(this.currentIndex)) {
            return this.getCharImpl(this.currentIndex++);
        }
        throw new MessageEOFException(MESSAGE_EOF_EXCEPTION + this.currentIndex);
    }

    @Override
    public double readDouble() throws JMSException {
        this.checkReadable();
        if (this.isValidIndex(this.currentIndex)) {
            return this.getDoubleImpl(this.currentIndex++);
        }
        throw new MessageEOFException(MESSAGE_EOF_EXCEPTION + this.currentIndex);
    }

    @Override
    public float readFloat() throws JMSException {
        this.checkReadable();
        if (this.isValidIndex(this.currentIndex)) {
            return this.getFloatImpl(this.currentIndex++);
        }
        throw new MessageEOFException(MESSAGE_EOF_EXCEPTION + this.currentIndex);
    }

    @Override
    public int readInt() throws JMSException {
        this.checkReadable();
        if (this.isValidIndex(this.currentIndex)) {
            return this.getIntImpl(this.currentIndex++);
        }
        throw new MessageEOFException(MESSAGE_EOF_EXCEPTION + this.currentIndex);
    }

    @Override
    public long readLong() throws JMSException {
        this.checkReadable();
        if (this.isValidIndex(this.currentIndex)) {
            return this.getLongImpl(this.currentIndex++);
        }
        throw new MessageEOFException(MESSAGE_EOF_EXCEPTION + this.currentIndex);
    }

    @Override
    public Object readObject() throws JMSException {
        this.checkReadable();
        if (this.isValidIndex(this.currentIndex)) {
            return this.get(this.currentIndex++);
        }
        throw new MessageEOFException(MESSAGE_EOF_EXCEPTION + this.currentIndex);
    }

    @Override
    public short readShort() throws JMSException {
        this.checkReadable();
        if (this.isValidIndex(this.currentIndex)) {
            return this.getShortImpl(this.currentIndex++);
        }
        throw new MessageEOFException(MESSAGE_EOF_EXCEPTION + this.currentIndex);
    }

    @Override
    public String readString() throws JMSException {
        this.checkReadable();
        if (this.isValidIndex(this.currentIndex)) {
            return this.getStringImpl(this.currentIndex++);
        }
        throw new MessageEOFException(MESSAGE_EOF_EXCEPTION + this.currentIndex);
    }

    @Override
    public void writeBoolean(boolean value) throws JMSException {
        this.setGenericForStream(value);
    }

    @Override
    public void writeByte(byte value) throws JMSException {
        this.setGenericForStream(value);
    }

    @Override
    public void writeBytes(byte[] value) throws JMSException {
        this.setGenericForStream(value);
    }

    @Override
    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.setGenericForStream(value);
    }

    @Override
    public void writeChar(char value) throws JMSException {
        this.setGenericForStream(Character.valueOf(value));
    }

    @Override
    public void writeDouble(double value) throws JMSException {
        this.setGenericForStream(value);
    }

    @Override
    public void writeFloat(float value) throws JMSException {
        this.setGenericForStream(Float.valueOf(value));
    }

    @Override
    public void writeInt(int value) throws JMSException {
        this.setGenericForStream(value);
    }

    @Override
    public void writeLong(long value) throws JMSException {
        this.setGenericForStream(value);
    }

    @Override
    public void writeObject(Object value) throws JMSException {
        this.checkAllowedValue(value);
        this.setGenericForStream(value);
    }

    @Override
    public void writeShort(short value) throws JMSException {
        this.setGenericForStream(value);
    }

    @Override
    public void writeString(String value) throws JMSException {
        this.setGenericForStream(value);
    }

    private void checkAllowedValue(Object value) throws MessageFormatException {
        if (!(value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Character || value instanceof Float || value instanceof Double || value instanceof String || value instanceof byte[] || value instanceof List || value instanceof Map || value instanceof UUID || value == null)) {
            throw new MessageFormatException("Invalid value " + value + "of type " + value.getClass().getName() + ".");
        }
    }

    @Override
    public void reset() {
        this.currentIndex = 0;
        this.setReadable(true);
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this._list.clear();
        this.currentIndex = 0;
        this.setReadable(false);
    }

    private boolean getBooleanImpl(int index) throws JMSException {
        Object value = this.get(index);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String || value == null) {
            try {
                return Boolean.valueOf((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new MessageFormatException("Property at " + index + " of type " + value.getClass().getName() + " cannot be converted to boolean.");
    }

    private byte getByteImpl(int index) throws JMSException {
        Object value = this.get(index);
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String || value == null) {
            try {
                return Byte.valueOf((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new MessageFormatException("Property at " + index + " of type " + value.getClass().getName() + " cannot be converted to byte.");
    }

    private short getShortImpl(int index) throws JMSException {
        Object value = this.get(index);
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Byte) {
            return ((Byte)value).shortValue();
        }
        if (value instanceof String || value == null) {
            try {
                return Short.valueOf((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new MessageFormatException("Property at " + index + " of type " + value.getClass().getName() + " cannot be converted to short.");
    }

    private int getIntImpl(int index) throws JMSException {
        Object value = this.get(index);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        if (value instanceof String || value == null) {
            try {
                return Integer.valueOf((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new MessageFormatException("Property at " + index + " of type " + value.getClass().getName() + " cannot be converted to int.");
    }

    private long getLongImpl(int index) throws JMSException {
        Object value = this.get(index);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).longValue();
        }
        if (value instanceof String || value == null) {
            try {
                return Long.valueOf((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new MessageFormatException("Property at " + index + " of type " + value.getClass().getName() + " cannot be converted to long.");
    }

    private char getCharImpl(int index) throws JMSException {
        Object value = this.get(index);
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value == null) {
            throw new NullPointerException("Property at " + index + " has null value and therefore cannot " + "be converted to char.");
        }
        throw new MessageFormatException("Property at " + index + " of type " + value.getClass().getName() + " cannot be converted to a char.");
    }

    private float getFloatImpl(int index) throws JMSException {
        Object value = this.get(index);
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String || value == null) {
            try {
                return Float.valueOf((String)value).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new MessageFormatException("Property at " + index + " of type " + value.getClass().getName() + " cannot be converted to float.");
    }

    private double getDoubleImpl(int index) throws JMSException {
        Object value = this.get(index);
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof String || value == null) {
            try {
                return Double.valueOf((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new MessageFormatException("Property at " + index + " of type " + value.getClass().getName() + " cannot be converted to double.");
    }

    private String getStringImpl(int index) throws JMSException {
        Object value = this.get(index);
        if (value instanceof String || value == null) {
            return (String)value;
        }
        if (value instanceof byte[]) {
            throw new MessageFormatException("Property at " + index + " of type byte[] " + "cannot be converted to String.");
        }
        return value.toString();
    }

    private byte[] getBytesImpl(int index) throws JMSException {
        Object value = this.get(index);
        if (value instanceof byte[] || value == null) {
            return (byte[])value;
        }
        throw new MessageFormatException("Property at " + index + " of type " + value.getClass().getName() + " cannot be converted to byte[].");
    }

    protected void populateListFromData(ByteBuffer data) throws JMSException {
        if (data != null) {
            data.rewind();
            BBDecoder decoder = new BBDecoder();
            decoder.init(data);
            this._list = decoder.readList();
        } else {
            this._list.clear();
        }
    }

    @Override
    public ByteBuffer getData() throws JMSException {
        BBEncoder encoder = new BBEncoder(1024);
        encoder.writeList(this._list);
        return encoder.segment();
    }

    @Override
    public void setList(List<Object> l) {
        this._list = l;
    }

    @Override
    public List<Object> asList() {
        return this._list;
    }
}

