/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.masterslave.route.engine;

import java.util.Collections;
import java.util.LinkedList;
import org.apache.shardingsphere.core.rule.MasterSlaveRule;
import org.apache.shardingsphere.masterslave.route.engine.impl.MasterSlaveDataSourceRouter;
import org.apache.shardingsphere.underlying.common.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.underlying.common.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.underlying.route.context.RouteContext;
import org.apache.shardingsphere.underlying.route.context.RouteMapper;
import org.apache.shardingsphere.underlying.route.context.RouteResult;
import org.apache.shardingsphere.underlying.route.context.RouteUnit;
import org.apache.shardingsphere.underlying.route.decorator.RouteDecorator;

public final class MasterSlaveRouteDecorator
implements RouteDecorator<MasterSlaveRule> {
    public RouteContext decorate(RouteContext routeContext, ShardingSphereMetaData metaData, MasterSlaveRule masterSlaveRule, ConfigurationProperties properties) {
        if (routeContext.getRouteResult().getRouteUnits().isEmpty()) {
            String dataSourceName = new MasterSlaveDataSourceRouter(masterSlaveRule).route(routeContext.getSqlStatementContext().getSqlStatement());
            RouteResult routeResult = new RouteResult();
            routeResult.getRouteUnits().add(new RouteUnit(new RouteMapper(dataSourceName, dataSourceName), Collections.emptyList()));
            return new RouteContext(routeContext.getSqlStatementContext(), Collections.emptyList(), routeResult);
        }
        LinkedList<RouteUnit> toBeRemoved = new LinkedList<RouteUnit>();
        LinkedList<RouteUnit> toBeAdded = new LinkedList<RouteUnit>();
        for (RouteUnit each : routeContext.getRouteResult().getRouteUnits()) {
            if (!masterSlaveRule.getName().equalsIgnoreCase(each.getDataSourceMapper().getActualName())) continue;
            toBeRemoved.add(each);
            String actualDataSourceName = new MasterSlaveDataSourceRouter(masterSlaveRule).route(routeContext.getSqlStatementContext().getSqlStatement());
            toBeAdded.add(new RouteUnit(new RouteMapper(each.getDataSourceMapper().getLogicName(), actualDataSourceName), each.getTableMappers()));
        }
        routeContext.getRouteResult().getRouteUnits().removeAll(toBeRemoved);
        routeContext.getRouteResult().getRouteUnits().addAll(toBeAdded);
        return routeContext;
    }

    public int getOrder() {
        return 10;
    }

    public Class<MasterSlaveRule> getType() {
        return MasterSlaveRule.class;
    }
}

