/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.api.config.sharding;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.shardingsphere.api.config.sharding.KeyGeneratorConfiguration;
import org.apache.shardingsphere.api.config.sharding.strategy.ShardingStrategyConfiguration;

public final class TableRuleConfiguration {
    private final String logicTable;
    private final String actualDataNodes;
    private ShardingStrategyConfiguration databaseShardingStrategyConfig;
    private ShardingStrategyConfiguration tableShardingStrategyConfig;
    private KeyGeneratorConfiguration keyGeneratorConfig;

    public TableRuleConfiguration(String logicTable) {
        this(logicTable, null);
    }

    public TableRuleConfiguration(String logicTable, String actualDataNodes) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)logicTable) ? 1 : 0) != 0, (Object)"LogicTable is required.");
        this.logicTable = logicTable;
        this.actualDataNodes = actualDataNodes;
    }

    public String getLogicTable() {
        return this.logicTable;
    }

    public String getActualDataNodes() {
        return this.actualDataNodes;
    }

    public ShardingStrategyConfiguration getDatabaseShardingStrategyConfig() {
        return this.databaseShardingStrategyConfig;
    }

    public ShardingStrategyConfiguration getTableShardingStrategyConfig() {
        return this.tableShardingStrategyConfig;
    }

    public KeyGeneratorConfiguration getKeyGeneratorConfig() {
        return this.keyGeneratorConfig;
    }

    public void setDatabaseShardingStrategyConfig(ShardingStrategyConfiguration databaseShardingStrategyConfig) {
        this.databaseShardingStrategyConfig = databaseShardingStrategyConfig;
    }

    public void setTableShardingStrategyConfig(ShardingStrategyConfiguration tableShardingStrategyConfig) {
        this.tableShardingStrategyConfig = tableShardingStrategyConfig;
    }

    public void setKeyGeneratorConfig(KeyGeneratorConfiguration keyGeneratorConfig) {
        this.keyGeneratorConfig = keyGeneratorConfig;
    }
}

