/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.api.config.sharding.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.shardingsphere.api.config.sharding.strategy.ShardingStrategyConfiguration;
import org.apache.shardingsphere.api.sharding.standard.PreciseShardingAlgorithm;
import org.apache.shardingsphere.api.sharding.standard.RangeShardingAlgorithm;

public final class StandardShardingStrategyConfiguration
implements ShardingStrategyConfiguration {
    private final String shardingColumn;
    private final PreciseShardingAlgorithm preciseShardingAlgorithm;
    private final RangeShardingAlgorithm rangeShardingAlgorithm;

    public StandardShardingStrategyConfiguration(String shardingColumn, PreciseShardingAlgorithm preciseShardingAlgorithm) {
        this(shardingColumn, preciseShardingAlgorithm, null);
    }

    public StandardShardingStrategyConfiguration(String shardingColumn, PreciseShardingAlgorithm preciseShardingAlgorithm, RangeShardingAlgorithm rangeShardingAlgorithm) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)shardingColumn) ? 1 : 0) != 0, (Object)"ShardingColumns is required.");
        Preconditions.checkNotNull((Object)preciseShardingAlgorithm, (Object)"PreciseShardingAlgorithm is required.");
        this.shardingColumn = shardingColumn;
        this.preciseShardingAlgorithm = preciseShardingAlgorithm;
        this.rangeShardingAlgorithm = rangeShardingAlgorithm;
    }

    public String getShardingColumn() {
        return this.shardingColumn;
    }

    public PreciseShardingAlgorithm getPreciseShardingAlgorithm() {
        return this.preciseShardingAlgorithm;
    }

    public RangeShardingAlgorithm getRangeShardingAlgorithm() {
        return this.rangeShardingAlgorithm;
    }
}

