/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.shardingsphere.api.hint.HintManager;
import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.constant.properties.ShardingProperties;
import org.apache.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import org.apache.shardingsphere.core.metadata.ShardingMetaData;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.rewrite.SQLBuilder;
import org.apache.shardingsphere.core.rewrite.SQLRewriteEngine;
import org.apache.shardingsphere.core.route.RouteUnit;
import org.apache.shardingsphere.core.route.SQLLogger;
import org.apache.shardingsphere.core.route.SQLRouteResult;
import org.apache.shardingsphere.core.route.SQLUnit;
import org.apache.shardingsphere.core.route.type.TableUnit;
import org.apache.shardingsphere.core.rule.ShardingRule;

public abstract class BaseShardingEngine {
    private final ShardingRule shardingRule;
    private final ShardingProperties shardingProperties;
    private final ShardingMetaData metaData;
    private final DatabaseType databaseType;

    public SQLRouteResult shard(String sql, List<Object> parameters) {
        List<Object> clonedParameters = this.cloneParameters(parameters);
        SQLRouteResult result = this.route(sql, clonedParameters);
        result.getRouteUnits().addAll(HintManager.isDatabaseShardingOnly() ? this.convert(sql, clonedParameters, result) : this.rewriteAndConvert(sql, clonedParameters, result));
        if (((Boolean)this.shardingProperties.getValue(ShardingPropertiesConstant.SQL_SHOW)).booleanValue()) {
            boolean showSimple = (Boolean)this.shardingProperties.getValue(ShardingPropertiesConstant.SQL_SIMPLE);
            SQLLogger.logSQL((String)sql, (boolean)showSimple, (SQLStatement)result.getSqlStatement(), (Collection)result.getRouteUnits());
        }
        return result;
    }

    protected abstract List<Object> cloneParameters(List<Object> var1);

    protected abstract SQLRouteResult route(String var1, List<Object> var2);

    private Collection<RouteUnit> convert(String sql, List<Object> parameters, SQLRouteResult sqlRouteResult) {
        LinkedHashSet<RouteUnit> result = new LinkedHashSet<RouteUnit>();
        for (TableUnit each : sqlRouteResult.getRoutingResult().getTableUnits().getTableUnits()) {
            result.add(new RouteUnit(each.getDataSourceName(), new SQLUnit(sql, parameters)));
        }
        return result;
    }

    private Collection<RouteUnit> rewriteAndConvert(String sql, List<Object> parameters, SQLRouteResult sqlRouteResult) {
        SQLRewriteEngine rewriteEngine = new SQLRewriteEngine(this.shardingRule, sql, this.databaseType, sqlRouteResult, parameters, sqlRouteResult.getOptimizeResult());
        SQLBuilder sqlBuilder = rewriteEngine.rewrite(sqlRouteResult.getRoutingResult().isSingleRouting());
        LinkedHashSet<RouteUnit> result = new LinkedHashSet<RouteUnit>();
        for (TableUnit each : sqlRouteResult.getRoutingResult().getTableUnits().getTableUnits()) {
            result.add(new RouteUnit(each.getDataSourceName(), rewriteEngine.generateSQL(each, sqlBuilder, this.metaData.getDataSource())));
        }
        return result;
    }

    @ConstructorProperties(value={"shardingRule", "shardingProperties", "metaData", "databaseType"})
    public BaseShardingEngine(ShardingRule shardingRule, ShardingProperties shardingProperties, ShardingMetaData metaData, DatabaseType databaseType) {
        this.shardingRule = shardingRule;
        this.shardingProperties = shardingProperties;
        this.metaData = metaData;
        this.databaseType = databaseType;
    }
}

