/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.ServiceLoader;
import javax.sql.DataSource;
import org.apache.shardingsphere.spi.database.DatabaseType;
import org.apache.shardingsphere.transaction.core.ResourceDataSource;
import org.apache.shardingsphere.transaction.core.TransactionType;
import org.apache.shardingsphere.transaction.spi.ShardingTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShardingTransactionManagerEngine {
    private static final Logger log = LoggerFactory.getLogger(ShardingTransactionManagerEngine.class);
    private final Map<TransactionType, ShardingTransactionManager> transactionManagerMap = new EnumMap<TransactionType, ShardingTransactionManager>(TransactionType.class);

    public ShardingTransactionManagerEngine() {
        this.loadShardingTransactionManager();
    }

    private void loadShardingTransactionManager() {
        for (ShardingTransactionManager each : ServiceLoader.load(ShardingTransactionManager.class)) {
            if (this.transactionManagerMap.containsKey((Object)each.getTransactionType())) {
                log.warn("Find more than one {} transaction manager implementation class, use `{}` now", (Object)each.getTransactionType(), (Object)this.transactionManagerMap.get((Object)each.getTransactionType()).getClass().getName());
                continue;
            }
            this.transactionManagerMap.put(each.getTransactionType(), each);
        }
    }

    public void init(DatabaseType databaseType, Map<String, DataSource> dataSourceMap) {
        for (Map.Entry<TransactionType, ShardingTransactionManager> entry : this.transactionManagerMap.entrySet()) {
            entry.getValue().init(databaseType, this.getResourceDataSources(dataSourceMap));
        }
    }

    private Collection<ResourceDataSource> getResourceDataSources(Map<String, DataSource> dataSourceMap) {
        LinkedList<ResourceDataSource> result = new LinkedList<ResourceDataSource>();
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            result.add(new ResourceDataSource(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    public ShardingTransactionManager getTransactionManager(TransactionType transactionType) {
        ShardingTransactionManager result = this.transactionManagerMap.get((Object)transactionType);
        if (TransactionType.LOCAL != transactionType) {
            Preconditions.checkNotNull((Object)result, (String)"Cannot find transaction manager of [%s]", (Object[])new Object[]{transactionType});
        }
        return result;
    }

    public void close() throws Exception {
        for (Map.Entry<TransactionType, ShardingTransactionManager> entry : this.transactionManagerMap.entrySet()) {
            entry.getValue().close();
        }
    }
}

