/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.converter;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.federation.optimizer.converter.statement.SelectStatementConverter;
import org.apache.shardingsphere.sql.parser.sql.common.constant.UnionType;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.union.UnionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class SQLNodeConverterEngine {
    private static final Map<UnionType, SqlOperator> REGISTRY = new TreeMap<UnionType, SqlOperator>();

    private static void registerUnion() {
        REGISTRY.put(UnionType.UNION_DISTINCT, (SqlOperator)SqlStdOperatorTable.UNION);
    }

    public static SqlNode convertToSQLNode(SQLStatement statement) {
        if (statement instanceof SelectStatement) {
            Iterator iterator;
            SqlNode sqlNode = new SelectStatementConverter().convertToSQLNode((SelectStatement)statement);
            if (null != ((SelectStatement)statement).getUnionSegments() && (iterator = ((SelectStatement)statement).getUnionSegments().iterator()).hasNext()) {
                UnionSegment unionSegment = (UnionSegment)iterator.next();
                SqlNode unionSqlNode = SQLNodeConverterEngine.convertToSQLNode((SQLStatement)unionSegment.getSelectStatement());
                return new SqlBasicCall(SQLNodeConverterEngine.convertUnionOperator(unionSegment.getUnionType()), new SqlNode[]{sqlNode, unionSqlNode}, SqlParserPos.ZERO);
            }
            return sqlNode;
        }
        throw new UnsupportedOperationException("Unsupported SQL node conversion.");
    }

    public static SQLStatement convertToSQLStatement(SqlNode sqlNode) {
        if (sqlNode instanceof SqlOrderBy || sqlNode instanceof SqlSelect) {
            return new SelectStatementConverter().convertToSQLStatement(sqlNode);
        }
        if (sqlNode instanceof SqlBasicCall && null != ((SqlBasicCall)sqlNode).getOperator() && SqlKind.UNION == ((SqlBasicCall)sqlNode).getOperator().getKind()) {
            SqlNode leftSqlNode = (SqlNode)((SqlBasicCall)sqlNode).getOperandList().get(0);
            SqlNode rightSqlNode = (SqlNode)((SqlBasicCall)sqlNode).getOperandList().get(1);
            SelectStatement leftSelectStatement = (SelectStatement)SQLNodeConverterEngine.convertToSQLStatement(leftSqlNode);
            SelectStatement rightSelectStatement = (SelectStatement)SQLNodeConverterEngine.convertToSQLStatement(rightSqlNode);
            leftSelectStatement.getUnionSegments().add(new UnionSegment(UnionType.UNION_DISTINCT, rightSelectStatement, rightSqlNode.getParserPosition().getColumnNum() - 7, rightSqlNode.getParserPosition().getEndColumnNum() - 1));
            return leftSelectStatement;
        }
        throw new UnsupportedOperationException("Unsupported SQL statement conversion.");
    }

    private static SqlOperator convertUnionOperator(UnionType unionType) {
        Preconditions.checkState((boolean)REGISTRY.containsKey(unionType), (String)"Unsupported unionType: `%s`", (Object)unionType);
        return REGISTRY.get(unionType);
    }

    @Generated
    private SQLNodeConverterEngine() {
    }

    static {
        SQLNodeConverterEngine.registerUnion();
    }
}

