/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.metadata;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationSchemaMetaData;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;

public final class FederationDatabaseMetaData {
    private final String name;
    private final Map<String, FederationSchemaMetaData> schemas;

    public FederationDatabaseMetaData(String name, Map<String, ShardingSphereSchema> schemas) {
        this.name = name;
        this.schemas = new ConcurrentHashMap<String, FederationSchemaMetaData>(schemas.size(), 1.0f);
        for (Map.Entry<String, ShardingSphereSchema> entry : schemas.entrySet()) {
            this.schemas.put(entry.getKey().toLowerCase(), new FederationSchemaMetaData(entry.getKey(), entry.getValue().getTables()));
        }
    }

    public void put(TableMetaData metaData) {
        if (this.schemas.containsKey(this.name)) {
            this.schemas.get(this.name).put(metaData);
        } else {
            LinkedHashMap<String, TableMetaData> tableMetaData = new LinkedHashMap<String, TableMetaData>();
            tableMetaData.put(this.name, metaData);
            this.schemas.put(this.name, new FederationSchemaMetaData(this.name, tableMetaData));
        }
    }

    public void remove(String tableName) {
        if (this.schemas.containsKey(this.name)) {
            this.schemas.get(this.name).remove(tableName);
        }
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, FederationSchemaMetaData> getSchemas() {
        return this.schemas;
    }
}

