/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.memory;

import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.config.schema.SchemaConfiguration;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.instance.workerid.WorkerIdGenerator;
import org.apache.shardingsphere.infra.rule.identifier.type.InstanceAwareRule;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilder;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilderParameter;
import org.apache.shardingsphere.mode.manager.memory.workerid.generator.MemoryWorkerIdGenerator;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsBuilder;
import org.apache.shardingsphere.transaction.context.TransactionContexts;
import org.apache.shardingsphere.transaction.context.TransactionContextsBuilder;

public final class MemoryContextManagerBuilder
implements ContextManagerBuilder {
    public ContextManager build(ContextManagerBuilderParameter parameter) throws SQLException {
        MetaDataContextsBuilder metaDataContextsBuilder = new MetaDataContextsBuilder(parameter.getGlobalRuleConfigs(), parameter.getProps());
        for (Map.Entry entry : parameter.getSchemaConfigs().entrySet()) {
            metaDataContextsBuilder.addSchema((String)entry.getKey(), (SchemaConfiguration)entry.getValue(), parameter.getProps());
        }
        MetaDataContexts metaDataContexts = metaDataContextsBuilder.build(null);
        TransactionContexts transactionContexts = new TransactionContextsBuilder(metaDataContexts.getMetaDataMap(), metaDataContexts.getGlobalRuleMetaData().getRules()).build();
        ContextManager result = new ContextManager();
        result.init(metaDataContexts, transactionContexts, this.buildInstanceContext(parameter));
        this.setInstanceContext(result);
        return result;
    }

    private InstanceContext buildInstanceContext(ContextManagerBuilderParameter parameter) {
        ComputeNodeInstance instance = new ComputeNodeInstance();
        instance.setInstanceDefinition(parameter.getInstanceDefinition());
        instance.setLabels(parameter.getLabels());
        return new InstanceContext(instance, (WorkerIdGenerator)new MemoryWorkerIdGenerator(), this.buildMemoryModeConfiguration(parameter.getModeConfig()));
    }

    private void setInstanceContext(ContextManager contextManager) {
        contextManager.getMetaDataContexts().getMetaDataMap().forEach((key, value) -> value.getRuleMetaData().getRules().stream().filter(each -> each instanceof InstanceAwareRule).forEach(each -> ((InstanceAwareRule)each).setInstanceContext(contextManager.getInstanceContext())));
    }

    private ModeConfiguration buildMemoryModeConfiguration(ModeConfiguration modeConfiguration) {
        return Optional.ofNullable(modeConfiguration).orElseGet(() -> new ModeConfiguration(this.getType(), null, false));
    }

    public String getType() {
        return "Memory";
    }

    public boolean isDefault() {
        return true;
    }
}

