/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConverter;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.resource.ShardingSphereResource;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.loader.SchemaLoader;
import org.apache.shardingsphere.infra.rule.builder.schema.SchemaRulesBuilder;
import org.apache.shardingsphere.infra.state.StateContext;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsBuilder;
import org.apache.shardingsphere.transaction.ShardingSphereTransactionManagerEngine;
import org.apache.shardingsphere.transaction.context.TransactionContexts;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.rule.builder.DefaultTransactionRuleConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContextManager
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContextManager.class);
    private volatile MetaDataContexts metaDataContexts = new MetaDataContexts(null);
    private volatile TransactionContexts transactionContexts = new TransactionContexts();
    private final StateContext stateContext = new StateContext();

    public void init(MetaDataContexts metaDataContexts, TransactionContexts transactionContexts) {
        this.metaDataContexts = metaDataContexts;
        this.transactionContexts = transactionContexts;
    }

    public Map<String, DataSource> getDataSourceMap(String schemaName) {
        return this.metaDataContexts.getMetaData(schemaName).getResource().getDataSources();
    }

    public synchronized void renewMetaDataContexts(MetaDataContexts metaDataContexts) {
        this.metaDataContexts = metaDataContexts;
    }

    public synchronized void renewTransactionContexts(TransactionContexts transactionContexts) {
        this.transactionContexts = transactionContexts;
    }

    public void addSchema(String schemaName) throws SQLException {
        if (this.metaDataContexts.getMetaDataMap().containsKey(schemaName)) {
            return;
        }
        MetaDataContexts newMetaDataContexts = this.buildNewMetaDataContext(schemaName);
        this.metaDataContexts.getOptimizerContext().getMetaData().getSchemas().put(schemaName, newMetaDataContexts.getOptimizerContext().getMetaData().getSchemas().get(schemaName));
        this.metaDataContexts.getMetaDataMap().put(schemaName, newMetaDataContexts.getMetaData(schemaName));
    }

    public void deleteSchema(String schemaName) {
        if (this.metaDataContexts.getMetaDataMap().containsKey(schemaName)) {
            this.metaDataContexts.getOptimizerContext().getMetaData().getSchemas().remove(schemaName);
            this.metaDataContexts.getOptimizerContext().getParserContexts().remove(schemaName);
            this.metaDataContexts.getOptimizerContext().getPlannerContexts().remove(schemaName);
            ShardingSphereMetaData removeMetaData = this.metaDataContexts.getMetaDataMap().remove(schemaName);
            this.closeDataSources(removeMetaData);
            this.closeTransactionEngine(schemaName);
        }
    }

    public void addResource(String schemaName, Map<String, DataSourceConfiguration> dataSourceConfigs) throws SQLException {
        this.refreshMetaDataContext(schemaName, dataSourceConfigs);
    }

    public void alterResource(String schemaName, Map<String, DataSourceConfiguration> dataSourceConfigs) throws SQLException {
        this.refreshMetaDataContext(schemaName, dataSourceConfigs);
    }

    private void refreshMetaDataContext(String schemaName, Map<String, DataSourceConfiguration> dataSourceConfigs) throws SQLException {
        MetaDataContexts changedMetaDataContext = this.buildChangedMetaDataContext(this.metaDataContexts.getMetaDataMap().get(schemaName), dataSourceConfigs);
        this.metaDataContexts.getMetaDataMap().putAll(changedMetaDataContext.getMetaDataMap());
        this.metaDataContexts.getOptimizerContext().getMetaData().getSchemas().putAll(changedMetaDataContext.getOptimizerContext().getMetaData().getSchemas());
        this.metaDataContexts.getOptimizerContext().getParserContexts().putAll(changedMetaDataContext.getOptimizerContext().getParserContexts());
        this.metaDataContexts.getOptimizerContext().getPlannerContexts().putAll(changedMetaDataContext.getOptimizerContext().getPlannerContexts());
        this.renewTransactionContext(schemaName, this.metaDataContexts.getMetaData(schemaName).getResource());
    }

    private MetaDataContexts buildChangedMetaDataContext(ShardingSphereMetaData originalMetaData, Map<String, DataSourceConfiguration> addedDataSourceConfigs) throws SQLException {
        HashMap dataSourceMap = new HashMap(originalMetaData.getResource().getDataSources());
        dataSourceMap.putAll(DataSourceConverter.getDataSourceMap(addedDataSourceConfigs));
        Map<String, Map<String, DataSource>> dataSourcesMap = Collections.singletonMap(originalMetaData.getName(), dataSourceMap);
        Map<String, Collection<RuleConfiguration>> schemaRuleConfigs = Collections.singletonMap(originalMetaData.getName(), originalMetaData.getRuleMetaData().getConfigurations());
        Properties props = this.metaDataContexts.getProps().getProps();
        Map rules = SchemaRulesBuilder.buildRules(dataSourcesMap, schemaRuleConfigs, (Properties)props);
        Map schemas = new SchemaLoader(dataSourcesMap, schemaRuleConfigs, rules, props).load();
        return new MetaDataContextsBuilder(dataSourcesMap, schemaRuleConfigs, this.metaDataContexts.getGlobalRuleMetaData().getConfigurations(), schemas, rules, props).build(this.metaDataContexts.getMetaDataPersistService().orElse(null));
    }

    private void renewTransactionContext(String schemaName, ShardingSphereResource resource) {
        this.closeTransactionEngine(schemaName);
        this.transactionContexts.getEngines().put(schemaName, this.createNewEngine(resource.getDatabaseType(), resource.getDataSources()));
    }

    private ShardingSphereTransactionManagerEngine createNewEngine(DatabaseType databaseType, Map<String, DataSource> dataSources) {
        ShardingSphereTransactionManagerEngine result = new ShardingSphereTransactionManagerEngine();
        result.init(databaseType, dataSources, this.getTransactionRule());
        return result;
    }

    private TransactionRule getTransactionRule() {
        Optional<TransactionRule> transactionRule = this.metaDataContexts.getGlobalRuleMetaData().getRules().stream().filter(each -> each instanceof TransactionRule).map(each -> (TransactionRule)each).findFirst();
        return transactionRule.orElseGet(() -> new TransactionRule(new DefaultTransactionRuleConfigurationBuilder().build()));
    }

    private MetaDataContexts buildNewMetaDataContext(String schemaName) throws SQLException {
        Map<String, Map<String, DataSource>> dataSourcesMap = Collections.singletonMap(schemaName, new HashMap());
        Map<String, Collection<RuleConfiguration>> schemaRuleConfigs = Collections.singletonMap(schemaName, new LinkedList());
        Properties props = this.metaDataContexts.getProps().getProps();
        Map<String, ShardingSphereSchema> schemas = Collections.singletonMap(schemaName, new ShardingSphereSchema());
        Map rules = SchemaRulesBuilder.buildRules(dataSourcesMap, schemaRuleConfigs, (Properties)props);
        return new MetaDataContextsBuilder(dataSourcesMap, schemaRuleConfigs, this.metaDataContexts.getGlobalRuleMetaData().getConfigurations(), schemas, rules, props).build(this.metaDataContexts.getMetaDataPersistService().orElse(null));
    }

    private void closeDataSources(ShardingSphereMetaData removeMetaData) {
        if (null != removeMetaData.getResource()) {
            removeMetaData.getResource().getDataSources().values().forEach(each -> this.closeDataSource(removeMetaData.getResource(), (DataSource)each));
        }
    }

    private void closeDataSource(ShardingSphereResource resource, DataSource dataSource) {
        try {
            resource.close(dataSource);
        }
        catch (SQLException ex) {
            log.error("Close data source failed", (Throwable)ex);
        }
    }

    private void closeTransactionEngine(String schemaName) {
        ShardingSphereTransactionManagerEngine staleEngine = (ShardingSphereTransactionManagerEngine)this.transactionContexts.getEngines().remove(schemaName);
        if (null != staleEngine) {
            try {
                staleEngine.close();
            }
            catch (Exception ex) {
                log.error("Close transaction engine failed", (Throwable)ex);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.metaDataContexts.close();
    }

    @Generated
    public MetaDataContexts getMetaDataContexts() {
        return this.metaDataContexts;
    }

    @Generated
    public TransactionContexts getTransactionContexts() {
        return this.transactionContexts;
    }

    @Generated
    public StateContext getStateContext() {
        return this.stateContext;
    }
}

