/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.node;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class SchemaMetaDataNode {
    private static final String ROOT_NODE = "metadata";
    private static final String DATA_SOURCE_NODE = "dataSources";
    private static final String RULE_NODE = "rules";
    private static final String SCHEMA_NODE = "schema";

    public static String getMetaDataDataSourcePath(String schemaName) {
        return SchemaMetaDataNode.getFullMetaDataPath(schemaName, DATA_SOURCE_NODE);
    }

    public static String getMetaDataNodePath() {
        return String.join((CharSequence)"/", "", ROOT_NODE);
    }

    public static String getSchemaNamePath(String schemaName) {
        return String.join((CharSequence)"/", "", ROOT_NODE, schemaName);
    }

    public static String getRulePath(String schemaName) {
        return SchemaMetaDataNode.getFullMetaDataPath(schemaName, RULE_NODE);
    }

    public static String getMetaDataSchemaPath(String schemaName) {
        return SchemaMetaDataNode.getFullMetaDataPath(schemaName, SCHEMA_NODE);
    }

    private static String getFullMetaDataPath(String schemaName, String node) {
        return String.join((CharSequence)"/", "", ROOT_NODE, schemaName, node);
    }

    public static String getSchemaName(String configurationNodeFullPath) {
        Pattern pattern = Pattern.compile(SchemaMetaDataNode.getMetaDataNodePath() + "/([\\w\\-]+)(/datasources|/rules|/schema)?", 2);
        Matcher matcher = pattern.matcher(configurationNodeFullPath);
        return matcher.find() ? matcher.group(1) : "";
    }

    public static String getSchemaNameBySchemaPath(String schemaPath) {
        Pattern pattern = Pattern.compile(SchemaMetaDataNode.getMetaDataNodePath() + "/([\\w\\-]+)$", 2);
        Matcher matcher = pattern.matcher(schemaPath);
        return matcher.find() ? matcher.group(1) : "";
    }

    @Generated
    private SchemaMetaDataNode() {
    }
}

