/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service.impl;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.metadata.persist.node.SchemaMetaDataNode;
import org.apache.shardingsphere.mode.metadata.persist.service.SchemaBasedPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;

public final class DataSourcePersistService
implements SchemaBasedPersistService<Map<String, DataSourceConfiguration>> {
    private final PersistRepository repository;

    @Override
    public void persist(String schemaName, Map<String, DataSourceConfiguration> dataSourceConfigs, boolean isOverwrite) {
        if (!(dataSourceConfigs.isEmpty() || !isOverwrite && this.isExisted(schemaName))) {
            this.persist(schemaName, dataSourceConfigs);
        }
    }

    @Override
    public void persist(String schemaName, Map<String, DataSourceConfiguration> dataSourceConfigs) {
        this.repository.persist(SchemaMetaDataNode.getMetaDataDataSourcePath(schemaName), YamlEngine.marshal(this.swapYamlDataSourceConfiguration(dataSourceConfigs)));
    }

    private Map<String, Map<String, Object>> swapYamlDataSourceConfiguration(Map<String, DataSourceConfiguration> dataSourceConfigs) {
        return dataSourceConfigs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new YamlDataSourceConfigurationSwapper().swapToMap((DataSourceConfiguration)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    @Override
    public Map<String, DataSourceConfiguration> load(String schemaName) {
        return this.isExisted(schemaName) ? this.getDataSourceConfigurations(this.repository.get(SchemaMetaDataNode.getMetaDataDataSourcePath(schemaName))) : new LinkedHashMap<String, DataSourceConfiguration>();
    }

    private Map<String, DataSourceConfiguration> getDataSourceConfigurations(String yamlContent) {
        Map yamlDataSources = (Map)YamlEngine.unmarshal((String)yamlContent, Map.class);
        if (yamlDataSources.isEmpty()) {
            return new LinkedHashMap<String, DataSourceConfiguration>();
        }
        LinkedHashMap<String, DataSourceConfiguration> result = new LinkedHashMap<String, DataSourceConfiguration>(yamlDataSources.size());
        yamlDataSources.forEach((key, value) -> result.put((String)key, new YamlDataSourceConfigurationSwapper().swapToDataSourceConfiguration(value)));
        return result;
    }

    @Override
    public boolean isExisted(String schemaName) {
        return !Strings.isNullOrEmpty((String)this.repository.get(SchemaMetaDataNode.getMetaDataDataSourcePath(schemaName)));
    }

    public void append(String schemaName, Map<String, DataSourceConfiguration> toBeAppendedDataSourceConfigs) {
        Object dataSourceConfigs = this.load(schemaName);
        dataSourceConfigs.putAll(toBeAppendedDataSourceConfigs);
        this.persist(schemaName, (Map<String, DataSourceConfiguration>)dataSourceConfigs);
    }

    public void drop(String schemaName, Collection<String> toBeDroppedDataSourceNames) {
        Object dataSourceConfigs = this.load(schemaName);
        for (String each : toBeDroppedDataSourceNames) {
            dataSourceConfigs.remove(each);
        }
        this.persist(schemaName, (Map<String, DataSourceConfiguration>)dataSourceConfigs);
    }

    @Generated
    public DataSourcePersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

