/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager;

import com.google.common.collect.Maps;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.schema.SchemaConfiguration;
import org.apache.shardingsphere.infra.config.schema.impl.DataSourceProvidedSchemaConfiguration;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolCreator;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesCreator;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContextFactory;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationDatabaseMetaData;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.resource.ShardingSphereResource;
import org.apache.shardingsphere.infra.metadata.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.schema.builder.TableMetaDataBuilder;
import org.apache.shardingsphere.infra.metadata.schema.loader.SchemaLoader;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.rule.builder.global.GlobalRulesBuilder;
import org.apache.shardingsphere.infra.rule.builder.schema.SchemaRulesBuilder;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsBuilder;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.transaction.ShardingSphereTransactionManagerEngine;
import org.apache.shardingsphere.transaction.config.TransactionRuleConfiguration;
import org.apache.shardingsphere.transaction.context.TransactionContexts;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.rule.builder.DefaultTransactionRuleConfigurationBuilder;
import org.apache.shardingsphere.transaction.spi.TransactionConfigurationFileGenerator;
import org.apache.shardingsphere.transaction.spi.TransactionConfigurationFileGeneratorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContextManager
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContextManager.class);
    private volatile MetaDataContexts metaDataContexts = new MetaDataContexts(null);
    private volatile TransactionContexts transactionContexts = new TransactionContexts();
    private volatile InstanceContext instanceContext;

    public void init(MetaDataContexts metaDataContexts, TransactionContexts transactionContexts, InstanceContext instanceContext) {
        this.metaDataContexts = metaDataContexts;
        this.transactionContexts = transactionContexts;
        this.instanceContext = instanceContext;
    }

    public Map<String, DataSource> getDataSourceMap(String schemaName) {
        return this.metaDataContexts.getMetaData(schemaName).getResource().getDataSources();
    }

    public synchronized void renewMetaDataContexts(MetaDataContexts metaDataContexts) {
        this.metaDataContexts = metaDataContexts;
    }

    public synchronized void renewTransactionContexts(TransactionContexts transactionContexts) {
        this.transactionContexts = transactionContexts;
    }

    public void addSchema(String schemaName) throws SQLException {
        if (this.metaDataContexts.getMetaDataMap().containsKey(schemaName)) {
            return;
        }
        MetaDataContexts newMetaDataContexts = this.buildNewMetaDataContext(schemaName);
        FederationDatabaseMetaData databaseMetaData = (FederationDatabaseMetaData)newMetaDataContexts.getOptimizerContext().getFederationMetaData().getDatabases().get(schemaName);
        this.metaDataContexts.getOptimizerContext().getFederationMetaData().getDatabases().put(schemaName, databaseMetaData);
        this.metaDataContexts.getOptimizerContext().getPlannerContexts().put(schemaName, OptimizerPlannerContextFactory.create((FederationDatabaseMetaData)databaseMetaData));
        this.metaDataContexts.getMetaDataMap().put(schemaName, newMetaDataContexts.getMetaData(schemaName));
        this.metaDataContexts.getMetaDataPersistService().ifPresent(optional -> optional.getSchemaMetaDataService().persist(schemaName));
        this.renewAllTransactionContext();
    }

    public void alterSchema(String schemaName, Map<String, ShardingSphereSchema> schemas) {
        ShardingSphereMetaData alteredMetaData = new ShardingSphereMetaData(schemaName, this.metaDataContexts.getMetaData(schemaName).getResource(), this.metaDataContexts.getMetaData(schemaName).getRuleMetaData(), schemas);
        HashMap<String, ShardingSphereMetaData> alteredMetaDataMap = new HashMap<String, ShardingSphereMetaData>(this.metaDataContexts.getMetaDataMap());
        alteredMetaDataMap.put(schemaName, alteredMetaData);
        FederationDatabaseMetaData alteredDatabaseMetaData = new FederationDatabaseMetaData(schemaName, schemas);
        this.metaDataContexts.getOptimizerContext().getFederationMetaData().getDatabases().put(schemaName, alteredDatabaseMetaData);
        this.metaDataContexts.getOptimizerContext().getPlannerContexts().put(schemaName, OptimizerPlannerContextFactory.create((FederationDatabaseMetaData)alteredDatabaseMetaData));
        this.renewMetaDataContexts(this.rebuildMetaDataContexts(alteredMetaDataMap));
    }

    public void alterSchema(String schemaName, TableMetaData changedTableMetaData, String deletedTable) {
        Optional.ofNullable(changedTableMetaData).ifPresent(optional -> this.alterTableSchema(schemaName, (TableMetaData)optional));
        Optional.ofNullable(deletedTable).ifPresent(optional -> this.deleteTableSchema(schemaName, (String)optional));
    }

    private void alterTableSchema(String schemaName, TableMetaData changedTableMetaData) {
        ShardingSphereMetaData metaData = this.metaDataContexts.getMetaData(schemaName);
        this.alterSingleTableDataNodes(schemaName, metaData, changedTableMetaData);
        FederationDatabaseMetaData databaseMetaData = (FederationDatabaseMetaData)this.metaDataContexts.getOptimizerContext().getFederationMetaData().getDatabases().get(schemaName);
        metaData.getDefaultSchema().put(changedTableMetaData.getName(), changedTableMetaData);
        databaseMetaData.put(changedTableMetaData);
        this.metaDataContexts.getOptimizerContext().getPlannerContexts().put(schemaName, OptimizerPlannerContextFactory.create((FederationDatabaseMetaData)databaseMetaData));
    }

    private void alterSingleTableDataNodes(String schemaName, ShardingSphereMetaData metaData, TableMetaData changedTableMetaData) {
        if (!this.containsInDataNodeContainedRule(changedTableMetaData.getName(), metaData)) {
            this.refreshRules(schemaName, metaData);
        }
    }

    private void refreshRules(String schemaName, ShardingSphereMetaData metaData) {
        Collection rules = SchemaRulesBuilder.buildRules((String)schemaName, (SchemaConfiguration)new DataSourceProvidedSchemaConfiguration(metaData.getResource().getDataSources(), metaData.getRuleMetaData().getConfigurations()), (ConfigurationProperties)new ConfigurationProperties(this.metaDataContexts.getProps().getProps()));
        metaData.getRuleMetaData().getRules().clear();
        metaData.getRuleMetaData().getRules().addAll(rules);
    }

    private void deleteTableSchema(String schemaName, String deletedTable) {
        ShardingSphereMetaData metaData = this.metaDataContexts.getMetaData(schemaName);
        FederationDatabaseMetaData databaseMetaData = (FederationDatabaseMetaData)this.metaDataContexts.getOptimizerContext().getFederationMetaData().getDatabases().get(schemaName);
        metaData.getDefaultSchema().remove(deletedTable);
        databaseMetaData.remove(deletedTable);
        this.metaDataContexts.getOptimizerContext().getPlannerContexts().put(schemaName, OptimizerPlannerContextFactory.create((FederationDatabaseMetaData)databaseMetaData));
    }

    private boolean containsInDataNodeContainedRule(String tableName, ShardingSphereMetaData schemaMetaData) {
        return schemaMetaData.getRuleMetaData().findRules(DataNodeContainedRule.class).stream().anyMatch(each -> each.getAllTables().contains(tableName));
    }

    public void deleteSchema(String schemaName) {
        if (this.metaDataContexts.getMetaDataMap().containsKey(schemaName)) {
            this.metaDataContexts.getOptimizerContext().getFederationMetaData().getDatabases().remove(schemaName);
            this.metaDataContexts.getOptimizerContext().getParserContexts().remove(schemaName);
            this.metaDataContexts.getOptimizerContext().getPlannerContexts().remove(schemaName);
            ShardingSphereMetaData removeMetaData = this.metaDataContexts.getMetaDataMap().remove(schemaName);
            this.closeDataSources(removeMetaData);
            this.removeAndCloseTransactionEngine(schemaName);
            this.metaDataContexts.getMetaDataPersistService().ifPresent(optional -> optional.getSchemaMetaDataService().delete(schemaName));
        }
    }

    public void addResource(String schemaName, Map<String, DataSourceProperties> dataSourcePropsMap) throws SQLException {
        this.refreshMetaDataContext(schemaName, dataSourcePropsMap);
        this.metaDataContexts.getMetaDataPersistService().ifPresent(optional -> optional.getDataSourceService().append(schemaName, dataSourcePropsMap));
    }

    public void alterResource(String schemaName, Map<String, DataSourceProperties> dataSourcePropsMap) throws SQLException {
        this.refreshMetaDataContext(schemaName, dataSourcePropsMap);
        this.metaDataContexts.getMetaDataPersistService().ifPresent(optional -> optional.getDataSourceService().append(schemaName, dataSourcePropsMap));
    }

    public void dropResource(String schemaName, Collection<String> toBeDroppedResourceNames) {
        toBeDroppedResourceNames.forEach(this.metaDataContexts.getMetaData(schemaName).getResource().getDataSources()::remove);
        this.metaDataContexts.getMetaDataPersistService().ifPresent(optional -> optional.getDataSourceService().drop(schemaName, toBeDroppedResourceNames));
    }

    public void alterRuleConfiguration(String schemaName, Collection<RuleConfiguration> ruleConfigs) {
        try {
            MetaDataContexts changedMetaDataContexts = this.buildChangedMetaDataContext(this.metaDataContexts.getMetaDataMap().get(schemaName), ruleConfigs);
            this.metaDataContexts.getOptimizerContext().getFederationMetaData().getDatabases().putAll(changedMetaDataContexts.getOptimizerContext().getFederationMetaData().getDatabases());
            HashMap<String, ShardingSphereMetaData> metaDataMap = new HashMap<String, ShardingSphereMetaData>(this.metaDataContexts.getMetaDataMap());
            metaDataMap.putAll(changedMetaDataContexts.getMetaDataMap());
            this.renewMetaDataContexts(this.rebuildMetaDataContexts(metaDataMap));
        }
        catch (SQLException ex) {
            log.error("Alter schema:{} rule configuration failed", (Object)schemaName, (Object)ex);
        }
    }

    public void alterDataSourceConfiguration(String schemaName, Map<String, DataSourceProperties> dataSourcePropsMap) {
        try {
            MetaDataContexts changedMetaDataContext = this.buildChangedMetaDataContextWithChangedDataSource(this.metaDataContexts.getMetaDataMap().get(schemaName), dataSourcePropsMap);
            this.refreshMetaDataContext(schemaName, changedMetaDataContext, dataSourcePropsMap);
        }
        catch (SQLException ex) {
            log.error("Alter schema:{} data source configuration failed", (Object)schemaName, (Object)ex);
        }
    }

    public void alterDataSourceAndRuleConfiguration(String schemaName, Map<String, DataSourceProperties> dataSourcePropsMap, Collection<RuleConfiguration> ruleConfigs) {
        try {
            MetaDataContexts changedMetaDataContext = this.buildChangedMetaDataContextWithChangedDataSourceAndRule(this.metaDataContexts.getMetaDataMap().get(schemaName), dataSourcePropsMap, ruleConfigs);
            this.refreshMetaDataContext(schemaName, changedMetaDataContext, dataSourcePropsMap);
        }
        catch (SQLException ex) {
            log.error("Alter schema:{} data source and rule configuration failed", (Object)schemaName, (Object)ex);
        }
    }

    public void alterGlobalRuleConfiguration(Collection<RuleConfiguration> ruleConfigs) {
        if (!ruleConfigs.isEmpty()) {
            boolean needRenewTransaction = this.isNeedRenewTransactionContext(ruleConfigs);
            ShardingSphereRuleMetaData newGlobalRuleMetaData = new ShardingSphereRuleMetaData(ruleConfigs, GlobalRulesBuilder.buildRules(ruleConfigs, this.metaDataContexts.getMetaDataMap()));
            this.renewMetaDataContexts(this.rebuildMetaDataContexts(newGlobalRuleMetaData));
            if (needRenewTransaction) {
                this.renewAllTransactionContext();
            }
        }
    }

    private boolean isNeedRenewTransactionContext(Collection<RuleConfiguration> ruleConfigs) {
        Optional<RuleConfiguration> newConfig = ruleConfigs.stream().filter(each -> each instanceof TransactionRuleConfiguration).findFirst();
        Optional oldConfig = this.metaDataContexts.getGlobalRuleMetaData().findSingleRuleConfiguration(TransactionRuleConfiguration.class);
        return newConfig.isPresent() && oldConfig.isPresent() && !newConfig.get().equals(oldConfig.get());
    }

    public void alterProperties(Properties props) {
        this.renewMetaDataContexts(this.rebuildMetaDataContexts(new ConfigurationProperties(props)));
    }

    public void reloadMetaData(String schemaName) {
        try {
            ShardingSphereSchema schema = this.loadActualSchema(schemaName);
            this.alterSchema(schemaName, Collections.singletonMap(schemaName, schema));
            this.metaDataContexts.getMetaDataPersistService().ifPresent(optional -> optional.getSchemaMetaDataService().persist(schemaName, schemaName, schema));
        }
        catch (SQLException ex) {
            log.error("Reload schema:{} meta data failed", (Object)schemaName, (Object)ex);
        }
    }

    public void reloadMetaData(String schemaName, String tableName) {
        try {
            SchemaBuilderMaterials materials = new SchemaBuilderMaterials(this.metaDataContexts.getMetaData(schemaName).getResource().getDatabaseType(), this.metaDataContexts.getMetaData(schemaName).getResource().getDataSources(), this.metaDataContexts.getMetaData(schemaName).getRuleMetaData().getRules(), this.metaDataContexts.getProps());
            this.loadTableMetaData(schemaName, tableName, materials);
        }
        catch (SQLException ex) {
            log.error("Reload table:{} meta data of schema:{} failed", new Object[]{tableName, schemaName, ex});
        }
    }

    public void reloadMetaData(String schemaName, String tableName, String dataSourceName) {
        try {
            SchemaBuilderMaterials materials = new SchemaBuilderMaterials(this.metaDataContexts.getMetaData(schemaName).getResource().getDatabaseType(), Collections.singletonMap(dataSourceName, this.metaDataContexts.getMetaData(schemaName).getResource().getDataSources().get(dataSourceName)), this.metaDataContexts.getMetaData(schemaName).getRuleMetaData().getRules(), this.metaDataContexts.getProps());
            this.loadTableMetaData(schemaName, tableName, materials);
        }
        catch (SQLException ex) {
            log.error("Reload table:{} meta data of schema:{} with data source:{} failed", new Object[]{tableName, schemaName, dataSourceName, ex});
        }
    }

    private void loadTableMetaData(String schemaName, String tableName, SchemaBuilderMaterials materials) throws SQLException {
        TableMetaData tableMetaData = TableMetaDataBuilder.load(Collections.singletonList(tableName), (SchemaBuilderMaterials)materials).getOrDefault(tableName, new TableMetaData());
        if (!tableMetaData.getColumns().isEmpty()) {
            this.metaDataContexts.getMetaData(schemaName).getDefaultSchema().put(tableName, tableMetaData);
            this.metaDataContexts.getMetaDataPersistService().ifPresent(optional -> optional.getSchemaMetaDataService().persist(schemaName, schemaName, this.metaDataContexts.getMetaData(schemaName).getDefaultSchema()));
        }
    }

    private ShardingSphereSchema loadActualSchema(String schemaName) throws SQLException {
        Map dataSourceMap = this.metaDataContexts.getMetaData(schemaName).getResource().getDataSources();
        Collection rules = this.metaDataContexts.getMetaDataMap().get(schemaName).getRuleMetaData().getRules();
        return SchemaLoader.load((Map)dataSourceMap, (Collection)rules, (Properties)this.metaDataContexts.getProps().getProps());
    }

    private Collection<DataSource> getPendingClosedDataSources(String schemaName, Map<String, DataSourceProperties> dataSourcePropsMap) {
        LinkedList<DataSource> result = new LinkedList<DataSource>();
        result.addAll(this.getDeletedDataSources(this.metaDataContexts.getMetaData(schemaName), dataSourcePropsMap).values());
        result.addAll(this.getChangedDataSources(this.metaDataContexts.getMetaData(schemaName), dataSourcePropsMap).values());
        return result;
    }

    private Map<String, DataSource> getDeletedDataSources(ShardingSphereMetaData originalMetaData, Map<String, DataSourceProperties> newDataSourcePropsMap) {
        return originalMetaData.getResource().getDataSources().entrySet().stream().filter(entry -> !newDataSourcePropsMap.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, DataSource> getChangedDataSources(ShardingSphereMetaData originalMetaData, Map<String, DataSourceProperties> newDataSourcePropsMap) {
        Set<String> changedDataSourceNames = this.getChangedDataSourceConfiguration(originalMetaData, newDataSourcePropsMap).keySet();
        return originalMetaData.getResource().getDataSources().entrySet().stream().filter(entry -> changedDataSourceNames.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, DataSourceProperties> getChangedDataSourceConfiguration(ShardingSphereMetaData originalMetaData, Map<String, DataSourceProperties> dataSourcePropsMap) {
        return dataSourcePropsMap.entrySet().stream().filter(entry -> this.isModifiedDataSource(originalMetaData.getResource().getDataSources(), (String)entry.getKey(), (DataSourceProperties)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private boolean isModifiedDataSource(Map<String, DataSource> originalDataSources, String dataSourceName, DataSourceProperties dataSourceProps) {
        return originalDataSources.containsKey(dataSourceName) && !dataSourceProps.equals((Object)DataSourcePropertiesCreator.create((DataSource)originalDataSources.get(dataSourceName)));
    }

    private MetaDataContexts rebuildMetaDataContexts(Map<String, ShardingSphereMetaData> schemaMetaData) {
        return new MetaDataContexts(this.metaDataContexts.getMetaDataPersistService().orElse(null), schemaMetaData, this.metaDataContexts.getGlobalRuleMetaData(), this.metaDataContexts.getExecutorEngine(), this.metaDataContexts.getOptimizerContext(), this.metaDataContexts.getProps());
    }

    private MetaDataContexts rebuildMetaDataContexts(ShardingSphereRuleMetaData globalRuleMetaData) {
        return new MetaDataContexts(this.metaDataContexts.getMetaDataPersistService().orElse(null), this.metaDataContexts.getMetaDataMap(), globalRuleMetaData, this.metaDataContexts.getExecutorEngine(), this.metaDataContexts.getOptimizerContext(), this.metaDataContexts.getProps());
    }

    private MetaDataContexts rebuildMetaDataContexts(ConfigurationProperties props) {
        return new MetaDataContexts(this.metaDataContexts.getMetaDataPersistService().orElse(null), this.metaDataContexts.getMetaDataMap(), this.metaDataContexts.getGlobalRuleMetaData(), this.metaDataContexts.getExecutorEngine(), this.metaDataContexts.getOptimizerContext(), props);
    }

    private void refreshMetaDataContext(String schemaName, Map<String, DataSourceProperties> dataSourceProps) throws SQLException {
        MetaDataContexts changedMetaDataContext = this.buildChangedMetaDataContextWithAddedDataSource(this.metaDataContexts.getMetaDataMap().get(schemaName), dataSourceProps);
        this.metaDataContexts.getMetaDataMap().putAll(changedMetaDataContext.getMetaDataMap());
        this.metaDataContexts.getOptimizerContext().getFederationMetaData().getDatabases().putAll(changedMetaDataContext.getOptimizerContext().getFederationMetaData().getDatabases());
        this.metaDataContexts.getOptimizerContext().getParserContexts().putAll(changedMetaDataContext.getOptimizerContext().getParserContexts());
        this.metaDataContexts.getOptimizerContext().getPlannerContexts().putAll(changedMetaDataContext.getOptimizerContext().getPlannerContexts());
        this.renewTransactionContext(schemaName, this.metaDataContexts.getMetaData(schemaName).getResource());
    }

    private void refreshMetaDataContext(String schemaName, MetaDataContexts changedMetaDataContext, Map<String, DataSourceProperties> dataSourcePropsMap) {
        this.metaDataContexts.getOptimizerContext().getFederationMetaData().getDatabases().putAll(changedMetaDataContext.getOptimizerContext().getFederationMetaData().getDatabases());
        HashMap<String, ShardingSphereMetaData> metaDataMap = new HashMap<String, ShardingSphereMetaData>(this.metaDataContexts.getMetaDataMap());
        metaDataMap.putAll(changedMetaDataContext.getMetaDataMap());
        Collection<DataSource> pendingClosedDataSources = this.getPendingClosedDataSources(schemaName, dataSourcePropsMap);
        this.renewMetaDataContexts(this.rebuildMetaDataContexts(metaDataMap));
        this.renewTransactionContext(schemaName, this.metaDataContexts.getMetaData(schemaName).getResource());
        this.closeDataSources(schemaName, pendingClosedDataSources);
    }

    private MetaDataContexts buildChangedMetaDataContextWithAddedDataSource(ShardingSphereMetaData originalMetaData, Map<String, DataSourceProperties> addedDataSourceProps) throws SQLException {
        HashMap dataSourceMap = new HashMap(originalMetaData.getResource().getDataSources());
        dataSourceMap.putAll(DataSourcePoolCreator.create(addedDataSourceProps));
        Properties props = this.metaDataContexts.getProps().getProps();
        DataSourceProvidedSchemaConfiguration schemaConfiguration = new DataSourceProvidedSchemaConfiguration(dataSourceMap, originalMetaData.getRuleMetaData().getConfigurations());
        Optional<MetaDataPersistService> metaDataPersistService = this.metaDataContexts.getMetaDataPersistService();
        metaDataPersistService.ifPresent(arg_0 -> this.lambda$buildChangedMetaDataContextWithAddedDataSource$15((SchemaConfiguration)schemaConfiguration, arg_0));
        MetaDataContextsBuilder metaDataContextsBuilder = new MetaDataContextsBuilder(this.metaDataContexts.getGlobalRuleMetaData().getConfigurations(), props);
        metaDataContextsBuilder.addSchema(originalMetaData.getName(), originalMetaData.getResource().getDatabaseType(), (SchemaConfiguration)schemaConfiguration, props);
        this.metaDataContexts.getMetaDataPersistService().ifPresent(optional -> optional.getSchemaMetaDataService().persist(originalMetaData.getName(), originalMetaData.getName(), metaDataContextsBuilder.getSchemaMap(originalMetaData.getName())));
        return metaDataContextsBuilder.build(this.metaDataContexts.getMetaDataPersistService().orElse(null));
    }

    private void persistTransactionConfiguration(SchemaConfiguration schemaConfiguration, MetaDataPersistService metaDataPersistService) {
        Optional fileGenerator = TransactionConfigurationFileGeneratorFactory.newInstance((String)this.getTransactionRule().getProviderType());
        if (fileGenerator.isPresent()) {
            Properties transactionProps = ((TransactionConfigurationFileGenerator)fileGenerator.get()).getTransactionProps(this.getTransactionRule().getProps(), schemaConfiguration, this.instanceContext.getModeConfiguration().getType());
            metaDataPersistService.persistTransactionRule(transactionProps, true);
        }
    }

    private MetaDataContexts buildChangedMetaDataContext(ShardingSphereMetaData originalMetaData, Collection<RuleConfiguration> ruleConfigs) throws SQLException {
        Properties props = this.metaDataContexts.getProps().getProps();
        MetaDataContextsBuilder metaDataContextsBuilder = new MetaDataContextsBuilder(this.metaDataContexts.getGlobalRuleMetaData().getConfigurations(), props);
        metaDataContextsBuilder.addSchema(originalMetaData.getName(), originalMetaData.getResource().getDatabaseType(), (SchemaConfiguration)new DataSourceProvidedSchemaConfiguration(originalMetaData.getResource().getDataSources(), ruleConfigs), props);
        this.metaDataContexts.getMetaDataPersistService().ifPresent(optional -> optional.getSchemaMetaDataService().persist(originalMetaData.getName(), originalMetaData.getName(), metaDataContextsBuilder.getSchemaMap(originalMetaData.getName())));
        return metaDataContextsBuilder.build(this.metaDataContexts.getMetaDataPersistService().orElse(null));
    }

    private MetaDataContexts buildChangedMetaDataContextWithChangedDataSource(ShardingSphereMetaData originalMetaData, Map<String, DataSourceProperties> newDataSourceProps) throws SQLException {
        Set<String> deletedDataSources = this.getDeletedDataSources(originalMetaData, newDataSourceProps).keySet();
        Map<String, DataSource> changedDataSources = this.buildChangedDataSources(originalMetaData, newDataSourceProps);
        Properties props = this.metaDataContexts.getProps().getProps();
        MetaDataContextsBuilder metaDataContextsBuilder = new MetaDataContextsBuilder(this.metaDataContexts.getGlobalRuleMetaData().getConfigurations(), props);
        metaDataContextsBuilder.addSchema(originalMetaData.getName(), originalMetaData.getResource().getDatabaseType(), (SchemaConfiguration)new DataSourceProvidedSchemaConfiguration(this.getNewDataSources(originalMetaData.getResource().getDataSources(), this.getAddedDataSources(originalMetaData, newDataSourceProps), changedDataSources, deletedDataSources), originalMetaData.getRuleMetaData().getConfigurations()), props);
        this.metaDataContexts.getMetaDataPersistService().ifPresent(optional -> optional.getSchemaMetaDataService().persist(originalMetaData.getName(), originalMetaData.getName(), metaDataContextsBuilder.getSchemaMap(originalMetaData.getName())));
        return metaDataContextsBuilder.build(this.metaDataContexts.getMetaDataPersistService().orElse(null));
    }

    private MetaDataContexts buildChangedMetaDataContextWithChangedDataSourceAndRule(ShardingSphereMetaData originalMetaData, Map<String, DataSourceProperties> newDataSourceProps, Collection<RuleConfiguration> ruleConfigs) throws SQLException {
        Set<String> deletedDataSources = this.getDeletedDataSources(originalMetaData, newDataSourceProps).keySet();
        Map<String, DataSource> changedDataSources = this.buildChangedDataSources(originalMetaData, newDataSourceProps);
        Properties props = this.metaDataContexts.getProps().getProps();
        MetaDataContextsBuilder metaDataContextsBuilder = new MetaDataContextsBuilder(this.metaDataContexts.getGlobalRuleMetaData().getConfigurations(), props);
        metaDataContextsBuilder.addSchema(originalMetaData.getName(), originalMetaData.getResource().getDatabaseType(), (SchemaConfiguration)new DataSourceProvidedSchemaConfiguration(this.getNewDataSources(originalMetaData.getResource().getDataSources(), this.getAddedDataSources(originalMetaData, newDataSourceProps), changedDataSources, deletedDataSources), ruleConfigs), props);
        this.metaDataContexts.getMetaDataPersistService().ifPresent(optional -> optional.getSchemaMetaDataService().persist(originalMetaData.getName(), originalMetaData.getName(), metaDataContextsBuilder.getSchemaMap(originalMetaData.getName())));
        return metaDataContextsBuilder.build(this.metaDataContexts.getMetaDataPersistService().orElse(null));
    }

    private Map<String, DataSource> getNewDataSources(Map<String, DataSource> originalDataSources, Map<String, DataSource> addedDataSources, Map<String, DataSource> changedDataSources, Collection<String> deletedDataSources) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>(originalDataSources);
        result.keySet().removeAll(deletedDataSources);
        result.putAll(changedDataSources);
        result.putAll(addedDataSources);
        return result;
    }

    private Map<String, DataSource> getAddedDataSources(ShardingSphereMetaData originalMetaData, Map<String, DataSourceProperties> newDataSourcePropsMap) {
        return DataSourcePoolCreator.create((Map)Maps.filterKeys(newDataSourcePropsMap, each -> !originalMetaData.getResource().getDataSources().containsKey(each)));
    }

    private Map<String, DataSource> buildChangedDataSources(ShardingSphereMetaData originalMetaData, Map<String, DataSourceProperties> newDataSourcePropsMap) {
        return DataSourcePoolCreator.create(this.getChangedDataSourceConfiguration(originalMetaData, newDataSourcePropsMap));
    }

    public void renewAllTransactionContext() {
        for (Map.Entry<String, ShardingSphereMetaData> entry : this.metaDataContexts.getMetaDataMap().entrySet()) {
            this.renewTransactionContext(entry.getKey(), entry.getValue().getResource());
        }
    }

    private void renewTransactionContext(String schemaName, ShardingSphereResource resource) {
        ShardingSphereTransactionManagerEngine changedStaleEngine = (ShardingSphereTransactionManagerEngine)this.transactionContexts.getEngines().get(schemaName);
        if (null != changedStaleEngine) {
            this.closeTransactionEngine(changedStaleEngine);
        }
        this.transactionContexts.getEngines().put(schemaName, this.createNewEngine(resource.getDatabaseType(), resource.getDataSources()));
    }

    private ShardingSphereTransactionManagerEngine createNewEngine(DatabaseType databaseType, Map<String, DataSource> dataSources) {
        Optional fileGenerator = TransactionConfigurationFileGeneratorFactory.newInstance((String)this.getTransactionRule().getProviderType());
        fileGenerator.ifPresent(optional -> optional.generateFile(this.getTransactionRule().getProps(), this.instanceContext));
        ShardingSphereTransactionManagerEngine result = new ShardingSphereTransactionManagerEngine();
        result.init(databaseType, dataSources, this.getTransactionRule());
        return result;
    }

    private TransactionRule getTransactionRule() {
        Optional<TransactionRule> transactionRule = this.metaDataContexts.getGlobalRuleMetaData().getRules().stream().filter(each -> each instanceof TransactionRule).map(each -> (TransactionRule)each).findFirst();
        return transactionRule.orElseGet(() -> new TransactionRule(new DefaultTransactionRuleConfigurationBuilder().build()));
    }

    private MetaDataContexts buildNewMetaDataContext(String schemaName) throws SQLException {
        Properties props = this.metaDataContexts.getProps().getProps();
        MetaDataContextsBuilder metaDataContextsBuilder = new MetaDataContextsBuilder(this.metaDataContexts.getGlobalRuleMetaData().getConfigurations(), props);
        metaDataContextsBuilder.addSchema(schemaName, DatabaseTypeRegistry.getDefaultDatabaseType(), (SchemaConfiguration)new DataSourceProvidedSchemaConfiguration(new HashMap(), new LinkedList()), props);
        return metaDataContextsBuilder.build(this.metaDataContexts.getMetaDataPersistService().orElse(null));
    }

    private void closeDataSources(ShardingSphereMetaData removeMetaData) {
        if (null != removeMetaData.getResource()) {
            removeMetaData.getResource().getDataSources().values().forEach(each -> removeMetaData.getResource().close(each));
        }
    }

    private void closeDataSources(String schemaName, Collection<DataSource> dataSources) {
        ShardingSphereResource resource = this.metaDataContexts.getMetaData(schemaName).getResource();
        dataSources.forEach(arg_0 -> ((ShardingSphereResource)resource).close(arg_0));
    }

    private void removeAndCloseTransactionEngine(String schemaName) {
        ShardingSphereTransactionManagerEngine staleEngine = (ShardingSphereTransactionManagerEngine)this.transactionContexts.getEngines().remove(schemaName);
        this.closeTransactionEngine(staleEngine);
    }

    private void closeTransactionEngine(ShardingSphereTransactionManagerEngine staleEngine) {
        if (null != staleEngine) {
            try {
                staleEngine.close();
            }
            catch (Exception ex) {
                log.error("Close transaction engine failed", (Throwable)ex);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.metaDataContexts.close();
    }

    @Generated
    public MetaDataContexts getMetaDataContexts() {
        return this.metaDataContexts;
    }

    @Generated
    public TransactionContexts getTransactionContexts() {
        return this.transactionContexts;
    }

    @Generated
    public InstanceContext getInstanceContext() {
        return this.instanceContext;
    }

    private /* synthetic */ void lambda$buildChangedMetaDataContextWithAddedDataSource$15(SchemaConfiguration schemaConfiguration, MetaDataPersistService optional) {
        this.persistTransactionConfiguration(schemaConfiguration, optional);
    }
}

