/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.config.schema.SchemaConfiguration;
import org.apache.shardingsphere.infra.instance.definition.InstanceDefinition;

public final class ContextManagerBuilderParameter {
    private final ModeConfiguration modeConfig;
    private final Map<String, ? extends SchemaConfiguration> schemaConfigs;
    private final Collection<RuleConfiguration> globalRuleConfigs;
    private final Properties props;
    private final Collection<String> labels;
    private final InstanceDefinition instanceDefinition;

    public boolean isEmpty() {
        return this.props.isEmpty() && this.globalRuleConfigs.isEmpty() && this.schemaConfigs.entrySet().stream().allMatch(entry -> ((SchemaConfiguration)entry.getValue()).getDataSources().isEmpty() && ((SchemaConfiguration)entry.getValue()).getRuleConfigurations().isEmpty());
    }

    @Generated
    ContextManagerBuilderParameter(ModeConfiguration modeConfig, Map<String, ? extends SchemaConfiguration> schemaConfigs, Collection<RuleConfiguration> globalRuleConfigs, Properties props, Collection<String> labels, InstanceDefinition instanceDefinition) {
        this.modeConfig = modeConfig;
        this.schemaConfigs = schemaConfigs;
        this.globalRuleConfigs = globalRuleConfigs;
        this.props = props;
        this.labels = labels;
        this.instanceDefinition = instanceDefinition;
    }

    @Generated
    public static ContextManagerBuilderParameterBuilder builder() {
        return new ContextManagerBuilderParameterBuilder();
    }

    @Generated
    public ModeConfiguration getModeConfig() {
        return this.modeConfig;
    }

    @Generated
    public Map<String, ? extends SchemaConfiguration> getSchemaConfigs() {
        return this.schemaConfigs;
    }

    @Generated
    public Collection<RuleConfiguration> getGlobalRuleConfigs() {
        return this.globalRuleConfigs;
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public Collection<String> getLabels() {
        return this.labels;
    }

    @Generated
    public InstanceDefinition getInstanceDefinition() {
        return this.instanceDefinition;
    }

    @Generated
    public static class ContextManagerBuilderParameterBuilder {
        @Generated
        private ModeConfiguration modeConfig;
        @Generated
        private Map<String, ? extends SchemaConfiguration> schemaConfigs;
        @Generated
        private Collection<RuleConfiguration> globalRuleConfigs;
        @Generated
        private Properties props;
        @Generated
        private Collection<String> labels;
        @Generated
        private InstanceDefinition instanceDefinition;

        @Generated
        ContextManagerBuilderParameterBuilder() {
        }

        @Generated
        public ContextManagerBuilderParameterBuilder modeConfig(ModeConfiguration modeConfig) {
            this.modeConfig = modeConfig;
            return this;
        }

        @Generated
        public ContextManagerBuilderParameterBuilder schemaConfigs(Map<String, ? extends SchemaConfiguration> schemaConfigs) {
            this.schemaConfigs = schemaConfigs;
            return this;
        }

        @Generated
        public ContextManagerBuilderParameterBuilder globalRuleConfigs(Collection<RuleConfiguration> globalRuleConfigs) {
            this.globalRuleConfigs = globalRuleConfigs;
            return this;
        }

        @Generated
        public ContextManagerBuilderParameterBuilder props(Properties props) {
            this.props = props;
            return this;
        }

        @Generated
        public ContextManagerBuilderParameterBuilder labels(Collection<String> labels) {
            this.labels = labels;
            return this;
        }

        @Generated
        public ContextManagerBuilderParameterBuilder instanceDefinition(InstanceDefinition instanceDefinition) {
            this.instanceDefinition = instanceDefinition;
            return this;
        }

        @Generated
        public ContextManagerBuilderParameter build() {
            return new ContextManagerBuilderParameter(this.modeConfig, this.schemaConfigs, this.globalRuleConfigs, this.props, this.labels, this.instanceDefinition);
        }

        @Generated
        public String toString() {
            return "ContextManagerBuilderParameter.ContextManagerBuilderParameterBuilder(modeConfig=" + this.modeConfig + ", schemaConfigs=" + this.schemaConfigs + ", globalRuleConfigs=" + this.globalRuleConfigs + ", props=" + this.props + ", labels=" + this.labels + ", instanceDefinition=" + this.instanceDefinition + ")";
        }
    }
}

