/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.config.schema.SchemaConfiguration;
import org.apache.shardingsphere.infra.config.schema.impl.DataSourceProvidedSchemaConfiguration;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorEngine;
import org.apache.shardingsphere.infra.federation.optimizer.context.OptimizerContextFactory;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.loader.DatabaseLoader;
import org.apache.shardingsphere.infra.metadata.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.builder.global.GlobalRulesBuilder;
import org.apache.shardingsphere.infra.rule.builder.schema.SchemaRulesBuilder;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;

public final class MetaDataContextsBuilder {
    private final Map<String, SchemaConfiguration> schemaConfigMap = new LinkedHashMap<String, SchemaConfiguration>();
    private final Map<String, Collection<ShardingSphereRule>> schemaRulesMap = new LinkedHashMap<String, Collection<ShardingSphereRule>>();
    private final Map<String, ShardingSphereDatabase> databaseMap = new LinkedHashMap<String, ShardingSphereDatabase>();
    private final Collection<RuleConfiguration> globalRuleConfigs;
    private final ConfigurationProperties props;
    private final ExecutorEngine executorEngine;

    public MetaDataContextsBuilder(Collection<RuleConfiguration> globalRuleConfigs, Properties props) {
        this.globalRuleConfigs = globalRuleConfigs;
        this.props = new ConfigurationProperties(props);
        this.executorEngine = new ExecutorEngine(((Integer)this.props.getValue((Enum)ConfigurationPropertyKey.KERNEL_EXECUTOR_SIZE)).intValue());
    }

    public void addSchema(String schemaName, DatabaseType databaseType, SchemaConfiguration schemaConfig, Properties props) throws SQLException {
        Collection<ShardingSphereRule> schemaRules = this.getSchemaRules(schemaName, schemaConfig, props);
        ShardingSphereDatabase database = DatabaseLoader.load((String)schemaName, (DatabaseType)databaseType, (Map)schemaConfig.getDataSources(), schemaRules, (Properties)props);
        this.schemaConfigMap.put(schemaName, schemaConfig);
        this.schemaRulesMap.put(schemaName, schemaRules);
        this.databaseMap.put(schemaName, database);
    }

    public void addSystemSchemas(DatabaseType databaseType) {
        for (String each : databaseType.getSystemDatabaseSchemaMap().keySet()) {
            if (this.databaseMap.containsKey(each)) continue;
            this.databaseMap.put(each, DatabaseLoader.load((String)each, (DatabaseType)databaseType));
        }
    }

    private Collection<ShardingSphereRule> getSchemaRules(String databaseName, SchemaConfiguration schemaConfig, Properties props) {
        return SchemaRulesBuilder.buildRules((String)databaseName, (SchemaConfiguration)schemaConfig, (ConfigurationProperties)new ConfigurationProperties(props));
    }

    public MetaDataContexts build(MetaDataPersistService metaDataPersistService) throws SQLException {
        Map<String, ShardingSphereMetaData> metaDataMap = this.getMetaDataMap();
        ShardingSphereRuleMetaData globalMetaData = new ShardingSphereRuleMetaData(this.globalRuleConfigs, GlobalRulesBuilder.buildRules(this.globalRuleConfigs, metaDataMap));
        return new MetaDataContexts(metaDataPersistService, metaDataMap, globalMetaData, this.executorEngine, OptimizerContextFactory.create(metaDataMap, (ShardingSphereRuleMetaData)globalMetaData), this.props);
    }

    private Map<String, ShardingSphereMetaData> getMetaDataMap() throws SQLException {
        DatabaseType defaultDatabaseType = DatabaseTypeFactory.getDatabaseType(this.schemaConfigMap, (ConfigurationProperties)this.props);
        HashMap<String, ShardingSphereMetaData> result = new HashMap<String, ShardingSphereMetaData>(this.databaseMap.size(), 1.0f);
        for (Map.Entry<String, ShardingSphereDatabase> entry : this.databaseMap.entrySet()) {
            String databaseName = entry.getKey();
            SchemaConfiguration schemaConfig = this.schemaConfigMap.getOrDefault(databaseName, (SchemaConfiguration)new DataSourceProvidedSchemaConfiguration(new LinkedHashMap(), new LinkedList()));
            Collection rules = this.schemaRulesMap.getOrDefault(databaseName, new LinkedList());
            result.put(databaseName, ShardingSphereMetaData.create((String)databaseName, (Map)entry.getValue().getSchemas(), (SchemaConfiguration)schemaConfig, (Collection)rules, (DatabaseType)defaultDatabaseType));
        }
        return result;
    }

    public ShardingSphereSchema getSchemaMap(String databaseName) {
        return (ShardingSphereSchema)this.databaseMap.get(databaseName).getSchemas().get(databaseName);
    }

    @Generated
    public Map<String, ShardingSphereDatabase> getDatabaseMap() {
        return this.databaseMap;
    }
}

