/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.schema.SchemaConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolCreator;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.DataSourcePoolDestroyer;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesCreator;
import org.apache.shardingsphere.mode.metadata.persist.service.ComputeNodePersistService;
import org.apache.shardingsphere.mode.metadata.persist.service.SchemaMetaDataPersistService;
import org.apache.shardingsphere.mode.metadata.persist.service.SchemaVersionPersistService;
import org.apache.shardingsphere.mode.metadata.persist.service.impl.DataSourcePersistService;
import org.apache.shardingsphere.mode.metadata.persist.service.impl.GlobalRulePersistService;
import org.apache.shardingsphere.mode.metadata.persist.service.impl.PropertiesPersistService;
import org.apache.shardingsphere.mode.metadata.persist.service.impl.SchemaRulePersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;
import org.apache.shardingsphere.transaction.config.TransactionRuleConfiguration;

public final class MetaDataPersistService {
    private final PersistRepository repository;
    private final DataSourcePersistService dataSourceService;
    private final SchemaMetaDataPersistService schemaMetaDataService;
    private final SchemaRulePersistService schemaRuleService;
    private final GlobalRulePersistService globalRuleService;
    private final PropertiesPersistService propsService;
    private final ComputeNodePersistService computeNodePersistService;
    private final SchemaVersionPersistService schemaVersionPersistService;

    public MetaDataPersistService(PersistRepository repository) {
        this.repository = repository;
        this.dataSourceService = new DataSourcePersistService(repository);
        this.schemaMetaDataService = new SchemaMetaDataPersistService(repository);
        this.schemaRuleService = new SchemaRulePersistService(repository);
        this.globalRuleService = new GlobalRulePersistService(repository);
        this.propsService = new PropertiesPersistService(repository);
        this.computeNodePersistService = new ComputeNodePersistService(repository);
        this.schemaVersionPersistService = new SchemaVersionPersistService(repository);
    }

    public void persistConfigurations(Map<String, ? extends SchemaConfiguration> schemaConfigs, Collection<RuleConfiguration> globalRuleConfigs, Properties props, boolean isOverwrite) {
        this.globalRuleService.persist(globalRuleConfigs, isOverwrite);
        this.propsService.persist(props, isOverwrite);
        for (Map.Entry<String, ? extends SchemaConfiguration> entry : schemaConfigs.entrySet()) {
            String schemaName = entry.getKey();
            this.dataSourceService.persist(schemaName, this.getDataSourcePropertiesMap(entry.getValue().getDataSources()), isOverwrite);
            this.schemaRuleService.persist(schemaName, entry.getValue().getRuleConfigurations(), isOverwrite);
        }
    }

    private Map<String, DataSourceProperties> getDataSourcePropertiesMap(Map<String, DataSource> dataSourceMap) {
        LinkedHashMap<String, DataSourceProperties> result = new LinkedHashMap<String, DataSourceProperties>(dataSourceMap.size(), 1.0f);
        for (Map.Entry<String, DataSource> each : dataSourceMap.entrySet()) {
            result.put(each.getKey(), DataSourcePropertiesCreator.create((DataSource)each.getValue()));
        }
        return result;
    }

    public void persistInstanceLabels(String instanceId, Collection<String> labels, boolean isOverwrite) {
        this.computeNodePersistService.persistInstanceLabels(instanceId, labels, isOverwrite);
    }

    public Map<String, DataSource> getEffectiveDataSources(String schemaName, Map<String, ? extends SchemaConfiguration> schemaConfigs) {
        Object persistedDataPropsMap = this.dataSourceService.load(schemaName);
        return schemaConfigs.containsKey(schemaName) ? this.mergeEffectiveDataSources((Map<String, DataSourceProperties>)persistedDataPropsMap, schemaConfigs.get(schemaName).getDataSources()) : DataSourcePoolCreator.create((Map)persistedDataPropsMap);
    }

    private Map<String, DataSource> mergeEffectiveDataSources(Map<String, DataSourceProperties> persistedDataSourcePropsMap, Map<String, DataSource> localConfiguredDataSources) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>(persistedDataSourcePropsMap.size(), 1.0f);
        for (Map.Entry<String, DataSourceProperties> entry : persistedDataSourcePropsMap.entrySet()) {
            String dataSourceName = entry.getKey();
            DataSourceProperties persistedDataSourceProps = entry.getValue();
            DataSource localConfiguredDataSource = localConfiguredDataSources.get(dataSourceName);
            if (null == localConfiguredDataSource) {
                result.put(dataSourceName, DataSourcePoolCreator.create((DataSourceProperties)persistedDataSourceProps));
                continue;
            }
            if (DataSourcePropertiesCreator.create((DataSource)localConfiguredDataSource).equals((Object)persistedDataSourceProps)) {
                result.put(dataSourceName, localConfiguredDataSource);
                continue;
            }
            result.put(dataSourceName, DataSourcePoolCreator.create((DataSourceProperties)persistedDataSourceProps));
            new DataSourcePoolDestroyer(localConfiguredDataSource).asyncDestroy();
        }
        return result;
    }

    public void persistTransactionRule(Properties props, boolean isOverwrite) {
        Object ruleConfigs = this.globalRuleService.load();
        Optional<RuleConfiguration> ruleConfig = ruleConfigs.stream().filter(each -> each instanceof TransactionRuleConfiguration).findFirst();
        Preconditions.checkState((boolean)ruleConfig.isPresent());
        if (!props.equals(((TransactionRuleConfiguration)ruleConfig.get()).getProps())) {
            ((TransactionRuleConfiguration)ruleConfig.get()).getProps().clear();
            ((TransactionRuleConfiguration)ruleConfig.get()).getProps().putAll((Map<?, ?>)props);
            this.globalRuleService.persist((Collection<RuleConfiguration>)ruleConfigs, isOverwrite);
        }
    }

    @Generated
    public PersistRepository getRepository() {
        return this.repository;
    }

    @Generated
    public DataSourcePersistService getDataSourceService() {
        return this.dataSourceService;
    }

    @Generated
    public SchemaMetaDataPersistService getSchemaMetaDataService() {
        return this.schemaMetaDataService;
    }

    @Generated
    public SchemaRulePersistService getSchemaRuleService() {
        return this.schemaRuleService;
    }

    @Generated
    public GlobalRulePersistService getGlobalRuleService() {
        return this.globalRuleService;
    }

    @Generated
    public PropertiesPersistService getPropsService() {
        return this.propsService;
    }

    @Generated
    public ComputeNodePersistService getComputeNodePersistService() {
        return this.computeNodePersistService;
    }

    @Generated
    public SchemaVersionPersistService getSchemaVersionPersistService() {
        return this.schemaVersionPersistService;
    }
}

