/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.node;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.infra.instance.definition.InstanceDefinition;
import org.apache.shardingsphere.infra.instance.definition.InstanceType;

public final class ComputeNode {
    private static final String ROOT_NODE = "nodes";
    private static final String COMPUTE_NODE = "compute_nodes";
    private static final String ONLINE_NODE = "online";
    private static final String ATTRIBUTES_NODE = "attributes";
    private static final String LABELS_NODE = "labels";
    private static final String STATUS_NODE = "status";
    private static final String WORKER_ID = "worker_id";
    private static final String XA_RECOVERY_ID_NODE = "xa_recovery_id";

    public static String getOnlineNodePath(InstanceType instanceType) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, ONLINE_NODE, instanceType.name().toLowerCase());
    }

    public static String getOnlineInstanceNodePath(String instanceId, InstanceType instanceType) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, ONLINE_NODE, instanceType.name().toLowerCase(), instanceId);
    }

    public static String getOnlineInstanceNodePath() {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, ONLINE_NODE);
    }

    public static String getInstanceLabelsNodePath(String instanceId) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, ATTRIBUTES_NODE, instanceId, LABELS_NODE);
    }

    public static String getInstanceXaRecoveryIdNodePath(String instanceId) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, ATTRIBUTES_NODE, instanceId, XA_RECOVERY_ID_NODE);
    }

    public static String getAttributesNodePath() {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, ATTRIBUTES_NODE);
    }

    public static String getComputeNodePath() {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE);
    }

    public static String getInstanceWorkerIdNodePath(String instanceId) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, ATTRIBUTES_NODE, instanceId, WORKER_ID);
    }

    public static String getInstanceIdByAttributes(String attributesPath) {
        Pattern pattern = Pattern.compile(ComputeNode.getAttributesNodePath() + "/([\\S]+)(/status|/worker_id|/labels|/xa_recovery_id)$", 2);
        Matcher matcher = pattern.matcher(attributesPath);
        return matcher.find() ? matcher.group(1) : "";
    }

    public static String getInstanceStatusNodePath(String instanceId) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, ATTRIBUTES_NODE, instanceId, STATUS_NODE);
    }

    public static Optional<InstanceDefinition> getInstanceDefinitionByInstanceOnlinePath(String onlineInstancePath) {
        Pattern pattern = Pattern.compile(ComputeNode.getOnlineInstanceNodePath() + "/(proxy|jdbc)/([\\S]+)$", 2);
        Matcher matcher = pattern.matcher(onlineInstancePath);
        return matcher.find() ? Optional.of(new InstanceDefinition(ComputeNode.getInstanceType(matcher.group(1)), matcher.group(2))) : Optional.empty();
    }

    private static InstanceType getInstanceType(String instanceType) {
        return InstanceType.PROXY.name().equalsIgnoreCase(instanceType) ? InstanceType.PROXY : InstanceType.JDBC;
    }
}

