/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.definition.InstanceDefinition;
import org.apache.shardingsphere.infra.instance.definition.InstanceType;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.metadata.persist.node.ComputeNode;
import org.apache.shardingsphere.mode.persist.PersistRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComputeNodePersistService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComputeNodePersistService.class);
    private final PersistRepository repository;

    public void persistInstanceLabels(String instanceId, Collection<String> labels, boolean isOverwrite) {
        if (!(null == labels || labels.isEmpty() || !isOverwrite && this.isExisted(instanceId))) {
            this.repository.persist(ComputeNode.getInstanceLabelsNodePath(instanceId), YamlEngine.marshal(labels));
        }
    }

    public void deleteInstanceLabels(String instanceId) {
        if (this.isExisted(instanceId)) {
            this.repository.delete(ComputeNode.getInstanceLabelsNodePath(instanceId));
        }
    }

    private boolean isExisted(String instanceId) {
        return !Strings.isNullOrEmpty((String)this.repository.get(ComputeNode.getInstanceLabelsNodePath(instanceId)));
    }

    public void persistInstanceWorkerId(String instanceId, Long workerId) {
        this.repository.persist(ComputeNode.getInstanceWorkerIdNodePath(instanceId), String.valueOf(workerId));
    }

    public void persistInstanceXaRecoveryId(String instanceId, String xaRecoveryId) {
        this.repository.persist(ComputeNode.getInstanceXaRecoveryIdNodePath(instanceId), xaRecoveryId);
    }

    public Collection<String> loadInstanceLabels(String instanceId) {
        String yamlContent = this.repository.get(ComputeNode.getInstanceLabelsNodePath(instanceId));
        return Strings.isNullOrEmpty((String)yamlContent) ? new ArrayList() : (Collection)YamlEngine.unmarshal((String)yamlContent, Collection.class);
    }

    public Collection<String> loadInstanceStatus(String instanceId) {
        String yamlContent = this.repository.get(ComputeNode.getInstanceStatusNodePath(instanceId));
        return Strings.isNullOrEmpty((String)yamlContent) ? new ArrayList() : (Collection)YamlEngine.unmarshal((String)yamlContent, Collection.class);
    }

    public Optional<Long> loadInstanceWorkerId(String instanceId) {
        try {
            String workerId = this.repository.get(ComputeNode.getInstanceWorkerIdNodePath(instanceId));
            return Strings.isNullOrEmpty((String)workerId) ? Optional.empty() : Optional.of(Long.valueOf(workerId));
        }
        catch (NumberFormatException ex) {
            log.error("Invalid worker id for instance: {}", (Object)instanceId);
            return Optional.empty();
        }
    }

    public Optional<String> loadXaRecoveryId(String instanceId) {
        return Optional.ofNullable(this.repository.get(ComputeNode.getInstanceXaRecoveryIdNodePath(instanceId)));
    }

    public Collection<ComputeNodeInstance> loadComputeNodeInstances(InstanceType instanceType, Collection<String> labels) {
        List<String> onlineComputeNodes = this.repository.getChildrenKeys(ComputeNode.getOnlineNodePath(instanceType));
        ArrayList<ComputeNodeInstance> result = new ArrayList<ComputeNodeInstance>(onlineComputeNodes.size());
        onlineComputeNodes.forEach(each -> {
            Collection<String> actualLabels = this.loadInstanceLabels((String)each);
            if (actualLabels.stream().anyMatch(labels::contains)) {
                ComputeNodeInstance instance = new ComputeNodeInstance(new InstanceDefinition(instanceType, each));
                instance.setLabels(actualLabels);
                instance.switchState(this.loadInstanceStatus((String)each));
                this.loadInstanceWorkerId((String)each).ifPresent(arg_0 -> ((ComputeNodeInstance)instance).setWorkerId(arg_0));
                result.add(instance);
            }
        });
        return result;
    }

    public Collection<ComputeNodeInstance> loadAllComputeNodeInstances() {
        ArrayList<ComputeNodeInstance> result = new ArrayList<ComputeNodeInstance>();
        Arrays.stream(InstanceType.values()).forEach(instanceType -> {
            List<String> onlineComputeNodes = this.repository.getChildrenKeys(ComputeNode.getOnlineNodePath(instanceType));
            onlineComputeNodes.forEach(each -> result.add(this.loadComputeNodeInstance(new InstanceDefinition(instanceType, each))));
        });
        return result;
    }

    public ComputeNodeInstance loadComputeNodeInstance(InstanceDefinition instanceDefinition) {
        ComputeNodeInstance result = new ComputeNodeInstance(instanceDefinition);
        result.setLabels(this.loadInstanceLabels(instanceDefinition.getInstanceId().getId()));
        result.switchState(this.loadInstanceStatus(instanceDefinition.getInstanceId().getId()));
        this.loadInstanceWorkerId(instanceDefinition.getInstanceId().getId()).ifPresent(arg_0 -> ((ComputeNodeInstance)result).setWorkerId(arg_0));
        this.loadXaRecoveryId(instanceDefinition.getInstanceId().getId()).ifPresent(arg_0 -> ((ComputeNodeInstance)result).setXaRecoveryId(arg_0));
        return result;
    }

    @Generated
    public ComputeNodePersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

