/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.shardingsphere.mode.metadata.persist.node.SchemaMetaDataNode;
import org.apache.shardingsphere.mode.persist.PersistRepository;

public final class SchemaVersionPersistService {
    private final PersistRepository repository;

    public Optional<String> getSchemaActiveVersion(String schemaName) {
        return Optional.ofNullable(this.repository.get(SchemaMetaDataNode.getActiveVersionPath(schemaName)));
    }

    public boolean isActiveVersion(String schemaName, String version) {
        Optional<String> actualVersion = this.getSchemaActiveVersion(schemaName);
        return actualVersion.isPresent() && actualVersion.get().equals(version);
    }

    public Optional<String> createNewVersion(String schemaName) {
        Optional<String> activeVersion = this.getSchemaActiveVersion(schemaName);
        if (activeVersion.isPresent()) {
            String newVersion = String.valueOf(new AtomicLong(Long.valueOf(activeVersion.get())).incrementAndGet());
            this.repository.persist(SchemaMetaDataNode.getRulePath(schemaName, newVersion), this.repository.get(SchemaMetaDataNode.getRulePath(schemaName, activeVersion.get())));
            this.repository.persist(SchemaMetaDataNode.getMetaDataDataSourcePath(schemaName, newVersion), this.repository.get(SchemaMetaDataNode.getMetaDataDataSourcePath(schemaName, activeVersion.get())));
            return Optional.of(newVersion);
        }
        return Optional.empty();
    }

    public void persistActiveVersion(String schemaName, String version) {
        Optional<String> activeVersion = this.getSchemaActiveVersion(schemaName);
        if (activeVersion.isPresent() && !activeVersion.get().equals(version)) {
            this.repository.persist(SchemaMetaDataNode.getActiveVersionPath(schemaName), version);
        }
    }

    public void deleteVersion(String schemaName, String version) {
        this.repository.delete(SchemaMetaDataNode.getSchemaVersionPath(schemaName, version));
    }

    @Generated
    public SchemaVersionPersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

