/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.algorithm;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.aware.DataSourceNameAware;
import org.apache.shardingsphere.infra.aware.DataSourceNameAwareFactory;
import org.apache.shardingsphere.readwritesplitting.spi.ReadwriteSplittingType;

public class DynamicReadwriteSplittingType
implements ReadwriteSplittingType {
    private Properties props = new Properties();
    private String autoAwareDataSourceName;

    public void init() {
        this.autoAwareDataSourceName = this.props.getProperty("auto-aware-data-source-name");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.autoAwareDataSourceName) ? 1 : 0) != 0, (Object)"auto aware data source name is required.");
    }

    public String getWriteDataSource() {
        Optional dataSourceNameAware = DataSourceNameAwareFactory.getInstance().getDataSourceNameAware();
        if (dataSourceNameAware.isPresent()) {
            return ((DataSourceNameAware)dataSourceNameAware.get()).getPrimaryDataSourceName(this.autoAwareDataSourceName);
        }
        return null;
    }

    public List<String> getReadDataSources() {
        Optional dataSourceNameAware = DataSourceNameAwareFactory.getInstance().getDataSourceNameAware();
        if (dataSourceNameAware.isPresent() && ((DataSourceNameAware)dataSourceNameAware.get()).getRule().isPresent()) {
            return new ArrayList<String>(((DataSourceNameAware)dataSourceNameAware.get()).getReplicaDataSourceNames(this.autoAwareDataSourceName));
        }
        return Collections.emptyList();
    }

    public Map<String, String> getDataSources() {
        Optional dataSourceNameAware = DataSourceNameAwareFactory.getInstance().getDataSourceNameAware();
        HashMap<String, String> result = new HashMap<String, String>(2, 1.0f);
        if (!Strings.isNullOrEmpty((String)this.autoAwareDataSourceName) && dataSourceNameAware.isPresent() && ((DataSourceNameAware)dataSourceNameAware.get()).getRule().isPresent()) {
            result.put("primary_data_source_name", ((DataSourceNameAware)dataSourceNameAware.get()).getPrimaryDataSourceName(this.autoAwareDataSourceName));
            result.put("replica_data_source_names", String.join((CharSequence)",", ((DataSourceNameAware)dataSourceNameAware.get()).getReplicaDataSourceNames(this.autoAwareDataSourceName)));
            return result;
        }
        return result;
    }

    public Map<String, Collection<String>> getDataSourceMapper(String name) {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>(1, 1.0f);
        LinkedList<String> actualDataSourceNames = new LinkedList<String>();
        Optional dataSourceNameAware = DataSourceNameAwareFactory.getInstance().getDataSourceNameAware();
        if (dataSourceNameAware.isPresent()) {
            actualDataSourceNames.add(((DataSourceNameAware)dataSourceNameAware.get()).getPrimaryDataSourceName(this.autoAwareDataSourceName));
            actualDataSourceNames.addAll(((DataSourceNameAware)dataSourceNameAware.get()).getReplicaDataSourceNames(this.autoAwareDataSourceName));
        }
        result.put(name, actualDataSourceNames);
        return result;
    }

    public String getType() {
        return "DYNAMIC";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }

    @Generated
    public String getAutoAwareDataSourceName() {
        return this.autoAwareDataSourceName;
    }
}

