/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.algorithm;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.readwritesplitting.spi.ReadwriteSplittingType;

public class StaticReadwriteSplittingType
implements ReadwriteSplittingType {
    private Properties props = new Properties();
    private String writeDataSourceName;
    private List<String> readDataSourceNames;

    public void init() {
        this.writeDataSourceName = this.props.getProperty("write-data-source-name");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.writeDataSourceName) ? 1 : 0) != 0, (Object)"Write data source name is required.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.props.getProperty("read-data-source-names")) ? 1 : 0) != 0, (Object)"Read data source names are required.");
        this.readDataSourceNames = Splitter.on((String)",").trimResults().splitToList((CharSequence)this.props.getProperty("read-data-source-names"));
    }

    public String getWriteDataSource() {
        return this.writeDataSourceName;
    }

    public List<String> getReadDataSources() {
        return this.readDataSourceNames;
    }

    public Map<String, String> getDataSources() {
        HashMap<String, String> result = new HashMap<String, String>(2, 1.0f);
        result.put("primary_data_source_name", this.writeDataSourceName);
        result.put("replica_data_source_names", Joiner.on((String)",").join(this.readDataSourceNames));
        return result;
    }

    public Map<String, Collection<String>> getDataSourceMapper(String name) {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>(1, 1.0f);
        LinkedList<String> actualDataSourceNames = new LinkedList<String>();
        actualDataSourceNames.add(this.writeDataSourceName);
        actualDataSourceNames.addAll(this.readDataSourceNames);
        result.put(name, actualDataSourceNames);
        return result;
    }

    public String getType() {
        return "STATIC";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

