/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.spi;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.ServiceLoader;

public final class NewInstanceServiceLoader {
    private static final Map<Class, Collection<Class<?>>> SERVICE_MAP = new HashMap();

    public static <T> void register(Class<T> service) {
        for (T each : ServiceLoader.load(service)) {
            NewInstanceServiceLoader.registerServiceClass(service, each);
        }
    }

    private static <T> void registerServiceClass(Class<T> service, T instance) {
        Collection<Class<?>> serviceClasses = SERVICE_MAP.get(service);
        if (null == serviceClasses) {
            serviceClasses = new LinkedHashSet();
        }
        serviceClasses.add(instance.getClass());
        SERVICE_MAP.put(service, serviceClasses);
    }

    public static <T> Collection<T> newServiceInstances(Class<T> service) {
        LinkedList result = new LinkedList();
        if (null == SERVICE_MAP.get(service)) {
            return result;
        }
        for (Class<?> each : SERVICE_MAP.get(service)) {
            result.add(each.newInstance());
        }
        return result;
    }

    private NewInstanceServiceLoader() {
    }
}

