/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.transaction.core.ResourceDataSource;
import org.apache.shardingsphere.transaction.core.TransactionType;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.spi.ShardingSphereTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShardingSphereTransactionManagerEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShardingSphereTransactionManagerEngine.class);
    private final Map<TransactionType, ShardingSphereTransactionManager> transactionManagers = new EnumMap<TransactionType, ShardingSphereTransactionManager>(TransactionType.class);

    public ShardingSphereTransactionManagerEngine() {
        this.loadTransactionManager();
    }

    private void loadTransactionManager() {
        for (ShardingSphereTransactionManager each : ShardingSphereServiceLoader.newServiceInstances(ShardingSphereTransactionManager.class)) {
            if (this.transactionManagers.containsKey((Object)each.getTransactionType())) {
                log.warn("Find more than one {} transaction manager implementation class, use `{}` now", (Object)each.getTransactionType(), (Object)this.transactionManagers.get((Object)each.getTransactionType()).getClass().getName());
                continue;
            }
            this.transactionManagers.put(each.getTransactionType(), each);
        }
    }

    public void init(DatabaseType databaseType, Map<String, DataSource> dataSourceMap, TransactionRule transactionRule) {
        this.transactionManagers.forEach((key, value) -> value.init(databaseType, this.getResourceDataSources(dataSourceMap), transactionRule));
    }

    private Collection<ResourceDataSource> getResourceDataSources(Map<String, DataSource> dataSourceMap) {
        return dataSourceMap.entrySet().stream().map(entry -> new ResourceDataSource((String)entry.getKey(), (DataSource)entry.getValue())).collect(Collectors.toList());
    }

    public ShardingSphereTransactionManager getTransactionManager(TransactionType transactionType) {
        ShardingSphereTransactionManager result = this.transactionManagers.get((Object)transactionType);
        if (TransactionType.LOCAL != transactionType) {
            Preconditions.checkNotNull((Object)result, (String)"Can not find transaction manager of `%s`", (Object)((Object)transactionType));
        }
        return result;
    }

    public void close() throws Exception {
        for (Map.Entry<TransactionType, ShardingSphereTransactionManager> entry : this.transactionManagers.entrySet()) {
            entry.getValue().close();
        }
    }

    static {
        ShardingSphereServiceLoader.register(ShardingSphereTransactionManager.class);
    }
}

