/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.tagging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.SegmentationFactory;
import org.apdplat.word.segmentation.Word;
import org.apdplat.word.util.AutoDetector;
import org.apdplat.word.util.GenericTrie;
import org.apdplat.word.util.ResourceLoader;
import org.apdplat.word.util.WordConfTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntonymTagging {
    private static final Logger LOGGER = LoggerFactory.getLogger(AntonymTagging.class);
    private static final GenericTrie<String[]> GENERIC_TRIE = new GenericTrie();

    private AntonymTagging() {
    }

    public static void reload() {
        AutoDetector.loadAndWatch(new ResourceLoader(){

            @Override
            public void clear() {
                GENERIC_TRIE.clear();
            }

            @Override
            public void load(List<String> list) {
                LOGGER.info("\u521d\u59cb\u5316Antonym");
                int n = 0;
                for (String string : list) {
                    try {
                        String[] stringArray = string.split("\\s+");
                        if (stringArray != null && stringArray.length > 1) {
                            this.addWords(stringArray);
                            ++n;
                            continue;
                        }
                        LOGGER.error("\u9519\u8bef\u7684Antonym\u6570\u636e\uff1a" + string);
                    }
                    catch (Exception exception) {
                        LOGGER.error("\u9519\u8bef\u7684Antonym\u6570\u636e\uff1a" + string);
                    }
                }
                LOGGER.info("Antonym\u521d\u59cb\u5316\u5b8c\u6bd5\uff0c\u6570\u636e\u6761\u6570\uff1a" + n);
            }

            @Override
            public void add(String string) {
                try {
                    String[] stringArray = string.split("\\s+");
                    if (stringArray != null && stringArray.length > 1) {
                        this.addWords(stringArray);
                    } else {
                        LOGGER.error("\u9519\u8bef\u7684Antonym\u6570\u636e\uff1a" + string);
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("\u9519\u8bef\u7684Antonym\u6570\u636e\uff1a" + string);
                }
            }

            @Override
            public void remove(String string) {
                try {
                    String[] stringArray = string.split("\\s+");
                    if (stringArray != null && stringArray.length > 1) {
                        for (String string2 : stringArray) {
                            GENERIC_TRIE.remove(string2.trim());
                        }
                    } else {
                        LOGGER.error("\u9519\u8bef\u7684Antonym\u6570\u636e\uff1a" + string);
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("\u9519\u8bef\u7684Antonym\u6570\u636e\uff1a" + string);
                }
            }

            private void addWords(String[] stringArray) {
                String string = stringArray[0];
                String[] stringArray2 = Arrays.copyOfRange(stringArray, 1, stringArray.length);
                this.addAntonym(string, stringArray2);
                for (String string2 : stringArray2) {
                    this.addAntonym(string2, string);
                }
            }

            private void addAntonym(String string, String ... stringArray) {
                String[] stringArray2 = (String[])GENERIC_TRIE.get(string);
                if (stringArray2 != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(string + " \u5df2\u7ecf\u6709\u5b58\u5728\u7684\u53cd\u4e49\u8bcd\uff1a");
                        for (String string2 : stringArray2) {
                            LOGGER.debug("\t" + string2);
                        }
                    }
                    String[] stringArray3 = new HashSet();
                    stringArray3.addAll(Arrays.asList(stringArray2));
                    stringArray3.addAll(Arrays.asList(stringArray));
                    String[] stringArray4 = stringArray3.toArray(new String[0]);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("\u5408\u5e76\u65b0\u7684\u53cd\u4e49\u8bcd\uff1a");
                        for (String string3 : stringArray) {
                            LOGGER.debug("\t" + string3);
                        }
                        LOGGER.debug("\u5408\u5e76\u7ed3\u679c\uff1a");
                        for (String string3 : stringArray4) {
                            LOGGER.debug("\t" + string3);
                        }
                    }
                    GENERIC_TRIE.put(string.trim(), stringArray4);
                } else {
                    GENERIC_TRIE.put(string.trim(), stringArray);
                }
            }
        }, WordConfTools.get("word.antonym.path", "classpath:word_antonym.txt"));
    }

    public static void process(List<Word> list) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5bf9\u5206\u8bcd\u7ed3\u679c\u8fdb\u884c\u53cd\u4e49\u6807\u6ce8\u4e4b\u524d\uff1a{}", list);
        }
        list.parallelStream().forEach(word -> AntonymTagging.process(word));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5bf9\u5206\u8bcd\u7ed3\u679c\u8fdb\u884c\u53cd\u4e49\u6807\u6ce8\u4e4b\u540e\uff1a{}", list);
        }
    }

    private static void process(Word word) {
        String[] stringArray = GENERIC_TRIE.get(word.getText());
        if (stringArray != null && stringArray.length > 1) {
            List<Word> list = AntonymTagging.toWord(stringArray);
            word.setAntonym(list);
        }
    }

    private static List<Word> toWord(String[] stringArray) {
        ArrayList<Word> arrayList = new ArrayList<Word>(stringArray.length);
        for (String string : stringArray) {
            arrayList.add(new Word(string));
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        List<Word> list = SegmentationFactory.getSegmentation(SegmentationAlgorithm.BidirectionalMaximumMatching).seg("5\u6708\u521d\u6709\u54ea\u4e9b\u7535\u5f71\u503c\u5f97\u89c2\u770b");
        System.out.println(list);
        AntonymTagging.process(list);
        System.out.println(list);
        list = SegmentationFactory.getSegmentation(SegmentationAlgorithm.BidirectionalMaximumMatching).seg("\u7531\u4e8e\u5de5\u4f5c\u4e0d\u5230\u4f4d\u3001\u670d\u52a1\u4e0d\u5b8c\u5584\u5bfc\u81f4\u987e\u5ba2\u5728\u7528\u9910\u65f6\u53d1\u751f\u4e0d\u6109\u5feb\u7684\u4e8b\u60c5,\u9910\u5385\u65b9\u9762\u5e94\u8be5\u5411\u987e\u5ba2\u4f5c\u51fa\u771f\u8bda\u7684\u9053\u6b49,\u800c\u4e0d\u662f\u6577\u884d\u4e86\u4e8b\u3002");
        System.out.println(list);
        AntonymTagging.process(list);
        System.out.println(list);
    }

    static {
        AntonymTagging.reload();
    }
}

