/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.plugin.tools;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.gmaven.feature.Feature;
import org.codehaus.gmaven.feature.Provider;
import org.codehaus.gmaven.feature.ProviderManager;
import org.codehaus.gmaven.feature.ProviderRegistry;
import org.codehaus.gmaven.feature.ProviderSelector;
import org.codehaus.gmaven.plugin.ProviderMojoSupport;

public class ProvidersMojo
extends ProviderMojoSupport {
    static final /* synthetic */ boolean $assertionsDisabled;

    protected void doExecute() throws Exception {
        if (this.log.isTraceEnabled()) {
            this.logEnvironment();
        }
        ProviderManager manager = this.getProviderManager();
        this.log.debug("Provider manager: {}", (Object)manager);
        ProviderRegistry registry = manager.getRegistry();
        this.log.debug("Provider registry: {}", (Object)registry);
        ProviderSelector selector = manager.getSelector();
        this.log.debug("Provider selector: {}", (Object)selector);
        Provider selected = null;
        Throwable selectFailure = null;
        try {
            selected = this.provider();
            this.log.debug("Selected: {}", (Object)selected);
        }
        catch (Throwable t) {
            this.log.debug("Selection failure: " + t, t);
            selectFailure = t;
        }
        this.log.info("");
        this.log.info("Provider selection: {}", (Object)this.getProviderSelection());
        this.log.info("");
        Map providers = registry.providers();
        if (providers == null || providers.isEmpty()) {
            this.log.info("No providers registered");
        } else {
            this.log.info("Found {} registered providers:", (Object)String.valueOf(providers.size()));
            Iterator iter = providers.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Provider provider = (Provider)providers.get(key);
                this.logProvider(provider, "    ");
                this.log.info("");
            }
            if (selected != null) {
                this.log.info("Selected provider:");
                this.log.info("    {}", (Object)selected);
            } else if (selectFailure != null) {
                this.log.info("No provider was selected; Failures occured while selecting: {}", (Object)selectFailure.toString());
            } else {
                this.log.info("No provider was selected and no failure was detected; The gods must be crazy...");
            }
        }
        this.log.info("");
    }

    protected void logEnvironment() {
        this.log.trace("ClassLoader '{}' Class-Path:", (Object)((Object)((Object)this)).getClass().getClassLoader());
        URL[] urls = ((URLClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getURLs();
        for (int i = 0; i < urls.length; ++i) {
            this.log.trace("    {}", (Object)urls[i]);
        }
        this.log.debug("Plugin Artifacts:");
        Iterator iter = this.pluginArtifactMap.keySet().iterator();
        while (iter.hasNext()) {
            this.log.trace("    {}", iter.next());
        }
    }

    private void logProvider(Provider provider, String pad) {
        if (!$assertionsDisabled && provider == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && pad == null) {
            throw new AssertionError();
        }
        this.log.info("{}{}", (Object)pad, (Object)provider);
        this.logFeatures(provider, pad + "    ");
    }

    private void logFeatures(Provider provider, String pad) {
        if (!$assertionsDisabled && provider == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && pad == null) {
            throw new AssertionError();
        }
        Collection features = provider.features();
        if (features.isEmpty()) {
            this.log.info("{}No features", (Object)pad);
        } else {
            this.log.info("{}Features:", (Object)pad);
            Iterator iter = features.iterator();
            while (iter.hasNext()) {
                Feature feature = (Feature)iter.next();
                this.log.info("{}    {}", (Object)pad, (Object)feature.key());
            }
        }
    }

    static {
        $assertionsDisabled = !ProvidersMojo.class.desiredAssertionStatus();
    }
}

