/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.facttemplates.FactTemplate;
import org.drools.core.facttemplates.FactTemplateObjectType;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.ObjectType;

public class FactTemplateTypeConf
implements ObjectTypeConf,
Externalizable {
    private static final long serialVersionUID = 510L;
    private transient InternalKnowledgeBase kBase;
    private ObjectType objectType;
    private FactTemplate factTemplate;
    private ObjectTypeNode concreteObjectTypeNode;
    private ObjectTypeNode[] cache;
    private boolean tmsEnabled;
    EntryPointId entryPoint;

    public FactTemplateTypeConf() {
    }

    public FactTemplateTypeConf(EntryPointId entryPoint, FactTemplate factTemplate, InternalKnowledgeBase kBase) {
        this.kBase = kBase;
        this.factTemplate = factTemplate;
        this.entryPoint = entryPoint;
        this.objectType = new FactTemplateObjectType(factTemplate);
        this.concreteObjectTypeNode = kBase.getRete().getObjectTypeNodes(entryPoint).get(this.objectType);
        this.cache = new ObjectTypeNode[]{this.concreteObjectTypeNode};
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.kBase = (InternalKnowledgeBase)in.readObject();
        this.factTemplate = (FactTemplate)in.readObject();
        this.concreteObjectTypeNode = (ObjectTypeNode)in.readObject();
        this.cache = (ObjectTypeNode[])in.readObject();
        this.objectType = (ObjectType)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.kBase);
        out.writeObject(this.factTemplate);
        out.writeObject(this.concreteObjectTypeNode);
        out.writeObject(this.cache);
        out.writeObject(this.objectType);
    }

    @Override
    public ObjectTypeNode getConcreteObjectTypeNode() {
        if (this.concreteObjectTypeNode == null) {
            this.concreteObjectTypeNode = this.kBase.getRete().getObjectTypeNodes(this.entryPoint).get(this.objectType);
        }
        return this.concreteObjectTypeNode;
    }

    @Override
    public ObjectTypeNode[] getObjectTypeNodes() {
        if (this.cache == null) {
            this.cache = new ObjectTypeNode[]{this.concreteObjectTypeNode};
        }
        return this.cache;
    }

    @Override
    public boolean isAssignableFrom(Object object) {
        return this.factTemplate.equals(object);
    }

    @Override
    public void resetCache() {
        this.cache = null;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public boolean isEvent() {
        return false;
    }

    @Override
    public boolean isTrait() {
        return false;
    }

    @Override
    public TypeDeclaration getTypeDeclaration() {
        return null;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public boolean isTMSEnabled() {
        return this.tmsEnabled;
    }

    @Override
    public boolean isTraitTMSEnabled() {
        return false;
    }

    @Override
    public void enableTMS() {
        this.tmsEnabled = true;
    }

    @Override
    public EntryPointId getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public String getTypeName() {
        return this.factTemplate.getName();
    }
}

