/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.spi;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.drools.core.WorkingMemory;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.CompiledInvoker;
import org.drools.core.spi.Invoker;
import org.drools.core.spi.Tuple;
import org.kie.internal.security.KiePolicyHelper;

public interface Accumulator
extends Invoker {
    public Object createWorkingMemoryContext();

    public Serializable createContext();

    public void init(Object var1, Object var2, Tuple var3, Declaration[] var4, WorkingMemory var5) throws Exception;

    public void accumulate(Object var1, Object var2, Tuple var3, InternalFactHandle var4, Declaration[] var5, Declaration[] var6, WorkingMemory var7) throws Exception;

    public boolean supportsReverse();

    public void reverse(Object var1, Object var2, Tuple var3, InternalFactHandle var4, Declaration[] var5, Declaration[] var6, WorkingMemory var7) throws Exception;

    public Object getResult(Object var1, Object var2, Tuple var3, Declaration[] var4, WorkingMemory var5) throws Exception;

    public static boolean isCompiledInvoker(Accumulator accumulator) {
        return accumulator instanceof CompiledInvoker || accumulator instanceof SafeAccumulator && ((SafeAccumulator)accumulator).wrapsCompiledInvoker();
    }

    public static class SafeAccumulator
    implements Accumulator,
    Serializable {
        private static final long serialVersionUID = -2845820209337318924L;
        private Accumulator delegate;

        public SafeAccumulator(Accumulator delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object createWorkingMemoryContext() {
            return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return delegate.createWorkingMemoryContext();
                }
            }, KiePolicyHelper.getAccessContext());
        }

        @Override
        public Serializable createContext() {
            return AccessController.doPrivileged(new PrivilegedAction<Serializable>(){

                @Override
                public Serializable run() {
                    return delegate.createContext();
                }
            }, KiePolicyHelper.getAccessContext());
        }

        @Override
        public void init(final Object workingMemoryContext, final Object context, final Tuple leftTuple, final Declaration[] declarations, final WorkingMemory workingMemory) throws Exception {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    delegate.init(workingMemoryContext, context, leftTuple, declarations, workingMemory);
                    return null;
                }
            }, KiePolicyHelper.getAccessContext());
        }

        @Override
        public void accumulate(final Object workingMemoryContext, final Object context, final Tuple leftTuple, final InternalFactHandle handle, final Declaration[] declarations, final Declaration[] innerDeclarations, final WorkingMemory workingMemory) throws Exception {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    delegate.accumulate(workingMemoryContext, context, leftTuple, handle, declarations, innerDeclarations, workingMemory);
                    return null;
                }
            }, KiePolicyHelper.getAccessContext());
        }

        @Override
        public boolean supportsReverse() {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return delegate.supportsReverse();
                }
            }, KiePolicyHelper.getAccessContext());
        }

        @Override
        public void reverse(final Object workingMemoryContext, final Object context, final Tuple leftTuple, final InternalFactHandle handle, final Declaration[] declarations, final Declaration[] innerDeclarations, final WorkingMemory workingMemory) throws Exception {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    delegate.reverse(workingMemoryContext, context, leftTuple, handle, declarations, innerDeclarations, workingMemory);
                    return null;
                }
            }, KiePolicyHelper.getAccessContext());
        }

        @Override
        public Object getResult(final Object workingMemoryContext, final Object context, final Tuple leftTuple, final Declaration[] declarations, final WorkingMemory workingMemory) throws Exception {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return delegate.getResult(workingMemoryContext, context, leftTuple, declarations, workingMemory);
                }
            }, KiePolicyHelper.getAccessContext());
        }

        public boolean wrapsCompiledInvoker() {
            return this.delegate instanceof CompiledInvoker;
        }
    }
}

