/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class HttpServletResponseBufferingWrapper
extends HttpServletResponseWrapper {
    private static int BUFFER_LIMIT = 0x100000;
    private static String ALREADY_COMMITTED_EXCEPTION = "The response has been already committed.";
    private boolean bufferResponse;
    private boolean committed;
    private String message;
    private int statusCode;
    private boolean sendError;
    private LimitingServletOutputStream outputStream;
    private PrintWriter printWriter;

    public HttpServletResponseBufferingWrapper(HttpServletResponse response) {
        super(response);
        this.resetBufferedResponse();
    }

    public void addCookie(Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        super.addCookie(cookie);
    }

    public void sendError(int sc) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(ALREADY_COMMITTED_EXCEPTION);
        }
        if (sc != 404) {
            super.sendError(sc);
        } else {
            this.bufferResponse = true;
            this.committed = true;
            this.sendError = true;
        }
        this.statusCode = sc;
    }

    public void sendError(int sc, String msg) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(ALREADY_COMMITTED_EXCEPTION);
        }
        if (sc != 404) {
            super.sendError(sc, msg);
        } else {
            this.bufferResponse = true;
            this.committed = true;
            this.message = msg;
            this.sendError = true;
        }
        this.statusCode = sc;
    }

    public void sendRedirect(String location) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(ALREADY_COMMITTED_EXCEPTION);
        }
        super.sendRedirect(location);
        this.statusCode = 307;
    }

    public void setDateHeader(String name, long date) {
        if (this.isCommitted()) {
            return;
        }
        super.setDateHeader(name, date);
    }

    public void addDateHeader(String name, long date) {
        if (this.isCommitted()) {
            return;
        }
        super.addDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        super.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        super.addHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        super.setIntHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        super.addIntHeader(name, value);
    }

    public void setStatus(int sc) {
        if (this.isCommitted()) {
            return;
        }
        if (sc != 404) {
            super.setStatus(sc);
        } else {
            this.bufferResponse = true;
        }
        this.statusCode = sc;
    }

    public void setStatus(int sc, String sm) {
        throw new UnsupportedOperationException("This method has been deprecated.");
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (!this.bufferResponse) {
            return super.getOutputStream();
        }
        if (this.outputStream == null) {
            this.outputStream = new LimitingServletOutputStream(BUFFER_LIMIT);
        }
        this.committed = true;
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (!this.bufferResponse) {
            return super.getWriter();
        }
        if (this.outputStream != null) {
            throw new IllegalStateException("Output buffer has been already obtained. You can use either output buffer or print writer at one time.");
        }
        if (this.printWriter == null) {
            this.printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), this.getCharacterEncoding()));
        }
        return this.printWriter;
    }

    public void flushBuffer() throws IOException {
        if (!this.bufferResponse) {
            super.flushBuffer();
        } else {
            this.committed = true;
        }
    }

    public boolean isCommitted() {
        return this.committed || super.isCommitted();
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException(ALREADY_COMMITTED_EXCEPTION);
        }
        if (!this.bufferResponse) {
            super.resetBuffer();
        } else if (this.outputStream != null) {
            this.outputStream.reset();
        }
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException(ALREADY_COMMITTED_EXCEPTION);
        }
        this.bufferResponse = false;
        this.message = null;
    }

    public void flushBufferedResponse() throws IOException {
        if (this.bufferResponse) {
            if (this.sendError) {
                try {
                    if (this.message != null) {
                        super.sendError(404, this.message);
                    }
                    super.setStatus(404);
                }
                catch (IOException e) {
                    throw new IllegalStateException("FATAL ERROR! This situation should never occur because it's a job of " + ((Object)((Object)this)).getClass().getName() + " class to " + "prevent such situation.");
                }
            } else if (this.message != null) {
                super.setStatus(404, this.message);
            } else {
                super.setStatus(404);
            }
            if (this.printWriter != null) {
                if (this.printWriter.checkError()) {
                    throw new IOException("Error occured while writing to printWriter.");
                }
                this.printWriter.close();
            }
            if (this.outputStream != null) {
                this.outputStream.writeTo((OutputStream)super.getOutputStream());
            }
        }
    }

    public void resetBufferedResponse() {
        if (super.isCommitted()) {
            throw new IllegalStateException(ALREADY_COMMITTED_EXCEPTION);
        }
        if (this.bufferResponse) {
            this.message = null;
            this.bufferResponse = false;
            this.committed = false;
            this.sendError = false;
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    private class LimitingServletOutputStream
    extends ServletOutputStream {
        private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
        private int writeLimit;
        private ByteArrayOutputStream outputStream;

        public LimitingServletOutputStream(int writeLimit) {
            this.writeLimit = writeLimit;
            this.reset();
        }

        public void write(int b) throws IOException {
            if (this.outputStream.size() >= this.writeLimit) {
                RuntimeException e = new RuntimeException("The buffering limit (" + this.writeLimit + ") has been reached. If you encounter this exception it means that you to " + "write a big response body for response that has error code set as status code. This is always a bad " + "idea and in such case you should reconsider your design.");
                this.log.fatal((Object)"Fatal error occured in writing to response", (Throwable)e);
                throw e;
            }
            this.outputStream.write(b);
        }

        public void reset() {
            this.outputStream = new ByteArrayOutputStream(this.writeLimit);
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            this.outputStream.writeTo(outputStream);
        }
    }
}

