/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.dircache;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.jgit.attributes.AttributesNode;
import org.eclipse.jgit.attributes.AttributesRule;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheTree;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.util.RawParseUtils;

public class DirCacheIterator
extends AbstractTreeIterator {
    private static final byte[] DOT_GIT_ATTRIBUTES_BYTES = ".gitattributes".getBytes();
    protected final DirCache cache;
    private final DirCacheTree tree;
    private final int treeStart;
    private final int treeEnd;
    private final byte[] subtreeId;
    protected int ptr;
    private int nextSubtreePos;
    protected DirCacheEntry currentEntry;
    protected DirCacheTree currentSubtree;
    private AttributesNode attributesNode;

    public DirCacheIterator(DirCache dc) {
        this.cache = dc;
        this.tree = dc.getCacheTree(true);
        this.treeStart = 0;
        this.treeEnd = this.tree.getEntrySpan();
        this.subtreeId = new byte[20];
        if (!this.eof()) {
            this.parseEntry();
        }
    }

    DirCacheIterator(DirCacheIterator p, DirCacheTree dct) {
        super(p, p.path, p.pathLen + 1);
        this.cache = p.cache;
        this.tree = dct;
        this.treeStart = p.ptr;
        this.treeEnd = this.treeStart + this.tree.getEntrySpan();
        this.subtreeId = p.subtreeId;
        this.ptr = p.ptr;
        this.parseEntry();
    }

    public AbstractTreeIterator createSubtreeIterator(ObjectReader reader) throws IncorrectObjectTypeException, IOException {
        if (this.currentSubtree == null) {
            throw new IncorrectObjectTypeException(this.getEntryObjectId(), "tree");
        }
        return new DirCacheIterator(this, this.currentSubtree);
    }

    public EmptyTreeIterator createEmptyTreeIterator() {
        byte[] n = new byte[Math.max(this.pathLen + 1, 128)];
        System.arraycopy(this.path, 0, n, 0, this.pathLen);
        n[this.pathLen] = 47;
        return new EmptyTreeIterator(this, n, this.pathLen + 1);
    }

    public boolean hasId() {
        if (this.currentSubtree != null) {
            return this.currentSubtree.isValid();
        }
        return this.currentEntry != null;
    }

    public byte[] idBuffer() {
        if (this.currentSubtree != null) {
            return this.currentSubtree.isValid() ? this.subtreeId : zeroid;
        }
        if (this.currentEntry != null) {
            return this.currentEntry.idBuffer();
        }
        return zeroid;
    }

    public int idOffset() {
        if (this.currentSubtree != null) {
            return 0;
        }
        if (this.currentEntry != null) {
            return this.currentEntry.idOffset();
        }
        return 0;
    }

    public void reset() {
        if (!this.first()) {
            this.ptr = this.treeStart;
            this.nextSubtreePos = 0;
            this.currentEntry = null;
            this.currentSubtree = null;
            if (!this.eof()) {
                this.parseEntry();
            }
        }
    }

    public boolean first() {
        return this.ptr == this.treeStart;
    }

    public boolean eof() {
        return this.ptr == this.treeEnd;
    }

    public void next(int delta) {
        while (--delta >= 0) {
            this.ptr = this.currentSubtree != null ? (this.ptr += this.currentSubtree.getEntrySpan()) : ++this.ptr;
            if (this.eof()) break;
            this.parseEntry();
        }
    }

    public void back(int delta) {
        while (--delta >= 0) {
            if (this.currentSubtree != null) {
                --this.nextSubtreePos;
            }
            --this.ptr;
            this.parseEntry(false);
            if (this.currentSubtree == null) continue;
            this.ptr -= this.currentSubtree.getEntrySpan() - 1;
        }
    }

    private void parseEntry() {
        this.parseEntry(true);
    }

    private void parseEntry(boolean forward) {
        DirCacheTree s;
        DirCacheTree p;
        this.currentEntry = this.cache.getEntry(this.ptr);
        byte[] cep = this.currentEntry.path;
        if (!forward && this.nextSubtreePos > 0 && (p = this.tree.getChild(this.nextSubtreePos - 1)).contains(cep, this.pathOffset, cep.length)) {
            --this.nextSubtreePos;
            this.currentSubtree = p;
        }
        if (this.nextSubtreePos != this.tree.getChildCount() && (s = this.tree.getChild(this.nextSubtreePos)).contains(cep, this.pathOffset, cep.length)) {
            this.currentSubtree = s;
            ++this.nextSubtreePos;
            if (s.isValid()) {
                s.getObjectId().copyRawTo(this.subtreeId, 0);
            }
            this.mode = FileMode.TREE.getBits();
            this.path = cep;
            this.pathLen = this.pathOffset + s.nameLength();
            return;
        }
        this.mode = this.currentEntry.getRawMode();
        this.path = cep;
        this.pathLen = cep.length;
        this.currentSubtree = null;
        if (RawParseUtils.match(this.path, this.pathOffset, DOT_GIT_ATTRIBUTES_BYTES) == this.path.length) {
            this.attributesNode = new LazyLoadingAttributesNode(this.currentEntry.getObjectId());
        }
    }

    public DirCacheEntry getDirCacheEntry() {
        return this.currentSubtree == null ? this.currentEntry : null;
    }

    public AttributesNode getEntryAttributesNode(ObjectReader reader) throws IOException {
        if (this.attributesNode instanceof LazyLoadingAttributesNode) {
            this.attributesNode = ((LazyLoadingAttributesNode)this.attributesNode).load(reader);
        }
        return this.attributesNode;
    }

    private static class LazyLoadingAttributesNode
    extends AttributesNode {
        final ObjectId objectId;

        LazyLoadingAttributesNode(ObjectId objectId) {
            super(Collections.<AttributesRule>emptyList());
            this.objectId = objectId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AttributesNode load(ObjectReader reader) throws IOException {
            AttributesNode r = new AttributesNode();
            ObjectLoader loader = reader.open(this.objectId);
            if (loader != null) {
                ObjectStream in = loader.openStream();
                try {
                    r.parse(in);
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    in.close();
                    throw throwable;
                }
                in.close();
                {
                }
            }
            return r.getRules().isEmpty() ? null : r;
        }
    }
}

